/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class SparkleDigest
implements Digest {
    private String algorithmName;
    private final int[] state;
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();
    private final int DIGEST_BYTES;
    private final int SPARKLE_STEPS_SLIM;
    private final int SPARKLE_STEPS_BIG;
    private final int STATE_BRANS;
    private final int STATE_WORDS;
    private final int RATE_WORDS;
    private final int RATE_BYTES;
    private static final int[] RCON = new int[]{-1209970334, -1083090816, 951376470, 844003128, -1156479509, 1333558103, -809524792, -1028445891};

    public SparkleDigest(SparkleParameters sparkleParameters) {
        int SPARKLE_STATE;
        int ESCH_DIGEST_LEN;
        int SPARKLE_RATE = 128;
        switch (sparkleParameters) {
            case ESCH256: {
                ESCH_DIGEST_LEN = 256;
                SPARKLE_STATE = 384;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.algorithmName = "ESCH-256";
                break;
            }
            case ESCH384: {
                ESCH_DIGEST_LEN = 384;
                SPARKLE_STATE = 512;
                this.SPARKLE_STEPS_SLIM = 8;
                this.SPARKLE_STEPS_BIG = 12;
                this.algorithmName = "ESCH-384";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.STATE_BRANS = SPARKLE_STATE >>> 6;
        this.STATE_WORDS = SPARKLE_STATE >>> 5;
        this.RATE_WORDS = SPARKLE_RATE >>> 5;
        this.RATE_BYTES = SPARKLE_RATE >>> 3;
        this.DIGEST_BYTES = ESCH_DIGEST_LEN >>> 3;
        this.state = new int[this.STATE_WORDS];
    }

    private int ROT(int x, int n) {
        return x >>> n | x << 32 - n;
    }

    private int ELL(int x) {
        return this.ROT(x ^ x << 16, 16);
    }

    private void sparkle_opt(int[] state, int brans, int steps) {
        for (int i = 0; i < steps; ++i) {
            int y0;
            int x0;
            int j;
            state[1] = state[1] ^ RCON[i & 7];
            state[3] = state[3] ^ i;
            for (j = 0; j < 2 * brans; j += 2) {
                int rc = RCON[j >>> 1];
                int n = j;
                state[n] = state[n] + this.ROT(state[j + 1], 31);
                int n2 = j + 1;
                state[n2] = state[n2] ^ this.ROT(state[j], 24);
                int n3 = j;
                state[n3] = state[n3] ^ rc;
                int n4 = j;
                state[n4] = state[n4] + this.ROT(state[j + 1], 17);
                int n5 = j + 1;
                state[n5] = state[n5] ^ this.ROT(state[j], 17);
                int n6 = j;
                state[n6] = state[n6] ^ rc;
                int n7 = j;
                state[n7] = state[n7] + state[j + 1];
                int n8 = j + 1;
                state[n8] = state[n8] ^ this.ROT(state[j], 31);
                int n9 = j;
                state[n9] = state[n9] ^ rc;
                int n10 = j;
                state[n10] = state[n10] + this.ROT(state[j + 1], 24);
                int n11 = j + 1;
                state[n11] = state[n11] ^ this.ROT(state[j], 16);
                int n12 = j;
                state[n12] = state[n12] ^ rc;
            }
            int tmpx = x0 = state[0];
            int tmpy = y0 = state[1];
            for (j = 2; j < brans; j += 2) {
                tmpx ^= state[j];
                tmpy ^= state[j + 1];
            }
            tmpx = this.ELL(tmpx);
            tmpy = this.ELL(tmpy);
            for (j = 2; j < brans; j += 2) {
                state[j - 2] = state[j + brans] ^ state[j] ^ tmpy;
                state[j + brans] = state[j];
                state[j - 1] = state[j + brans + 1] ^ state[j + 1] ^ tmpx;
                state[j + brans + 1] = state[j + 1];
            }
            state[brans - 2] = state[brans] ^ x0 ^ tmpy;
            state[brans] = x0;
            state[brans - 1] = state[brans + 1] ^ y0 ^ tmpx;
            state[brans + 1] = y0;
        }
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getDigestSize() {
        return this.DIGEST_BYTES;
    }

    public void update(byte input) {
        this.message.write(input);
    }

    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException(this.algorithmName + " input buffer too short");
        }
        this.message.write(input, inOff, len);
    }

    public int doFinal(byte[] output, int outOff) {
        int i;
        int tmpy;
        int tmpx;
        if (outOff + this.DIGEST_BYTES > output.length) {
            throw new OutputLengthException(this.algorithmName + " input buffer too short");
        }
        byte[] input = this.message.toByteArray();
        int inlen = input.length;
        int inOff = 0;
        int[] in32 = Pack.littleEndianToInt(input, 0, inlen >> 2);
        while (inlen > this.RATE_BYTES) {
            tmpx = 0;
            tmpy = 0;
            for (i = 0; i < this.RATE_WORDS; i += 2) {
                tmpx ^= in32[i + (inOff >> 2)];
                tmpy ^= in32[i + 1 + (inOff >> 2)];
            }
            tmpx = this.ELL(tmpx);
            tmpy = this.ELL(tmpy);
            for (i = 0; i < this.RATE_WORDS; i += 2) {
                int n = i;
                this.state[n] = this.state[n] ^ (in32[i + (inOff >> 2)] ^ tmpy);
                int n2 = i + 1;
                this.state[n2] = this.state[n2] ^ (in32[i + 1 + (inOff >> 2)] ^ tmpx);
            }
            for (i = this.RATE_WORDS; i < this.STATE_WORDS / 2; i += 2) {
                int n = i;
                this.state[n] = this.state[n] ^ tmpy;
                int n3 = i + 1;
                this.state[n3] = this.state[n3] ^ tmpx;
            }
            this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_SLIM);
            inlen -= this.RATE_BYTES;
            inOff += this.RATE_BYTES;
        }
        int n = this.STATE_BRANS - 1;
        this.state[n] = this.state[n] ^ (inlen < this.RATE_BYTES ? 0x1000000 : 0x2000000);
        int[] buffer = new int[this.RATE_WORDS];
        for (i = 0; i < inlen; ++i) {
            int n4 = i >>> 2;
            buffer[n4] = buffer[n4] | (input[inOff++] & 0xFF) << ((i & 3) << 3);
        }
        if (inlen < this.RATE_BYTES) {
            int n5 = i >>> 2;
            buffer[n5] = buffer[n5] | 128 << ((i & 3) << 3);
        }
        tmpx = 0;
        tmpy = 0;
        for (i = 0; i < this.RATE_WORDS; i += 2) {
            tmpx ^= buffer[i];
            tmpy ^= buffer[i + 1];
        }
        tmpx = this.ELL(tmpx);
        tmpy = this.ELL(tmpy);
        for (i = 0; i < this.RATE_WORDS; i += 2) {
            int n6 = i;
            this.state[n6] = this.state[n6] ^ (buffer[i] ^ tmpy);
            int n7 = i + 1;
            this.state[n7] = this.state[n7] ^ (buffer[i + 1] ^ tmpx);
        }
        for (i = this.RATE_WORDS; i < this.STATE_WORDS / 2; i += 2) {
            int n8 = i;
            this.state[n8] = this.state[n8] ^ tmpy;
            int n9 = i + 1;
            this.state[n9] = this.state[n9] ^ tmpx;
        }
        this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_BIG);
        Pack.intToLittleEndian(this.state, 0, this.RATE_WORDS, output, outOff);
        int outlen = this.RATE_BYTES;
        outOff += this.RATE_BYTES;
        while (outlen < this.DIGEST_BYTES) {
            this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_SLIM);
            Pack.intToLittleEndian(this.state, 0, this.RATE_WORDS, output, outOff);
            outlen += this.RATE_BYTES;
            outOff += this.RATE_BYTES;
        }
        return this.DIGEST_BYTES;
    }

    public void reset() {
        Arrays.fill(this.state, 0);
        this.message.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SparkleParameters {
        ESCH256,
        ESCH384;

    }
}

