/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.LazyConstructionEnumeration;
import org.bouncycastle.asn1.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyEncodedSequence
extends ASN1Sequence {
    private byte[] encoded;

    LazyEncodedSequence(byte[] encoded) throws IOException {
        this.encoded = encoded;
    }

    @Override
    public synchronized ASN1Encodable getObjectAt(int index) {
        this.force();
        return super.getObjectAt(index);
    }

    @Override
    public synchronized Enumeration getObjects() {
        if (null != this.encoded) {
            return new LazyConstructionEnumeration(this.encoded);
        }
        return super.getObjects();
    }

    @Override
    public synchronized int hashCode() {
        this.force();
        return super.hashCode();
    }

    @Override
    public synchronized Iterator<ASN1Encodable> iterator() {
        this.force();
        return super.iterator();
    }

    @Override
    public synchronized int size() {
        this.force();
        return super.size();
    }

    @Override
    public synchronized ASN1Encodable[] toArray() {
        this.force();
        return super.toArray();
    }

    @Override
    ASN1Encodable[] toArrayInternal() {
        this.force();
        return super.toArrayInternal();
    }

    @Override
    synchronized int encodedLength() throws IOException {
        if (null != this.encoded) {
            return 1 + StreamUtil.calculateBodyLength(this.encoded.length) + this.encoded.length;
        }
        return super.toDLObject().encodedLength();
    }

    @Override
    synchronized void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        if (null != this.encoded) {
            out.writeEncoded(withTag, 48, this.encoded);
        } else {
            super.toDLObject().encode(out, withTag);
        }
    }

    @Override
    synchronized ASN1Primitive toDERObject() {
        this.force();
        return super.toDERObject();
    }

    @Override
    synchronized ASN1Primitive toDLObject() {
        this.force();
        return super.toDLObject();
    }

    private void force() {
        if (null != this.encoded) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            LazyConstructionEnumeration en = new LazyConstructionEnumeration(this.encoded);
            while (en.hasMoreElements()) {
                v.add((ASN1Primitive)en.nextElement());
            }
            this.elements = v.takeElements();
            this.encoded = null;
        }
    }
}

