/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.crypto.digests.SHAKEDigest;

class Shake256RandomGenerator {
    private final SHAKEDigest digest = new SHAKEDigest(256);

    public Shake256RandomGenerator(byte[] seed, byte domain) {
        this.digest.update(seed, 0, seed.length);
        this.digest.update(domain);
    }

    public Shake256RandomGenerator(byte[] seed, int off, int len, byte domain) {
        this.digest.update(seed, off, len);
        this.digest.update(domain);
    }

    public void init(byte[] seed, int off, int len, byte domain) {
        this.digest.reset();
        this.digest.update(seed, off, len);
        this.digest.update(domain);
    }

    public void nextBytes(byte[] bytes) {
        this.digest.doOutput(bytes, 0, bytes.length);
    }

    public void nextBytes(byte[] output, int off, int len) {
        this.digest.doOutput(output, off, len);
    }

    public void xofGetBytes(byte[] output, int outLen) {
        int remainder = outLen & 7;
        int tmpLen = outLen - remainder;
        this.digest.doOutput(output, 0, tmpLen);
        if (remainder != 0) {
            byte[] tmp = new byte[8];
            this.digest.doOutput(tmp, 0, 8);
            System.arraycopy(tmp, 0, output, tmpLen, remainder);
        }
    }
}

