/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.falcon.FPREngine;
import org.bouncycastle.pqc.crypto.falcon.FalconCommon;
import org.bouncycastle.pqc.crypto.falcon.FalconFFT;
import org.bouncycastle.pqc.crypto.falcon.SamplerCtx;
import org.bouncycastle.pqc.crypto.falcon.SamplerZ;

class FalconSign {
    FalconSign() {
    }

    void smallints_to_fpr(double[] srcr, int r, byte[] srct, int logn) {
        int n = 1 << logn;
        for (int u = 0; u < n; ++u) {
            srcr[r + u] = srct[u];
        }
    }

    void ffSampling_fft_dyntree(SamplerCtx samp_ctx, double[] srct0, int t0, double[] srct1, int t1, double[] srcg00, int g00, double[] srcg01, int g01, double[] srcg11, int g11, int orig_logn, int logn, double[] srctmp, int tmp) {
        if (logn == 0) {
            double leaf = srcg00[g00];
            leaf = Math.sqrt(leaf) * FPREngine.fpr_inv_sigma[orig_logn];
            srct0[t0] = SamplerZ.sample(samp_ctx, srct0[t0], leaf);
            srct1[t1] = SamplerZ.sample(samp_ctx, srct1[t1], leaf);
            return;
        }
        int n = 1 << logn;
        int hn = n >> 1;
        FalconFFT.poly_LDL_fft(srcg00, g00, srcg01, g01, srcg11, g11, logn);
        FalconFFT.poly_split_fft(srctmp, tmp, srctmp, tmp + hn, srcg00, g00, logn);
        System.arraycopy(srctmp, tmp, srcg00, g00, n);
        FalconFFT.poly_split_fft(srctmp, tmp, srctmp, tmp + hn, srcg11, g11, logn);
        System.arraycopy(srctmp, tmp, srcg11, g11, n);
        System.arraycopy(srcg01, g01, srctmp, tmp, n);
        System.arraycopy(srcg00, g00, srcg01, g01, hn);
        System.arraycopy(srcg11, g11, srcg01, g01 + hn, hn);
        int z1 = tmp + n;
        FalconFFT.poly_split_fft(srctmp, z1, srctmp, z1 + hn, srct1, t1, logn);
        this.ffSampling_fft_dyntree(samp_ctx, srctmp, z1, srctmp, z1 + hn, srcg11, g11, srcg11, g11 + hn, srcg01, g01 + hn, orig_logn, logn - 1, srctmp, z1 + n);
        FalconFFT.poly_merge_fft(srctmp, tmp + (n << 1), srctmp, z1, srctmp, z1 + hn, logn);
        System.arraycopy(srct1, t1, srctmp, z1, n);
        FalconFFT.poly_sub(srctmp, z1, srctmp, tmp + (n << 1), logn);
        System.arraycopy(srctmp, tmp + (n << 1), srct1, t1, n);
        FalconFFT.poly_mul_fft(srctmp, tmp, srctmp, z1, logn);
        FalconFFT.poly_add(srct0, t0, srctmp, tmp, logn);
        int z0 = tmp;
        FalconFFT.poly_split_fft(srctmp, z0, srctmp, z0 + hn, srct0, t0, logn);
        this.ffSampling_fft_dyntree(samp_ctx, srctmp, z0, srctmp, z0 + hn, srcg00, g00, srcg00, g00 + hn, srcg01, g01, orig_logn, logn - 1, srctmp, z0 + n);
        FalconFFT.poly_merge_fft(srct0, t0, srctmp, z0, srctmp, z0 + hn, logn);
    }

    int do_sign_dyn(SamplerCtx samp_ctx, short[] srcs2, byte[] srcf, byte[] srcg, byte[] srcF, byte[] srcG, short[] srchm, int logn, double[] srctmp, int tmp) {
        int u;
        int n = 1 << logn;
        int b00 = tmp;
        int b01 = b00 + n;
        int b10 = b01 + n;
        int b11 = b10 + n;
        this.smallints_to_fpr(srctmp, b01, srcf, logn);
        this.smallints_to_fpr(srctmp, b00, srcg, logn);
        this.smallints_to_fpr(srctmp, b11, srcF, logn);
        this.smallints_to_fpr(srctmp, b10, srcG, logn);
        FalconFFT.FFT(srctmp, b01, logn);
        FalconFFT.FFT(srctmp, b00, logn);
        FalconFFT.FFT(srctmp, b11, logn);
        FalconFFT.FFT(srctmp, b10, logn);
        FalconFFT.poly_neg(srctmp, b01, logn);
        FalconFFT.poly_neg(srctmp, b11, logn);
        int t0 = b11 + n;
        int t1 = t0 + n;
        System.arraycopy(srctmp, b01, srctmp, t0, n);
        FalconFFT.poly_mulselfadj_fft(srctmp, t0, logn);
        System.arraycopy(srctmp, b00, srctmp, t1, n);
        FalconFFT.poly_muladj_fft(srctmp, t1, srctmp, b10, logn);
        FalconFFT.poly_mulselfadj_fft(srctmp, b00, logn);
        FalconFFT.poly_add(srctmp, b00, srctmp, t0, logn);
        System.arraycopy(srctmp, b01, srctmp, t0, n);
        FalconFFT.poly_muladj_fft(srctmp, b01, srctmp, b11, logn);
        FalconFFT.poly_add(srctmp, b01, srctmp, t1, logn);
        FalconFFT.poly_mulselfadj_fft(srctmp, b10, logn);
        System.arraycopy(srctmp, b11, srctmp, t1, n);
        FalconFFT.poly_mulselfadj_fft(srctmp, t1, logn);
        FalconFFT.poly_add(srctmp, b10, srctmp, t1, logn);
        int g00 = b00;
        int g01 = b01;
        int g11 = b10;
        b01 = t0;
        t0 = b01 + n;
        t1 = t0 + n;
        for (u = 0; u < n; ++u) {
            srctmp[t0 + u] = srchm[u];
        }
        FalconFFT.FFT(srctmp, t0, logn);
        double ni = 8.137358613394092E-5;
        System.arraycopy(srctmp, t0, srctmp, t1, n);
        FalconFFT.poly_mul_fft(srctmp, t1, srctmp, b01, logn);
        FalconFFT.poly_mulconst(srctmp, t1, -ni, logn);
        FalconFFT.poly_mul_fft(srctmp, t0, srctmp, b11, logn);
        FalconFFT.poly_mulconst(srctmp, t0, ni, logn);
        System.arraycopy(srctmp, t0, srctmp, b11, 2 * n);
        t0 = g11 + n;
        t1 = t0 + n;
        this.ffSampling_fft_dyntree(samp_ctx, srctmp, t0, srctmp, t1, srctmp, g00, srctmp, g01, srctmp, g11, logn, logn, srctmp, t1 + n);
        b01 = b00 + n;
        b10 = b01 + n;
        b11 = b10 + n;
        System.arraycopy(srctmp, t0, srctmp, b11 + n, n * 2);
        t0 = b11 + n;
        t1 = t0 + n;
        this.smallints_to_fpr(srctmp, b01, srcf, logn);
        this.smallints_to_fpr(srctmp, b00, srcg, logn);
        this.smallints_to_fpr(srctmp, b11, srcF, logn);
        this.smallints_to_fpr(srctmp, b10, srcG, logn);
        FalconFFT.FFT(srctmp, b01, logn);
        FalconFFT.FFT(srctmp, b00, logn);
        FalconFFT.FFT(srctmp, b11, logn);
        FalconFFT.FFT(srctmp, b10, logn);
        FalconFFT.poly_neg(srctmp, b01, logn);
        FalconFFT.poly_neg(srctmp, b11, logn);
        int tx = t1 + n;
        int ty = tx + n;
        System.arraycopy(srctmp, t0, srctmp, tx, n);
        System.arraycopy(srctmp, t1, srctmp, ty, n);
        FalconFFT.poly_mul_fft(srctmp, tx, srctmp, b00, logn);
        FalconFFT.poly_mul_fft(srctmp, ty, srctmp, b10, logn);
        FalconFFT.poly_add(srctmp, tx, srctmp, ty, logn);
        System.arraycopy(srctmp, t0, srctmp, ty, n);
        FalconFFT.poly_mul_fft(srctmp, ty, srctmp, b01, logn);
        System.arraycopy(srctmp, tx, srctmp, t0, n);
        FalconFFT.poly_mul_fft(srctmp, t1, srctmp, b11, logn);
        FalconFFT.poly_add(srctmp, t1, srctmp, ty, logn);
        FalconFFT.iFFT(srctmp, t0, logn);
        FalconFFT.iFFT(srctmp, t1, logn);
        int sqn = 0;
        int ng = 0;
        for (u = 0; u < n; ++u) {
            int z = (srchm[u] & 0xFFFF) - (int)FPREngine.fpr_rint(srctmp[t0 + u]);
            ng |= (sqn += z * z);
        }
        sqn |= -(ng >>> 31);
        short[] s2tmp = new short[n];
        for (u = 0; u < n; ++u) {
            s2tmp[u] = (short)(-FPREngine.fpr_rint(srctmp[t1 + u]));
        }
        if (FalconCommon.is_short_half(sqn, s2tmp, logn) != 0) {
            System.arraycopy(s2tmp, 0, srcs2, 0, n);
            return 1;
        }
        return 0;
    }

    void sign_dyn(short[] srcsig, SHAKEDigest rng, byte[] srcf, byte[] srcg, byte[] srcF, byte[] srcG, short[] srchm, int logn, double[] srctmp) {
        SamplerCtx spc;
        int ftmp = 0;
        do {
            spc = new SamplerCtx();
            spc.sigma_min = FPREngine.fpr_sigma_min[logn];
            spc.p.prng_init(rng);
        } while (this.do_sign_dyn(spc, srcsig, srcf, srcg, srcF, srcG, srchm, logn, srctmp, ftmp) == 0);
    }
}

