/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.falcon.FPREngine;
import org.bouncycastle.pqc.crypto.falcon.FalconCodec;
import org.bouncycastle.pqc.crypto.falcon.FalconFFT;
import org.bouncycastle.pqc.crypto.falcon.FalconSmallPrimeList;
import org.bouncycastle.pqc.crypto.falcon.FalconVrfy;
import org.bouncycastle.util.Pack;

class FalconKeyGen {
    private static final short[] REV10 = new short[]{0, 512, 256, 768, 128, 640, 384, 896, 64, 576, 320, 832, 192, 704, 448, 960, 32, 544, 288, 800, 160, 672, 416, 928, 96, 608, 352, 864, 224, 736, 480, 992, 16, 528, 272, 784, 144, 656, 400, 912, 80, 592, 336, 848, 208, 720, 464, 976, 48, 560, 304, 816, 176, 688, 432, 944, 112, 624, 368, 880, 240, 752, 496, 1008, 8, 520, 264, 776, 136, 648, 392, 904, 72, 584, 328, 840, 200, 712, 456, 968, 40, 552, 296, 808, 168, 680, 424, 936, 104, 616, 360, 872, 232, 744, 488, 1000, 24, 536, 280, 792, 152, 664, 408, 920, 88, 600, 344, 856, 216, 728, 472, 984, 56, 568, 312, 824, 184, 696, 440, 952, 120, 632, 376, 888, 248, 760, 504, 1016, 4, 516, 260, 772, 132, 644, 388, 900, 68, 580, 324, 836, 196, 708, 452, 964, 36, 548, 292, 804, 164, 676, 420, 932, 100, 612, 356, 868, 228, 740, 484, 996, 20, 532, 276, 788, 148, 660, 404, 916, 84, 596, 340, 852, 212, 724, 468, 980, 52, 564, 308, 820, 180, 692, 436, 948, 116, 628, 372, 884, 244, 756, 500, 1012, 12, 524, 268, 780, 140, 652, 396, 908, 76, 588, 332, 844, 204, 716, 460, 972, 44, 556, 300, 812, 172, 684, 428, 940, 108, 620, 364, 876, 236, 748, 492, 1004, 28, 540, 284, 796, 156, 668, 412, 924, 92, 604, 348, 860, 220, 732, 476, 988, 60, 572, 316, 828, 188, 700, 444, 956, 124, 636, 380, 892, 252, 764, 508, 1020, 2, 514, 258, 770, 130, 642, 386, 898, 66, 578, 322, 834, 194, 706, 450, 962, 34, 546, 290, 802, 162, 674, 418, 930, 98, 610, 354, 866, 226, 738, 482, 994, 18, 530, 274, 786, 146, 658, 402, 914, 82, 594, 338, 850, 210, 722, 466, 978, 50, 562, 306, 818, 178, 690, 434, 946, 114, 626, 370, 882, 242, 754, 498, 1010, 10, 522, 266, 778, 138, 650, 394, 906, 74, 586, 330, 842, 202, 714, 458, 970, 42, 554, 298, 810, 170, 682, 426, 938, 106, 618, 362, 874, 234, 746, 490, 1002, 26, 538, 282, 794, 154, 666, 410, 922, 90, 602, 346, 858, 218, 730, 474, 986, 58, 570, 314, 826, 186, 698, 442, 954, 122, 634, 378, 890, 250, 762, 506, 1018, 6, 518, 262, 774, 134, 646, 390, 902, 70, 582, 326, 838, 198, 710, 454, 966, 38, 550, 294, 806, 166, 678, 422, 934, 102, 614, 358, 870, 230, 742, 486, 998, 22, 534, 278, 790, 150, 662, 406, 918, 86, 598, 342, 854, 214, 726, 470, 982, 54, 566, 310, 822, 182, 694, 438, 950, 118, 630, 374, 886, 246, 758, 502, 1014, 14, 526, 270, 782, 142, 654, 398, 910, 78, 590, 334, 846, 206, 718, 462, 974, 46, 558, 302, 814, 174, 686, 430, 942, 110, 622, 366, 878, 238, 750, 494, 1006, 30, 542, 286, 798, 158, 670, 414, 926, 94, 606, 350, 862, 222, 734, 478, 990, 62, 574, 318, 830, 190, 702, 446, 958, 126, 638, 382, 894, 254, 766, 510, 1022, 1, 513, 257, 769, 129, 641, 385, 897, 65, 577, 321, 833, 193, 705, 449, 961, 33, 545, 289, 801, 161, 673, 417, 929, 97, 609, 353, 865, 225, 737, 481, 993, 17, 529, 273, 785, 145, 657, 401, 913, 81, 593, 337, 849, 209, 721, 465, 977, 49, 561, 305, 817, 177, 689, 433, 945, 113, 625, 369, 881, 241, 753, 497, 1009, 9, 521, 265, 777, 137, 649, 393, 905, 73, 585, 329, 841, 201, 713, 457, 969, 41, 553, 297, 809, 169, 681, 425, 937, 105, 617, 361, 873, 233, 745, 489, 1001, 25, 537, 281, 793, 153, 665, 409, 921, 89, 601, 345, 857, 217, 729, 473, 985, 57, 569, 313, 825, 185, 697, 441, 953, 121, 633, 377, 889, 249, 761, 505, 1017, 5, 517, 261, 773, 133, 645, 389, 901, 69, 581, 325, 837, 197, 709, 453, 965, 37, 549, 293, 805, 165, 677, 421, 933, 101, 613, 357, 869, 229, 741, 485, 997, 21, 533, 277, 789, 149, 661, 405, 917, 85, 597, 341, 853, 213, 725, 469, 981, 53, 565, 309, 821, 181, 693, 437, 949, 117, 629, 373, 885, 245, 757, 501, 1013, 13, 525, 269, 781, 141, 653, 397, 909, 77, 589, 333, 845, 205, 717, 461, 973, 45, 557, 301, 813, 173, 685, 429, 941, 109, 621, 365, 877, 237, 749, 493, 1005, 29, 541, 285, 797, 157, 669, 413, 925, 93, 605, 349, 861, 221, 733, 477, 989, 61, 573, 317, 829, 189, 701, 445, 957, 125, 637, 381, 893, 253, 765, 509, 1021, 3, 515, 259, 771, 131, 643, 387, 899, 67, 579, 323, 835, 195, 707, 451, 963, 35, 547, 291, 803, 163, 675, 419, 931, 99, 611, 355, 867, 227, 739, 483, 995, 19, 531, 275, 787, 147, 659, 403, 915, 83, 595, 339, 851, 211, 723, 467, 979, 51, 563, 307, 819, 179, 691, 435, 947, 115, 627, 371, 883, 243, 755, 499, 1011, 11, 523, 267, 779, 139, 651, 395, 907, 75, 587, 331, 843, 203, 715, 459, 971, 43, 555, 299, 811, 171, 683, 427, 939, 107, 619, 363, 875, 235, 747, 491, 1003, 27, 539, 283, 795, 155, 667, 411, 923, 91, 603, 347, 859, 219, 731, 475, 987, 59, 571, 315, 827, 187, 699, 443, 955, 123, 635, 379, 891, 251, 763, 507, 1019, 7, 519, 263, 775, 135, 647, 391, 903, 71, 583, 327, 839, 199, 711, 455, 967, 39, 551, 295, 807, 167, 679, 423, 935, 103, 615, 359, 871, 231, 743, 487, 999, 23, 535, 279, 791, 151, 663, 407, 919, 87, 599, 343, 855, 215, 727, 471, 983, 55, 567, 311, 823, 183, 695, 439, 951, 119, 631, 375, 887, 247, 759, 503, 1015, 15, 527, 271, 783, 143, 655, 399, 911, 79, 591, 335, 847, 207, 719, 463, 975, 47, 559, 303, 815, 175, 687, 431, 943, 111, 623, 367, 879, 239, 751, 495, 1007, 31, 543, 287, 799, 159, 671, 415, 927, 95, 607, 351, 863, 223, 735, 479, 991, 63, 575, 319, 831, 191, 703, 447, 959, 127, 639, 383, 895, 255, 767, 511, 1023};
    private static final long[] gauss_1024_12289 = new long[]{1283868770400643928L, 6416574995475331444L, 4078260278032692663L, 2353523259288686585L, 1227179971273316331L, 575931623374121527L, 242543240509105209L, 91437049221049666L, 30799446349977173L, 9255276791179340L, 2478152334826140L, 590642893610164L, 125206034929641L, 23590435911403L, 3948334035941L, 586753615614L, 77391054539L, 9056793210L, 940121950L, 86539696L, 7062824L, 510971L, 32764L, 1862L, 94L, 4L, 0L};
    private static final int[] MAX_BL_SMALL = new int[]{1, 1, 2, 2, 4, 7, 14, 27, 53, 106, 209};
    private static final int[] MAX_BL_LARGE = new int[]{2, 2, 5, 7, 12, 21, 40, 78, 157, 308};
    private static final int[] bitlength_avg = new int[]{4, 11, 24, 50, 102, 202, 401, 794, 1577, 3138, 6308};
    private static final int[] bitlength_std = new int[]{0, 1, 1, 1, 1, 2, 4, 5, 8, 13, 25};
    private static final int DEPTH_INT_FG = 4;

    FalconKeyGen() {
    }

    private static int mkn(int logn) {
        return 1 << logn;
    }

    private static int modp_set(int x, int p) {
        int w = x;
        w += p & -(w >>> 31);
        return w;
    }

    private static int modp_norm(int x, int p) {
        return x - (p & (x - (p + 1 >>> 1) >>> 31) - 1);
    }

    private static int modp_ninv31(int p) {
        int y = 2 - p;
        y *= 2 - p * y;
        y *= 2 - p * y;
        y *= 2 - p * y;
        y *= 2 - p * y;
        return Integer.MAX_VALUE & -y;
    }

    private static int modp_R(int p) {
        return Integer.MIN_VALUE - p;
    }

    private static int modp_add(int a, int b, int p) {
        int d = a + b - p;
        d += p & -(d >>> 31);
        return d;
    }

    private static int modp_sub(int a, int b, int p) {
        int d = a - b;
        d += p & -(d >>> 31);
        return d;
    }

    private static int modp_montymul(int a, int b, int p, int p0i) {
        long z = FalconKeyGen.toUnsignedLong(a) * FalconKeyGen.toUnsignedLong(b);
        long w = (z * (long)p0i & Integer.MAX_VALUE) * (long)p;
        int d = (int)(z + w >>> 31) - p;
        d += p & -(d >>> 31);
        return d;
    }

    private static int modp_R2(int p, int p0i) {
        int z = FalconKeyGen.modp_R(p);
        z = FalconKeyGen.modp_add(z, z, p);
        z = FalconKeyGen.modp_montymul(z, z, p, p0i);
        z = FalconKeyGen.modp_montymul(z, z, p, p0i);
        z = FalconKeyGen.modp_montymul(z, z, p, p0i);
        z = FalconKeyGen.modp_montymul(z, z, p, p0i);
        z = FalconKeyGen.modp_montymul(z, z, p, p0i);
        z = z + (p & -(z & 1)) >>> 1;
        return z;
    }

    private static int modp_Rx(int x, int p, int p0i, int R2) {
        --x;
        int r = R2;
        int z = FalconKeyGen.modp_R(p);
        int i = 0;
        while (1 << i <= x) {
            if ((x & 1 << i) != 0) {
                z = FalconKeyGen.modp_montymul(z, r, p, p0i);
            }
            r = FalconKeyGen.modp_montymul(r, r, p, p0i);
            ++i;
        }
        return z;
    }

    private static int modp_div(int a, int b, int p, int p0i, int R) {
        int e = p - 2;
        int z = R;
        for (int i = 30; i >= 0; --i) {
            z = FalconKeyGen.modp_montymul(z, z, p, p0i);
            int z2 = FalconKeyGen.modp_montymul(z, b, p, p0i);
            z ^= (z ^ z2) & -(e >>> i & 1);
        }
        z = FalconKeyGen.modp_montymul(z, 1, p, p0i);
        return FalconKeyGen.modp_montymul(a, z, p, p0i);
    }

    private static void modp_mkgm2(int[] srcgm, int gm, int[] srcigm, int igm, int logn, int g, int p, int p0i) {
        int x2;
        int k;
        int n = FalconKeyGen.mkn(logn);
        int R2 = FalconKeyGen.modp_R2(p, p0i);
        g = FalconKeyGen.modp_montymul(g, R2, p, p0i);
        for (k = logn; k < 10; ++k) {
            g = FalconKeyGen.modp_montymul(g, g, p, p0i);
        }
        int ig = FalconKeyGen.modp_div(R2, g, p, p0i, FalconKeyGen.modp_R(p));
        k = 10 - logn;
        int x1 = x2 = FalconKeyGen.modp_R(p);
        for (int u = 0; u < n; ++u) {
            short v = REV10[u << k];
            srcgm[gm + v] = x1;
            srcigm[igm + v] = x2;
            x1 = FalconKeyGen.modp_montymul(x1, g, p, p0i);
            x2 = FalconKeyGen.modp_montymul(x2, ig, p, p0i);
        }
    }

    private static void modp_NTT2_ext(int[] srca, int a, int stride, int[] srcgm, int gm, int logn, int p, int p0i) {
        int n;
        if (logn == 0) {
            return;
        }
        int t = n = FalconKeyGen.mkn(logn);
        for (int m = 1; m < n; m <<= 1) {
            int ht = t >> 1;
            int u = 0;
            int v1 = 0;
            while (u < m) {
                int s = srcgm[gm + m + u];
                int r1 = a + v1 * stride;
                int r2 = r1 + ht * stride;
                int v = 0;
                while (v < ht) {
                    int x = srca[r1];
                    int y = FalconKeyGen.modp_montymul(srca[r2], s, p, p0i);
                    srca[r1] = FalconKeyGen.modp_add(x, y, p);
                    srca[r2] = FalconKeyGen.modp_sub(x, y, p);
                    ++v;
                    r1 += stride;
                    r2 += stride;
                }
                ++u;
                v1 += t;
            }
            t = ht;
        }
    }

    private static void modp_iNTT2_ext(int[] srca, int a, int stride, int[] srcigm, int igm, int logn, int p, int p0i) {
        if (logn == 0) {
            return;
        }
        int n = FalconKeyGen.mkn(logn);
        int t = 1;
        for (int m = n; m > 1; m >>= 1) {
            int hm = m >> 1;
            int dt = t << 1;
            int u = 0;
            int v1 = 0;
            while (u < hm) {
                int s = srcigm[igm + hm + u];
                int r1 = a + v1 * stride;
                int r2 = r1 + t * stride;
                int v = 0;
                while (v < t) {
                    int x = srca[r1];
                    int y = srca[r2];
                    srca[r1] = FalconKeyGen.modp_add(x, y, p);
                    srca[r2] = FalconKeyGen.modp_montymul(FalconKeyGen.modp_sub(x, y, p), s, p, p0i);
                    ++v;
                    r1 += stride;
                    r2 += stride;
                }
                ++u;
                v1 += dt;
            }
            t = dt;
        }
        int ni = 1 << 31 - logn;
        int k = 0;
        int r = a;
        while (k < n) {
            srca[r] = FalconKeyGen.modp_montymul(srca[r], ni, p, p0i);
            ++k;
            r += stride;
        }
    }

    private static void modp_NTT2(int[] srca, int a, int[] srcgm, int gm, int logn, int p, int p0i) {
        FalconKeyGen.modp_NTT2_ext(srca, a, 1, srcgm, gm, logn, p, p0i);
    }

    private static void modp_iNTT2(int[] srca, int a, int[] srcigm, int igm, int logn, int p, int p0i) {
        FalconKeyGen.modp_iNTT2_ext(srca, a, 1, srcigm, igm, logn, p, p0i);
    }

    private static void modp_poly_rec_res(int[] srcf, int f, int logn, int p, int p0i, int R2) {
        int hn = 1 << logn - 1;
        for (int u = 0; u < hn; ++u) {
            int w0 = srcf[f + (u << 1)];
            int w1 = srcf[f + (u << 1) + 1];
            srcf[f + u] = FalconKeyGen.modp_montymul(FalconKeyGen.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
        }
    }

    private static void zint_sub(int[] srca, int a, int[] srcb, int b, int len, int ctl) {
        int cc = 0;
        int m = -ctl;
        for (int u = 0; u < len; ++u) {
            int au = a + u;
            int aw = srca[au];
            int w = aw - srcb[b + u] - cc;
            cc = w >>> 31;
            aw ^= (w & Integer.MAX_VALUE ^ aw) & m;
            srca[au] = aw;
        }
    }

    private static int zint_mul_small(int[] srcm, int m, int mlen, int x) {
        int cc = 0;
        for (int u = 0; u < mlen; ++u) {
            long z = FalconKeyGen.toUnsignedLong(srcm[m + u]) * FalconKeyGen.toUnsignedLong(x) + (long)cc;
            srcm[m + u] = (int)z & Integer.MAX_VALUE;
            cc = (int)(z >> 31);
        }
        return cc;
    }

    private static int zint_mod_small_unsigned(int[] srcd, int d, int dlen, int p, int p0i, int R2) {
        int x = 0;
        int u = dlen;
        while (u-- > 0) {
            x = FalconKeyGen.modp_montymul(x, R2, p, p0i);
            int w = srcd[d + u] - p;
            w += p & -(w >>> 31);
            x = FalconKeyGen.modp_add(x, w, p);
        }
        return x;
    }

    private static int zint_mod_small_signed(int[] srcd, int d, int dlen, int p, int p0i, int R2, int Rx) {
        if (dlen == 0) {
            return 0;
        }
        int z = FalconKeyGen.zint_mod_small_unsigned(srcd, d, dlen, p, p0i, R2);
        z = FalconKeyGen.modp_sub(z, Rx & -(srcd[d + dlen - 1] >>> 30), p);
        return z;
    }

    private static void zint_add_mul_small(int[] srcx, int x, int[] srcy, int y, int len, int s) {
        int cc = 0;
        for (int u = 0; u < len; ++u) {
            int xw = srcx[x + u];
            int yw = srcy[y + u];
            long z = FalconKeyGen.toUnsignedLong(yw) * FalconKeyGen.toUnsignedLong(s) + FalconKeyGen.toUnsignedLong(xw) + FalconKeyGen.toUnsignedLong(cc);
            srcx[x + u] = (int)z & Integer.MAX_VALUE;
            cc = (int)(z >>> 31);
        }
        srcx[x + len] = cc;
    }

    private static void zint_norm_zero(int[] srcx, int x, int[] srcp, int p, int len) {
        int r = 0;
        int bb = 0;
        int u = len;
        while (u-- > 0) {
            int wx = srcx[x + u];
            int wp = srcp[p + u] >>> 1 | bb << 30;
            bb = srcp[p + u] & 1;
            int cc = wp - wx;
            cc = -cc >>> 31 | -(cc >>> 31);
            r |= cc & (r & 1) - 1;
        }
        FalconKeyGen.zint_sub(srcx, x, srcp, p, len, r >>> 31);
    }

    private static void zint_rebuild_CRT(int[] srcxx, int xx, int xlen, int xstride, int num, int normalize_signed, int[] srctmp, int tmp) {
        int x;
        int u;
        srctmp[tmp] = FalconSmallPrimeList.PRIMES[0].p;
        for (u = 1; u < xlen; ++u) {
            int p = FalconSmallPrimeList.PRIMES[u].p;
            int s = FalconSmallPrimeList.PRIMES[u].s;
            int p0i = FalconKeyGen.modp_ninv31(p);
            int R2 = FalconKeyGen.modp_R2(p, p0i);
            int v = 0;
            x = xx;
            while (v < num) {
                int xp = srcxx[x + u];
                int xq = FalconKeyGen.zint_mod_small_unsigned(srcxx, x, u, p, p0i, R2);
                int xr = FalconKeyGen.modp_montymul(s, FalconKeyGen.modp_sub(xp, xq, p), p, p0i);
                FalconKeyGen.zint_add_mul_small(srcxx, x, srctmp, tmp, u, xr);
                ++v;
                x += xstride;
            }
            srctmp[tmp + u] = FalconKeyGen.zint_mul_small(srctmp, tmp, u, p);
        }
        if (normalize_signed != 0) {
            u = 0;
            x = xx;
            while (u < num) {
                FalconKeyGen.zint_norm_zero(srcxx, x, srctmp, tmp, xlen);
                ++u;
                x += xstride;
            }
        }
    }

    private static void zint_negate(int[] srca, int a, int len, int ctl) {
        int cc = ctl;
        int m = -ctl >>> 1;
        for (int u = 0; u < len; ++u) {
            int aw = srca[a + u];
            aw = (aw ^ m) + cc;
            srca[a + u] = aw & Integer.MAX_VALUE;
            cc = aw >>> 31;
        }
    }

    private static int zint_co_reduce(int[] srca, int a, int[] srcb, int b, int len, long xa, long xb, long ya, long yb) {
        long cca = 0L;
        long ccb = 0L;
        for (int u = 0; u < len; ++u) {
            int wa = srca[a + u];
            int wb = srcb[b + u];
            long za = (long)wa * xa + (long)wb * xb + cca;
            long zb = (long)wa * ya + (long)wb * yb + ccb;
            if (u > 0) {
                srca[a + u - 1] = (int)za & Integer.MAX_VALUE;
                srcb[b + u - 1] = (int)zb & Integer.MAX_VALUE;
            }
            cca = za >> 31;
            ccb = zb >> 31;
        }
        srca[a + len - 1] = (int)cca;
        srcb[b + len - 1] = (int)ccb;
        int nega = (int)(cca >>> 63);
        int negb = (int)(ccb >>> 63);
        FalconKeyGen.zint_negate(srca, a, len, nega);
        FalconKeyGen.zint_negate(srcb, b, len, negb);
        return nega | negb << 1;
    }

    private static void zint_finish_mod(int[] srca, int a, int len, int[] srcm, int m, int neg) {
        int u;
        int cc = 0;
        for (u = 0; u < len; ++u) {
            cc = srca[a + u] - srcm[m + u] - cc >>> 31;
        }
        int xm = -neg >>> 1;
        int ym = -(neg | 1 - cc);
        cc = neg;
        for (u = 0; u < len; ++u) {
            int aw = srca[a + u];
            int mw = (srcm[m + u] ^ xm) & ym;
            aw = aw - mw - cc;
            srca[a + u] = aw & Integer.MAX_VALUE;
            cc = aw >>> 31;
        }
    }

    private static void zint_co_reduce_mod(int[] srca, int a, int[] srcb, int b, int[] srcm, int m, int len, int m0i, long xa, long xb, long ya, long yb) {
        long cca = 0L;
        long ccb = 0L;
        int fa = (srca[a] * (int)xa + srcb[b] * (int)xb) * m0i & Integer.MAX_VALUE;
        int fb = (srca[a] * (int)ya + srcb[b] * (int)yb) * m0i & Integer.MAX_VALUE;
        for (int u = 0; u < len; ++u) {
            int wa = srca[a + u];
            int wb = srcb[b + u];
            long za = (long)wa * xa + (long)wb * xb + (long)srcm[m + u] * FalconKeyGen.toUnsignedLong(fa) + cca;
            long zb = (long)wa * ya + (long)wb * yb + (long)srcm[m + u] * FalconKeyGen.toUnsignedLong(fb) + ccb;
            if (u > 0) {
                srca[a + u - 1] = (int)za & Integer.MAX_VALUE;
                srcb[b + u - 1] = (int)zb & Integer.MAX_VALUE;
            }
            cca = za >> 31;
            ccb = zb >> 31;
        }
        srca[a + len - 1] = (int)cca;
        srcb[b + len - 1] = (int)ccb;
        FalconKeyGen.zint_finish_mod(srca, a, len, srcm, m, (int)(cca >>> 63));
        FalconKeyGen.zint_finish_mod(srcb, b, len, srcm, m, (int)(ccb >>> 63));
    }

    private static int zint_bezout(int[] srcu, int u, int[] srcv, int v, int[] srcx, int x, int[] srcy, int y, int len, int[] srctmp, int tmp) {
        int j;
        if (len == 0) {
            return 0;
        }
        int u0 = u;
        int v0 = v;
        int u1 = tmp;
        int v1 = u1 + len;
        int a = v1 + len;
        int b = a + len;
        int x0i = FalconKeyGen.modp_ninv31(srcx[x]);
        int y0i = FalconKeyGen.modp_ninv31(srcy[y]);
        System.arraycopy(srcx, x, srctmp, a, len);
        System.arraycopy(srcy, y, srctmp, b, len);
        srcu[u0] = 1;
        srcv[v0] = 0;
        for (int i = 1; i < len; ++i) {
            srcu[u0 + i] = 0;
            srcv[v0 + i] = 0;
        }
        System.arraycopy(srcy, y, srctmp, u1, len);
        System.arraycopy(srcx, x, srctmp, v1, len);
        int n = v1;
        srctmp[n] = srctmp[n] - 1;
        for (int num = 62 * len + 30; num >= 30; num -= 30) {
            int c0 = -1;
            int c1 = -1;
            int a0 = 0;
            int a1 = 0;
            int b0 = 0;
            int b1 = 0;
            j = len;
            while (j-- > 0) {
                int aw = srctmp[a + j];
                int bw = srctmp[b + j];
                a0 ^= (a0 ^ aw) & c0;
                a1 ^= (a1 ^ aw) & c1;
                b0 ^= (b0 ^ bw) & c0;
                b1 ^= (b1 ^ bw) & c1;
                c1 = c0;
                c0 &= ((aw | bw) + Integer.MAX_VALUE >>> 31) - 1;
            }
            a1 |= a0 & c1;
            b1 |= b0 & c1;
            long a_hi = (FalconKeyGen.toUnsignedLong(a0 &= ~c1) << 31) + FalconKeyGen.toUnsignedLong(a1);
            long b_hi = (FalconKeyGen.toUnsignedLong(b0 &= ~c1) << 31) + FalconKeyGen.toUnsignedLong(b1);
            int a_lo = srctmp[a];
            int b_lo = srctmp[b];
            long pa = 1L;
            long pb = 0L;
            long qa = 0L;
            long qb = 1L;
            for (int i = 0; i < 31; ++i) {
                long rz = b_hi - a_hi;
                int rt = (int)((rz ^ (a_hi ^ b_hi) & (a_hi ^ rz)) >>> 63);
                int oa = a_lo >> i & 1;
                int ob = b_lo >> i & 1;
                int cAB = oa & ob & rt;
                int cBA = oa & ob & ~rt;
                int cA = cAB | oa ^ 1;
                a_lo -= b_lo & -cAB;
                a_hi -= b_hi & -FalconKeyGen.toUnsignedLong(cAB);
                pa -= qa & -((long)cAB);
                pb -= qb & -((long)cAB);
                b_lo -= a_lo & -cBA;
                b_hi -= a_hi & -FalconKeyGen.toUnsignedLong(cBA);
                qa -= pa & -((long)cBA);
                qb -= pb & -((long)cBA);
                a_lo += a_lo & cA - 1;
                pa += pa & (long)cA - 1L;
                pb += pb & (long)cA - 1L;
                a_hi ^= (a_hi ^ a_hi >> 1) & -FalconKeyGen.toUnsignedLong(cA);
                b_lo += b_lo & -cA;
                qa += qa & -((long)cA);
                qb += qb & -((long)cA);
                b_hi ^= (b_hi ^ b_hi >> 1) & FalconKeyGen.toUnsignedLong(cA) - 1L;
            }
            int r = FalconKeyGen.zint_co_reduce(srctmp, a, srctmp, b, len, pa, pb, qa, qb);
            pa -= pa + pa & -((long)(r & 1));
            pb -= pb + pb & -((long)(r & 1));
            qa -= qa + qa & -((long)(r >>> 1));
            qb -= qb + qb & -((long)(r >>> 1));
            FalconKeyGen.zint_co_reduce_mod(srcu, u0, srctmp, u1, srcy, y, len, y0i, pa, pb, qa, qb);
            FalconKeyGen.zint_co_reduce_mod(srcv, v0, srctmp, v1, srcx, x, len, x0i, pa, pb, qa, qb);
        }
        int rc = srctmp[a] ^ 1;
        for (j = 1; j < len; ++j) {
            rc |= srctmp[a + j];
        }
        return 1 - ((rc | -rc) >>> 31) & srcx[x] & srcy[y];
    }

    private static void zint_add_scaled_mul_small(int[] srcx, int x, int xlen, int[] srcy, int y, int ylen, int k, int sch, int scl) {
        if (ylen == 0) {
            return;
        }
        int ysign = -(srcy[y + ylen - 1] >>> 30) >>> 1;
        int tw = 0;
        int cc = 0;
        for (int u = sch; u < xlen; ++u) {
            int ccu;
            int v = u - sch;
            int wy = v < ylen ? srcy[y + v] : ysign;
            int wys = wy << scl & Integer.MAX_VALUE | tw;
            tw = wy >>> 31 - scl;
            long z = FalconKeyGen.toUnsignedLong(wys) * (long)k + FalconKeyGen.toUnsignedLong(srcx[x + u]) + (long)cc;
            srcx[x + u] = (int)z & Integer.MAX_VALUE;
            cc = ccu = (int)(z >>> 31);
        }
    }

    private static void zint_sub_scaled(int[] srcx, int x, int xlen, int[] srcy, int y, int ylen, int sch, int scl) {
        if (ylen == 0) {
            return;
        }
        int ysign = -(srcy[y + ylen - 1] >>> 30) >>> 1;
        int tw = 0;
        int cc = 0;
        for (int u = sch; u < xlen; ++u) {
            int v = u - sch;
            int wy = v < ylen ? srcy[y + v] : ysign;
            int wys = wy << scl & Integer.MAX_VALUE | tw;
            tw = wy >>> 31 - scl;
            int w = srcx[x + u] - wys - cc;
            srcx[x + u] = w & Integer.MAX_VALUE;
            cc = w >>> 31;
        }
    }

    private static int zint_one_to_plain(int[] srcx, int x) {
        int w = srcx[x];
        w |= (w & 0x40000000) << 1;
        return w;
    }

    private static void poly_big_to_fp(double[] srcd, int[] srcf, int f, int flen, int fstride, int logn) {
        int n = FalconKeyGen.mkn(logn);
        if (flen == 0) {
            for (int u = 0; u < n; ++u) {
                srcd[u] = 0.0;
            }
            return;
        }
        int u = 0;
        while (u < n) {
            int neg = -(srcf[f + flen - 1] >>> 30);
            int xm = neg >>> 1;
            int cc = neg & 1;
            double x = 0.0;
            double fsc = 1.0;
            int v = 0;
            while (v < flen) {
                int w = (srcf[f + v] ^ xm) + cc;
                cc = w >>> 31;
                w &= Integer.MAX_VALUE;
                w -= w << 1 & neg;
                x += (double)w * fsc;
                ++v;
                fsc *= 2.147483648E9;
            }
            srcd[u] = x;
            ++u;
            f += fstride;
        }
    }

    private static int poly_big_to_small(byte[] srcd, int d, int[] srcs, int s, int lim, int logn) {
        int n = FalconKeyGen.mkn(logn);
        for (int u = 0; u < n; ++u) {
            int z = FalconKeyGen.zint_one_to_plain(srcs, s + u);
            if (z < -lim || z > lim) {
                return 0;
            }
            srcd[d + u] = (byte)z;
        }
        return 1;
    }

    private static void poly_sub_scaled(int[] srcF, int F2, int Flen, int Fstride, int[] srcf, int f, int flen, int fstride, int[] srck, int sch, int scl, int logn) {
        int n = FalconKeyGen.mkn(logn);
        for (int u = 0; u < n; ++u) {
            int kf = -srck[u];
            int x = F2 + u * Fstride;
            int y = f;
            for (int v = 0; v < n; ++v) {
                FalconKeyGen.zint_add_scaled_mul_small(srcF, x, Flen, srcf, y, flen, kf, sch, scl);
                if (u + v == n - 1) {
                    x = F2;
                    kf = -kf;
                } else {
                    x += Fstride;
                }
                y += fstride;
            }
        }
    }

    private static void poly_sub_scaled_ntt(int[] srcF, int F2, int Flen, int Fstride, int[] srcf, int f, int flen, int fstride, int[] srck, int sch, int scl, int logn, int[] srctmp, int tmp) {
        int x;
        int y;
        int u;
        int n = FalconKeyGen.mkn(logn);
        int tlen = flen + 1;
        int gm = tmp;
        int igm = gm + FalconKeyGen.mkn(logn);
        int fk = igm + FalconKeyGen.mkn(logn);
        int t1 = fk + n * tlen;
        for (u = 0; u < tlen; ++u) {
            int v;
            int p = FalconSmallPrimeList.PRIMES[u].p;
            int p0i = FalconKeyGen.modp_ninv31(p);
            int R2 = FalconKeyGen.modp_R2(p, p0i);
            int Rx = FalconKeyGen.modp_Rx(flen, p, p0i, R2);
            FalconKeyGen.modp_mkgm2(srctmp, gm, srctmp, igm, logn, FalconSmallPrimeList.PRIMES[u].g, p, p0i);
            for (v = 0; v < n; ++v) {
                srctmp[t1 + v] = FalconKeyGen.modp_set(srck[v], p);
            }
            FalconKeyGen.modp_NTT2(srctmp, t1, srctmp, gm, logn, p, p0i);
            v = 0;
            y = f;
            x = fk + u;
            while (v < n) {
                srctmp[x] = FalconKeyGen.zint_mod_small_signed(srcf, y, flen, p, p0i, R2, Rx);
                ++v;
                y += fstride;
                x += tlen;
            }
            FalconKeyGen.modp_NTT2_ext(srctmp, fk + u, tlen, srctmp, gm, logn, p, p0i);
            v = 0;
            x = fk + u;
            while (v < n) {
                srctmp[x] = FalconKeyGen.modp_montymul(FalconKeyGen.modp_montymul(srctmp[t1 + v], srctmp[x], p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            FalconKeyGen.modp_iNTT2_ext(srctmp, fk + u, tlen, srctmp, igm, logn, p, p0i);
        }
        FalconKeyGen.zint_rebuild_CRT(srctmp, fk, tlen, tlen, n, 1, srctmp, t1);
        u = 0;
        x = F2;
        y = fk;
        while (u < n) {
            FalconKeyGen.zint_sub_scaled(srcF, x, Flen, srctmp, y, tlen, sch, scl);
            ++u;
            x += Fstride;
            y += tlen;
        }
    }

    private static long get_rng_u64(SHAKEDigest rng) {
        byte[] tmp = new byte[8];
        rng.doOutput(tmp, 0, tmp.length);
        return Pack.littleEndianToLong(tmp, 0);
    }

    private static int mkgauss(SHAKEDigest rng, int logn) {
        int g = 1 << 10 - logn;
        int val = 0;
        for (int u = 0; u < g; ++u) {
            long r = FalconKeyGen.get_rng_u64(rng);
            int neg = (int)(r >>> 63);
            int f = (int)((r &= Long.MAX_VALUE) - gauss_1024_12289[0] >>> 63);
            int v = 0;
            r = FalconKeyGen.get_rng_u64(rng);
            r &= Long.MAX_VALUE;
            for (int k = 1; k < gauss_1024_12289.length; ++k) {
                int t = (int)(r - gauss_1024_12289[k] >>> 63) ^ 1;
                v |= k & -(t & (f ^ 1));
                f |= t;
            }
            v = (v ^ -neg) + neg;
            val += v;
        }
        return val;
    }

    private static int poly_small_sqnorm(byte[] srcf, int logn) {
        int n = FalconKeyGen.mkn(logn);
        int s = 0;
        int ng = 0;
        for (int u = 0; u < n; ++u) {
            byte z = srcf[u];
            ng |= (s += z * z);
        }
        return s | -(ng >>> 31);
    }

    private static void poly_small_to_fp(double[] srcx, int x, byte[] srcf, int logn) {
        int n = FalconKeyGen.mkn(logn);
        for (int u = 0; u < n; ++u) {
            srcx[x + u] = srcf[u];
        }
    }

    private static void make_fg_step(int[] srcdata, int data, int logn, int depth, int in_ntt, int out_ntt) {
        int R2;
        int p0i;
        int p;
        int u;
        int n = 1 << logn;
        int hn = n >> 1;
        int slen = MAX_BL_SMALL[depth];
        int tlen = MAX_BL_SMALL[depth + 1];
        int fd = data;
        int gd = fd + hn * tlen;
        int fs = gd + hn * tlen;
        int gs = fs + n * slen;
        int gm = gs + n * slen;
        int igm = gm + n;
        int t1 = igm + n;
        System.arraycopy(srcdata, data, srcdata, fs, 2 * n * slen);
        for (u = 0; u < slen; ++u) {
            int w1;
            int w0;
            p = FalconSmallPrimeList.PRIMES[u].p;
            p0i = FalconKeyGen.modp_ninv31(p);
            R2 = FalconKeyGen.modp_R2(p, p0i);
            FalconKeyGen.modp_mkgm2(srcdata, gm, srcdata, igm, logn, FalconSmallPrimeList.PRIMES[u].g, p, p0i);
            int v = 0;
            int x = fs + u;
            while (v < n) {
                srcdata[t1 + v] = srcdata[x];
                ++v;
                x += slen;
            }
            if (in_ntt == 0) {
                FalconKeyGen.modp_NTT2(srcdata, t1, srcdata, gm, logn, p, p0i);
            }
            v = 0;
            x = fd + u;
            while (v < hn) {
                w0 = srcdata[t1 + (v << 1)];
                w1 = srcdata[t1 + (v << 1) + 1];
                srcdata[x] = FalconKeyGen.modp_montymul(FalconKeyGen.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            if (in_ntt != 0) {
                FalconKeyGen.modp_iNTT2_ext(srcdata, fs + u, slen, srcdata, igm, logn, p, p0i);
            }
            v = 0;
            x = gs + u;
            while (v < n) {
                srcdata[t1 + v] = srcdata[x];
                ++v;
                x += slen;
            }
            if (in_ntt == 0) {
                FalconKeyGen.modp_NTT2(srcdata, t1, srcdata, gm, logn, p, p0i);
            }
            v = 0;
            x = gd + u;
            while (v < hn) {
                w0 = srcdata[t1 + (v << 1)];
                w1 = srcdata[t1 + (v << 1) + 1];
                srcdata[x] = FalconKeyGen.modp_montymul(FalconKeyGen.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            if (in_ntt != 0) {
                FalconKeyGen.modp_iNTT2_ext(srcdata, gs + u, slen, srcdata, igm, logn, p, p0i);
            }
            if (out_ntt != 0) continue;
            FalconKeyGen.modp_iNTT2_ext(srcdata, fd + u, tlen, srcdata, igm, logn - 1, p, p0i);
            FalconKeyGen.modp_iNTT2_ext(srcdata, gd + u, tlen, srcdata, igm, logn - 1, p, p0i);
        }
        FalconKeyGen.zint_rebuild_CRT(srcdata, fs, slen, slen, n, 1, srcdata, gm);
        FalconKeyGen.zint_rebuild_CRT(srcdata, gs, slen, slen, n, 1, srcdata, gm);
        for (u = slen; u < tlen; ++u) {
            int w1;
            int w0;
            p = FalconSmallPrimeList.PRIMES[u].p;
            p0i = FalconKeyGen.modp_ninv31(p);
            R2 = FalconKeyGen.modp_R2(p, p0i);
            int Rx = FalconKeyGen.modp_Rx(slen, p, p0i, R2);
            FalconKeyGen.modp_mkgm2(srcdata, gm, srcdata, igm, logn, FalconSmallPrimeList.PRIMES[u].g, p, p0i);
            int v = 0;
            int x = fs;
            while (v < n) {
                srcdata[t1 + v] = FalconKeyGen.zint_mod_small_signed(srcdata, x, slen, p, p0i, R2, Rx);
                ++v;
                x += slen;
            }
            FalconKeyGen.modp_NTT2(srcdata, t1, srcdata, gm, logn, p, p0i);
            v = 0;
            x = fd + u;
            while (v < hn) {
                w0 = srcdata[t1 + (v << 1)];
                w1 = srcdata[t1 + (v << 1) + 1];
                srcdata[x] = FalconKeyGen.modp_montymul(FalconKeyGen.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            v = 0;
            x = gs;
            while (v < n) {
                srcdata[t1 + v] = FalconKeyGen.zint_mod_small_signed(srcdata, x, slen, p, p0i, R2, Rx);
                ++v;
                x += slen;
            }
            FalconKeyGen.modp_NTT2(srcdata, t1, srcdata, gm, logn, p, p0i);
            v = 0;
            x = gd + u;
            while (v < hn) {
                w0 = srcdata[t1 + (v << 1)];
                w1 = srcdata[t1 + (v << 1) + 1];
                srcdata[x] = FalconKeyGen.modp_montymul(FalconKeyGen.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            if (out_ntt != 0) continue;
            FalconKeyGen.modp_iNTT2_ext(srcdata, fd + u, tlen, srcdata, igm, logn - 1, p, p0i);
            FalconKeyGen.modp_iNTT2_ext(srcdata, gd + u, tlen, srcdata, igm, logn - 1, p, p0i);
        }
    }

    private static void make_fg(int[] srcdata, int data, byte[] srcf, byte[] srcg, int logn, int depth, int out_ntt) {
        int n = FalconKeyGen.mkn(logn);
        int ft = data;
        int gt = ft + n;
        int p0 = FalconSmallPrimeList.PRIMES[0].p;
        for (int u = 0; u < n; ++u) {
            srcdata[ft + u] = FalconKeyGen.modp_set(srcf[u], p0);
            srcdata[gt + u] = FalconKeyGen.modp_set(srcg[u], p0);
        }
        if (depth == 0 && out_ntt != 0) {
            int p = FalconSmallPrimeList.PRIMES[0].p;
            int p0i = FalconKeyGen.modp_ninv31(p);
            int gm = gt + n;
            int igm = gm + n;
            FalconKeyGen.modp_mkgm2(srcdata, gm, srcdata, igm, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
            FalconKeyGen.modp_NTT2(srcdata, ft, srcdata, gm, logn, p, p0i);
            FalconKeyGen.modp_NTT2(srcdata, gt, srcdata, gm, logn, p, p0i);
            return;
        }
        for (int d = 0; d < depth; ++d) {
            FalconKeyGen.make_fg_step(srcdata, data, logn - d, d, d != 0 ? 1 : 0, d + 1 < depth || out_ntt != 0 ? 1 : 0);
        }
    }

    private static int solve_NTRU_deepest(int logn_top, byte[] srcf, byte[] srcg, int[] srctmp) {
        int len = MAX_BL_SMALL[logn_top];
        int Fp2 = 0;
        int Gp = Fp2 + len;
        int fp = Gp + len;
        int gp = fp + len;
        int t1 = gp + len;
        FalconKeyGen.make_fg(srctmp, fp, srcf, srcg, logn_top, logn_top, 0);
        FalconKeyGen.zint_rebuild_CRT(srctmp, fp, len, len, 2, 0, srctmp, t1);
        if (FalconKeyGen.zint_bezout(srctmp, Gp, srctmp, Fp2, srctmp, fp, srctmp, gp, len, srctmp, t1) == 0) {
            return 0;
        }
        int q = 12289;
        if (FalconKeyGen.zint_mul_small(srctmp, Fp2, len, q) != 0 || FalconKeyGen.zint_mul_small(srctmp, Gp, len, q) != 0) {
            return 0;
        }
        return 1;
    }

    private static int solve_NTRU_intermediate(int logn_top, byte[] srcf, byte[] srcg, int depth, int[] srctmp) {
        int y;
        int x;
        int R2;
        int p0i;
        int p;
        int u;
        int logn = logn_top - depth;
        int n = 1 << logn;
        int hn = n >> 1;
        int slen = MAX_BL_SMALL[depth];
        int dlen = MAX_BL_SMALL[depth + 1];
        int llen = MAX_BL_LARGE[depth];
        int Fd = 0;
        int Gd = Fd + dlen * hn;
        int ft = Gd + dlen * hn;
        FalconKeyGen.make_fg(srctmp, ft, srcf, srcg, logn_top, depth, 1);
        int Ft = 0;
        int Gt = Ft + n * llen;
        int t1 = Gt + n * llen;
        int tmp = n * slen;
        System.arraycopy(srctmp, ft, srctmp, t1, tmp + tmp);
        ft = t1;
        int gt = ft + tmp;
        t1 = gt + tmp;
        tmp = hn * dlen;
        System.arraycopy(srctmp, Fd, srctmp, t1, tmp + tmp);
        Fd = t1;
        Gd = Fd + tmp;
        for (u = 0; u < llen; ++u) {
            p = FalconSmallPrimeList.PRIMES[u].p;
            p0i = FalconKeyGen.modp_ninv31(p);
            R2 = FalconKeyGen.modp_R2(p, p0i);
            int Rx = FalconKeyGen.modp_Rx(dlen, p, p0i, R2);
            int v = 0;
            int xs = Fd;
            int ys = Gd;
            int xd = Ft + u;
            int yd = Gt + u;
            while (v < hn) {
                srctmp[xd] = FalconKeyGen.zint_mod_small_signed(srctmp, xs, dlen, p, p0i, R2, Rx);
                srctmp[yd] = FalconKeyGen.zint_mod_small_signed(srctmp, ys, dlen, p, p0i, R2, Rx);
                ++v;
                xs += dlen;
                ys += dlen;
                xd += llen;
                yd += llen;
            }
        }
        for (u = 0; u < llen; ++u) {
            int v;
            p = FalconSmallPrimeList.PRIMES[u].p;
            p0i = FalconKeyGen.modp_ninv31(p);
            R2 = FalconKeyGen.modp_R2(p, p0i);
            if (u == slen) {
                FalconKeyGen.zint_rebuild_CRT(srctmp, ft, slen, slen, n, 1, srctmp, t1);
                FalconKeyGen.zint_rebuild_CRT(srctmp, gt, slen, slen, n, 1, srctmp, t1);
            }
            int gm = t1;
            int igm = gm + n;
            int fx = igm + n;
            int gx = fx + n;
            FalconKeyGen.modp_mkgm2(srctmp, gm, srctmp, igm, logn, FalconSmallPrimeList.PRIMES[u].g, p, p0i);
            if (u < slen) {
                v = 0;
                x = ft + u;
                y = gt + u;
                while (v < n) {
                    srctmp[fx + v] = srctmp[x];
                    srctmp[gx + v] = srctmp[y];
                    ++v;
                    x += slen;
                    y += slen;
                }
                FalconKeyGen.modp_iNTT2_ext(srctmp, ft + u, slen, srctmp, igm, logn, p, p0i);
                FalconKeyGen.modp_iNTT2_ext(srctmp, gt + u, slen, srctmp, igm, logn, p, p0i);
            } else {
                int Rx = FalconKeyGen.modp_Rx(slen, p, p0i, R2);
                v = 0;
                x = ft;
                y = gt;
                while (v < n) {
                    srctmp[fx + v] = FalconKeyGen.zint_mod_small_signed(srctmp, x, slen, p, p0i, R2, Rx);
                    srctmp[gx + v] = FalconKeyGen.zint_mod_small_signed(srctmp, y, slen, p, p0i, R2, Rx);
                    ++v;
                    x += slen;
                    y += slen;
                }
                FalconKeyGen.modp_NTT2(srctmp, fx, srctmp, gm, logn, p, p0i);
                FalconKeyGen.modp_NTT2(srctmp, gx, srctmp, gm, logn, p, p0i);
            }
            int Fp2 = gx + n;
            int Gp = Fp2 + hn;
            v = 0;
            x = Ft + u;
            y = Gt + u;
            while (v < hn) {
                srctmp[Fp2 + v] = srctmp[x];
                srctmp[Gp + v] = srctmp[y];
                ++v;
                x += llen;
                y += llen;
            }
            FalconKeyGen.modp_NTT2(srctmp, Fp2, srctmp, gm, logn - 1, p, p0i);
            FalconKeyGen.modp_NTT2(srctmp, Gp, srctmp, gm, logn - 1, p, p0i);
            v = 0;
            x = Ft + u;
            y = Gt + u;
            while (v < hn) {
                int ftA = srctmp[fx + (v << 1)];
                int ftB = srctmp[fx + (v << 1) + 1];
                int gtA = srctmp[gx + (v << 1)];
                int gtB = srctmp[gx + (v << 1) + 1];
                int mFp = FalconKeyGen.modp_montymul(srctmp[Fp2 + v], R2, p, p0i);
                int mGp = FalconKeyGen.modp_montymul(srctmp[Gp + v], R2, p, p0i);
                srctmp[x] = FalconKeyGen.modp_montymul(gtB, mFp, p, p0i);
                srctmp[x + llen] = FalconKeyGen.modp_montymul(gtA, mFp, p, p0i);
                srctmp[y] = FalconKeyGen.modp_montymul(ftB, mGp, p, p0i);
                srctmp[y + llen] = FalconKeyGen.modp_montymul(ftA, mGp, p, p0i);
                ++v;
                x += llen << 1;
                y += llen << 1;
            }
            FalconKeyGen.modp_iNTT2_ext(srctmp, Ft + u, llen, srctmp, igm, logn, p, p0i);
            FalconKeyGen.modp_iNTT2_ext(srctmp, Gt + u, llen, srctmp, igm, logn, p, p0i);
        }
        FalconKeyGen.zint_rebuild_CRT(srctmp, Ft, llen, llen, n, 1, srctmp, t1);
        FalconKeyGen.zint_rebuild_CRT(srctmp, Gt, llen, llen, n, 1, srctmp, t1);
        double[] rt1 = new double[n];
        double[] rt2 = new double[n];
        double[] rt3 = new double[n];
        double[] rt4 = new double[n];
        double[] rt5 = new double[n >> 1];
        int[] k = new int[n];
        int rlen = Math.min(slen, 10);
        FalconKeyGen.poly_big_to_fp(rt3, srctmp, ft + slen - rlen, rlen, slen, logn);
        FalconKeyGen.poly_big_to_fp(rt4, srctmp, gt + slen - rlen, rlen, slen, logn);
        int scale_fg = 31 * (slen - rlen);
        int minbl_fg = bitlength_avg[depth] - 6 * bitlength_std[depth];
        int maxbl_fg = bitlength_avg[depth] + 6 * bitlength_std[depth];
        FalconFFT.FFT(rt3, 0, logn);
        FalconFFT.FFT(rt4, 0, logn);
        FalconFFT.poly_invnorm2_fft(rt5, 0, rt3, 0, rt4, 0, logn);
        FalconFFT.poly_adj_fft(rt3, 0, logn);
        FalconFFT.poly_adj_fft(rt4, 0, logn);
        int FGlen = llen;
        int maxbl_FG = 31 * llen;
        int scale_k = maxbl_FG - minbl_fg;
        while (true) {
            double pt;
            rlen = Math.min(FGlen, 10);
            int scale_FG = 31 * (FGlen - rlen);
            FalconKeyGen.poly_big_to_fp(rt1, srctmp, Ft + FGlen - rlen, rlen, llen, logn);
            FalconKeyGen.poly_big_to_fp(rt2, srctmp, Gt + FGlen - rlen, rlen, llen, logn);
            FalconFFT.FFT(rt1, 0, logn);
            FalconFFT.FFT(rt2, 0, logn);
            FalconFFT.poly_mul_fft(rt1, 0, rt3, 0, logn);
            FalconFFT.poly_mul_fft(rt2, 0, rt4, 0, logn);
            FalconFFT.poly_add(rt2, 0, rt1, 0, logn);
            FalconFFT.poly_mul_autoadj_fft(rt2, 0, rt5, 0, logn);
            FalconFFT.iFFT(rt2, 0, logn);
            int dc = scale_k - scale_FG + scale_fg;
            if (dc < 0) {
                dc = -dc;
                pt = 2.0;
            } else {
                pt = 0.5;
            }
            double pdc = 1.0;
            while (dc != 0) {
                if ((dc & 1) != 0) {
                    pdc *= pt;
                }
                dc >>= 1;
                pt *= pt;
            }
            for (u = 0; u < n; ++u) {
                double xv = rt2[u] * pdc;
                if (-2.147483647E9 >= xv || xv >= 2.147483647E9) {
                    return 0;
                }
                k[u] = (int)FPREngine.fpr_rint(xv);
            }
            int sch = scale_k / 31;
            int scl = scale_k % 31;
            if (depth <= 4) {
                FalconKeyGen.poly_sub_scaled_ntt(srctmp, Ft, FGlen, llen, srctmp, ft, slen, slen, k, sch, scl, logn, srctmp, t1);
                FalconKeyGen.poly_sub_scaled_ntt(srctmp, Gt, FGlen, llen, srctmp, gt, slen, slen, k, sch, scl, logn, srctmp, t1);
            } else {
                FalconKeyGen.poly_sub_scaled(srctmp, Ft, FGlen, llen, srctmp, ft, slen, slen, k, sch, scl, logn);
                FalconKeyGen.poly_sub_scaled(srctmp, Gt, FGlen, llen, srctmp, gt, slen, slen, k, sch, scl, logn);
            }
            int new_maxbl_FG = scale_k + maxbl_fg + 10;
            if (new_maxbl_FG < maxbl_FG && FGlen * 31 >= (maxbl_FG = new_maxbl_FG) + 31) {
                --FGlen;
            }
            if (scale_k <= 0) break;
            if ((scale_k -= 25) >= 0) continue;
            scale_k = 0;
        }
        if (FGlen < slen) {
            u = 0;
            while (u < n) {
                int v;
                int sw = -(srctmp[Ft + FGlen - 1] >>> 30) >>> 1;
                for (v = FGlen; v < slen; ++v) {
                    srctmp[Ft + v] = sw;
                }
                sw = -(srctmp[Gt + FGlen - 1] >>> 30) >>> 1;
                for (v = FGlen; v < slen; ++v) {
                    srctmp[Gt + v] = sw;
                }
                ++u;
                Ft += llen;
                Gt += llen;
            }
        }
        u = 0;
        x = 0;
        y = 0;
        while (u < n << 1) {
            System.arraycopy(srctmp, y, srctmp, x, slen);
            ++u;
            x += slen;
            y += llen;
        }
        return 1;
    }

    private static int solve_NTRU_binary_depth1(int logn_top, byte[] srcf, byte[] srcg, int[] srctmp) {
        int R2;
        int p0i;
        int p;
        int u;
        int depth = 1;
        int n_top = 1 << logn_top;
        int logn = logn_top - depth;
        int n = 1 << logn;
        int hn = n >> 1;
        int slen = MAX_BL_SMALL[depth];
        int dlen = MAX_BL_SMALL[depth + 1];
        int llen = MAX_BL_LARGE[depth];
        int Fd = 0;
        int Gd = Fd + dlen * hn;
        int Ft = Gd + dlen * hn;
        int Gt = Ft + llen * n;
        for (u = 0; u < llen; ++u) {
            p = FalconSmallPrimeList.PRIMES[u].p;
            p0i = FalconKeyGen.modp_ninv31(p);
            R2 = FalconKeyGen.modp_R2(p, p0i);
            int Rx = FalconKeyGen.modp_Rx(dlen, p, p0i, R2);
            int v = 0;
            int xs = Fd;
            int ys = Gd;
            int xd = Ft + u;
            int yd = Gt + u;
            while (v < hn) {
                srctmp[xd] = FalconKeyGen.zint_mod_small_signed(srctmp, xs, dlen, p, p0i, R2, Rx);
                srctmp[yd] = FalconKeyGen.zint_mod_small_signed(srctmp, ys, dlen, p, p0i, R2, Rx);
                ++v;
                xs += dlen;
                ys += dlen;
                xd += llen;
                yd += llen;
            }
        }
        System.arraycopy(srctmp, Ft, srctmp, 0, llen * n);
        Ft = 0;
        System.arraycopy(srctmp, Gt, srctmp, Ft + llen * n, llen * n);
        Gt = Ft + llen * n;
        int ft = Gt + llen * n;
        int gt = ft + slen * n;
        int t1 = gt + slen * n;
        for (u = 0; u < llen; ++u) {
            int v;
            p = FalconSmallPrimeList.PRIMES[u].p;
            p0i = FalconKeyGen.modp_ninv31(p);
            R2 = FalconKeyGen.modp_R2(p, p0i);
            int gm = t1;
            int igm = gm + n_top;
            int fx = igm + n;
            int gx = fx + n_top;
            FalconKeyGen.modp_mkgm2(srctmp, gm, srctmp, igm, logn_top, FalconSmallPrimeList.PRIMES[u].g, p, p0i);
            for (v = 0; v < n_top; ++v) {
                srctmp[fx + v] = FalconKeyGen.modp_set(srcf[v], p);
                srctmp[gx + v] = FalconKeyGen.modp_set(srcg[v], p);
            }
            FalconKeyGen.modp_NTT2(srctmp, fx, srctmp, gm, logn_top, p, p0i);
            FalconKeyGen.modp_NTT2(srctmp, gx, srctmp, gm, logn_top, p, p0i);
            for (int e = logn_top; e > logn; --e) {
                FalconKeyGen.modp_poly_rec_res(srctmp, fx, e, p, p0i, R2);
                FalconKeyGen.modp_poly_rec_res(srctmp, gx, e, p, p0i, R2);
            }
            System.arraycopy(srctmp, igm, srctmp, gm + n, n);
            igm = gm + n;
            System.arraycopy(srctmp, fx, srctmp, igm + n, n);
            fx = igm + n;
            System.arraycopy(srctmp, gx, srctmp, fx + n, n);
            gx = fx + n;
            int Fp2 = gx + n;
            int Gp = Fp2 + hn;
            v = 0;
            int x = Ft + u;
            int y = Gt + u;
            while (v < hn) {
                srctmp[Fp2 + v] = srctmp[x];
                srctmp[Gp + v] = srctmp[y];
                ++v;
                x += llen;
                y += llen;
            }
            FalconKeyGen.modp_NTT2(srctmp, Fp2, srctmp, gm, logn - 1, p, p0i);
            FalconKeyGen.modp_NTT2(srctmp, Gp, srctmp, gm, logn - 1, p, p0i);
            v = 0;
            x = Ft + u;
            y = Gt + u;
            while (v < hn) {
                int ftA = srctmp[fx + (v << 1)];
                int ftB = srctmp[fx + (v << 1) + 1];
                int gtA = srctmp[gx + (v << 1)];
                int gtB = srctmp[gx + (v << 1) + 1];
                int mFp = FalconKeyGen.modp_montymul(srctmp[Fp2 + v], R2, p, p0i);
                int mGp = FalconKeyGen.modp_montymul(srctmp[Gp + v], R2, p, p0i);
                srctmp[x] = FalconKeyGen.modp_montymul(gtB, mFp, p, p0i);
                srctmp[x + llen] = FalconKeyGen.modp_montymul(gtA, mFp, p, p0i);
                srctmp[y] = FalconKeyGen.modp_montymul(ftB, mGp, p, p0i);
                srctmp[y + llen] = FalconKeyGen.modp_montymul(ftA, mGp, p, p0i);
                ++v;
                x += llen << 1;
                y += llen << 1;
            }
            FalconKeyGen.modp_iNTT2_ext(srctmp, Ft + u, llen, srctmp, igm, logn, p, p0i);
            FalconKeyGen.modp_iNTT2_ext(srctmp, Gt + u, llen, srctmp, igm, logn, p, p0i);
            if (u >= slen) continue;
            FalconKeyGen.modp_iNTT2(srctmp, fx, srctmp, igm, logn, p, p0i);
            FalconKeyGen.modp_iNTT2(srctmp, gx, srctmp, igm, logn, p, p0i);
            v = 0;
            x = ft + u;
            y = gt + u;
            while (v < n) {
                srctmp[x] = srctmp[fx + v];
                srctmp[y] = srctmp[gx + v];
                ++v;
                x += slen;
                y += slen;
            }
        }
        FalconKeyGen.zint_rebuild_CRT(srctmp, Ft, llen, llen, n << 1, 1, srctmp, t1);
        FalconKeyGen.zint_rebuild_CRT(srctmp, ft, slen, slen, n << 1, 1, srctmp, t1);
        double[] rt1 = new double[n];
        double[] rt2 = new double[n];
        FalconKeyGen.poly_big_to_fp(rt1, srctmp, Ft, llen, llen, logn);
        FalconKeyGen.poly_big_to_fp(rt2, srctmp, Gt, llen, llen, logn);
        System.arraycopy(srctmp, ft, srctmp, 0, 2 * slen * n);
        ft = 0;
        gt = ft + slen * n;
        double[] rt3 = new double[n];
        double[] rt4 = new double[n];
        FalconKeyGen.poly_big_to_fp(rt3, srctmp, ft, slen, slen, logn);
        FalconKeyGen.poly_big_to_fp(rt4, srctmp, gt, slen, slen, logn);
        FalconFFT.FFT(rt1, 0, logn);
        FalconFFT.FFT(rt2, 0, logn);
        FalconFFT.FFT(rt3, 0, logn);
        FalconFFT.FFT(rt4, 0, logn);
        double[] rt5 = new double[n];
        double[] rt6 = new double[n >> 1];
        FalconFFT.poly_add_muladj_fft(rt5, rt1, rt2, rt3, rt4, logn);
        FalconFFT.poly_invnorm2_fft(rt6, 0, rt3, 0, rt4, 0, logn);
        FalconFFT.poly_mul_autoadj_fft(rt5, 0, rt6, 0, logn);
        FalconFFT.iFFT(rt5, 0, logn);
        for (u = 0; u < n; ++u) {
            double z = rt5[u];
            if (z >= 9.223372036854776E18 || -9.223372036854776E18 >= z) {
                return 0;
            }
            rt5[u] = FPREngine.fpr_rint(z);
        }
        FalconFFT.FFT(rt5, 0, logn);
        FalconFFT.poly_mul_fft(rt3, 0, rt5, 0, logn);
        FalconFFT.poly_mul_fft(rt4, 0, rt5, 0, logn);
        FalconFFT.poly_sub(rt1, 0, rt3, 0, logn);
        FalconFFT.poly_sub(rt2, 0, rt4, 0, logn);
        FalconFFT.iFFT(rt1, 0, logn);
        FalconFFT.iFFT(rt2, 0, logn);
        Gt = Ft + n;
        for (u = 0; u < n; ++u) {
            srctmp[Ft + u] = (int)FPREngine.fpr_rint(rt1[u]);
            srctmp[Gt + u] = (int)FPREngine.fpr_rint(rt2[u]);
        }
        return 1;
    }

    private static int solve_NTRU_binary_depth0(int logn, byte[] srcf, byte[] srcg, int[] srctmp) {
        int w;
        int u;
        int n = 1 << logn;
        int hn = n >> 1;
        int p = FalconSmallPrimeList.PRIMES[0].p;
        int p0i = FalconKeyGen.modp_ninv31(p);
        int R2 = FalconKeyGen.modp_R2(p, p0i);
        int Fp2 = 0;
        int Gp = Fp2 + hn;
        int ft = Gp + hn;
        int gt = ft + n;
        int gm = gt + n;
        int igm = gm + n;
        FalconKeyGen.modp_mkgm2(srctmp, gm, srctmp, igm, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        for (u = 0; u < hn; ++u) {
            srctmp[Fp2 + u] = FalconKeyGen.modp_set(FalconKeyGen.zint_one_to_plain(srctmp, Fp2 + u), p);
            srctmp[Gp + u] = FalconKeyGen.modp_set(FalconKeyGen.zint_one_to_plain(srctmp, Gp + u), p);
        }
        FalconKeyGen.modp_NTT2(srctmp, Fp2, srctmp, gm, logn - 1, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, Gp, srctmp, gm, logn - 1, p, p0i);
        for (u = 0; u < n; ++u) {
            srctmp[ft + u] = FalconKeyGen.modp_set(srcf[u], p);
            srctmp[gt + u] = FalconKeyGen.modp_set(srcg[u], p);
        }
        FalconKeyGen.modp_NTT2(srctmp, ft, srctmp, gm, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, gt, srctmp, gm, logn, p, p0i);
        for (u = 0; u < n; u += 2) {
            int ftA = srctmp[ft + u];
            int ftB = srctmp[ft + u + 1];
            int gtA = srctmp[gt + u];
            int gtB = srctmp[gt + u + 1];
            int mFp = FalconKeyGen.modp_montymul(srctmp[Fp2 + (u >> 1)], R2, p, p0i);
            int mGp = FalconKeyGen.modp_montymul(srctmp[Gp + (u >> 1)], R2, p, p0i);
            srctmp[ft + u] = FalconKeyGen.modp_montymul(gtB, mFp, p, p0i);
            srctmp[ft + u + 1] = FalconKeyGen.modp_montymul(gtA, mFp, p, p0i);
            srctmp[gt + u] = FalconKeyGen.modp_montymul(ftB, mGp, p, p0i);
            srctmp[gt + u + 1] = FalconKeyGen.modp_montymul(ftA, mGp, p, p0i);
        }
        FalconKeyGen.modp_iNTT2(srctmp, ft, srctmp, igm, logn, p, p0i);
        FalconKeyGen.modp_iNTT2(srctmp, gt, srctmp, igm, logn, p, p0i);
        Gp = Fp2 + n;
        int t1 = Gp + n;
        System.arraycopy(srctmp, ft, srctmp, Fp2, 2 * n);
        int t2 = t1 + n;
        int t3 = t2 + n;
        int t4 = t3 + n;
        int t5 = t4 + n;
        FalconKeyGen.modp_mkgm2(srctmp, t1, srctmp, t2, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, Fp2, srctmp, t1, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, Gp, srctmp, t1, logn, p, p0i);
        srctmp[t4] = srctmp[t5] = FalconKeyGen.modp_set(srcf[0], p);
        for (u = 1; u < n; ++u) {
            srctmp[t4 + u] = FalconKeyGen.modp_set(srcf[u], p);
            srctmp[t5 + n - u] = FalconKeyGen.modp_set(-srcf[u], p);
        }
        FalconKeyGen.modp_NTT2(srctmp, t4, srctmp, t1, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, t5, srctmp, t1, logn, p, p0i);
        for (u = 0; u < n; ++u) {
            w = FalconKeyGen.modp_montymul(srctmp[t5 + u], R2, p, p0i);
            srctmp[t2 + u] = FalconKeyGen.modp_montymul(w, srctmp[Fp2 + u], p, p0i);
            srctmp[t3 + u] = FalconKeyGen.modp_montymul(w, srctmp[t4 + u], p, p0i);
        }
        srctmp[t4] = srctmp[t5] = FalconKeyGen.modp_set(srcg[0], p);
        for (u = 1; u < n; ++u) {
            srctmp[t4 + u] = FalconKeyGen.modp_set(srcg[u], p);
            srctmp[t5 + n - u] = FalconKeyGen.modp_set(-srcg[u], p);
        }
        FalconKeyGen.modp_NTT2(srctmp, t4, srctmp, t1, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, t5, srctmp, t1, logn, p, p0i);
        for (u = 0; u < n; ++u) {
            w = FalconKeyGen.modp_montymul(srctmp[t5 + u], R2, p, p0i);
            srctmp[t2 + u] = FalconKeyGen.modp_add(srctmp[t2 + u], FalconKeyGen.modp_montymul(w, srctmp[Gp + u], p, p0i), p);
            srctmp[t3 + u] = FalconKeyGen.modp_add(srctmp[t3 + u], FalconKeyGen.modp_montymul(w, srctmp[t4 + u], p, p0i), p);
        }
        FalconKeyGen.modp_mkgm2(srctmp, t1, srctmp, t4, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        FalconKeyGen.modp_iNTT2(srctmp, t2, srctmp, t4, logn, p, p0i);
        FalconKeyGen.modp_iNTT2(srctmp, t3, srctmp, t4, logn, p, p0i);
        for (u = 0; u < n; ++u) {
            srctmp[t1 + u] = FalconKeyGen.modp_norm(srctmp[t2 + u], p);
            srctmp[t2 + u] = FalconKeyGen.modp_norm(srctmp[t3 + u], p);
        }
        double[] tmp2 = new double[3 * n];
        int rt1 = 0;
        int rt2 = rt1 + n;
        int rt3 = rt2 + n;
        for (u = 0; u < n; ++u) {
            tmp2[rt3 + u] = srctmp[t2 + u];
        }
        FalconFFT.FFT(tmp2, rt3, logn);
        System.arraycopy(tmp2, rt3, tmp2, rt2, hn);
        rt3 = rt2 + hn;
        for (u = 0; u < n; ++u) {
            tmp2[rt3 + u] = srctmp[t1 + u];
        }
        FalconFFT.FFT(tmp2, rt3, logn);
        FalconFFT.poly_div_autoadj_fft(tmp2, rt3, tmp2, rt2, logn);
        FalconFFT.iFFT(tmp2, rt3, logn);
        for (u = 0; u < n; ++u) {
            srctmp[t1 + u] = FalconKeyGen.modp_set((int)FPREngine.fpr_rint(tmp2[rt3 + u]), p);
        }
        t2 = t1 + n;
        t3 = t2 + n;
        t4 = t3 + n;
        t5 = t4 + n;
        FalconKeyGen.modp_mkgm2(srctmp, t2, srctmp, t3, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        for (u = 0; u < n; ++u) {
            srctmp[t4 + u] = FalconKeyGen.modp_set(srcf[u], p);
            srctmp[t5 + u] = FalconKeyGen.modp_set(srcg[u], p);
        }
        FalconKeyGen.modp_NTT2(srctmp, t1, srctmp, t2, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, t4, srctmp, t2, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, t5, srctmp, t2, logn, p, p0i);
        for (u = 0; u < n; ++u) {
            int kw = FalconKeyGen.modp_montymul(srctmp[t1 + u], R2, p, p0i);
            srctmp[Fp2 + u] = FalconKeyGen.modp_sub(srctmp[Fp2 + u], FalconKeyGen.modp_montymul(kw, srctmp[t4 + u], p, p0i), p);
            srctmp[Gp + u] = FalconKeyGen.modp_sub(srctmp[Gp + u], FalconKeyGen.modp_montymul(kw, srctmp[t5 + u], p, p0i), p);
        }
        FalconKeyGen.modp_iNTT2(srctmp, Fp2, srctmp, t3, logn, p, p0i);
        FalconKeyGen.modp_iNTT2(srctmp, Gp, srctmp, t3, logn, p, p0i);
        for (u = 0; u < n; ++u) {
            srctmp[Fp2 + u] = FalconKeyGen.modp_norm(srctmp[Fp2 + u], p);
            srctmp[Gp + u] = FalconKeyGen.modp_norm(srctmp[Gp + u], p);
        }
        return 1;
    }

    private static int solve_NTRU(int logn, byte[] srcF, byte[] srcf, byte[] srcg, int lim, int[] srctmp) {
        int u;
        int depth;
        int G = 0;
        int n = FalconKeyGen.mkn(logn);
        if (FalconKeyGen.solve_NTRU_deepest(logn, srcf, srcg, srctmp) == 0) {
            return 0;
        }
        if (logn <= 2) {
            depth = logn;
            while (depth-- > 0) {
                if (FalconKeyGen.solve_NTRU_intermediate(logn, srcf, srcg, depth, srctmp) != 0) continue;
                return 0;
            }
        } else {
            depth = logn;
            while (depth-- > 2) {
                if (FalconKeyGen.solve_NTRU_intermediate(logn, srcf, srcg, depth, srctmp) != 0) continue;
                return 0;
            }
            if (FalconKeyGen.solve_NTRU_binary_depth1(logn, srcf, srcg, srctmp) == 0) {
                return 0;
            }
            if (FalconKeyGen.solve_NTRU_binary_depth0(logn, srcf, srcg, srctmp) == 0) {
                return 0;
            }
        }
        byte[] srcG = new byte[n];
        if (FalconKeyGen.poly_big_to_small(srcF, 0, srctmp, 0, lim, logn) == 0 || FalconKeyGen.poly_big_to_small(srcG, G, srctmp, n, lim, logn) == 0) {
            return 0;
        }
        int Gt = 0;
        int ft = Gt + n;
        int gt = ft + n;
        int Ft = gt + n;
        int gm = Ft + n;
        int p = FalconSmallPrimeList.PRIMES[0].p;
        int p0i = FalconKeyGen.modp_ninv31(p);
        FalconKeyGen.modp_mkgm2(srctmp, gm, srctmp, 0, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        for (u = 0; u < n; ++u) {
            srctmp[Gt + u] = FalconKeyGen.modp_set(srcG[G + u], p);
        }
        for (u = 0; u < n; ++u) {
            srctmp[ft + u] = FalconKeyGen.modp_set(srcf[u], p);
            srctmp[gt + u] = FalconKeyGen.modp_set(srcg[u], p);
            srctmp[Ft + u] = FalconKeyGen.modp_set(srcF[u], p);
        }
        FalconKeyGen.modp_NTT2(srctmp, ft, srctmp, gm, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, gt, srctmp, gm, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, Ft, srctmp, gm, logn, p, p0i);
        FalconKeyGen.modp_NTT2(srctmp, Gt, srctmp, gm, logn, p, p0i);
        int r = FalconKeyGen.modp_montymul(12289, 1, p, p0i);
        for (u = 0; u < n; ++u) {
            int z = FalconKeyGen.modp_sub(FalconKeyGen.modp_montymul(srctmp[ft + u], srctmp[Gt + u], p, p0i), FalconKeyGen.modp_montymul(srctmp[gt + u], srctmp[Ft + u], p, p0i), p);
            if (z == r) continue;
            return 0;
        }
        return 1;
    }

    private static void poly_small_mkgauss(SHAKEDigest rng, byte[] srcf, int logn) {
        int n = FalconKeyGen.mkn(logn);
        int mod2 = 0;
        for (int u = 0; u < n; ++u) {
            int s;
            block4: {
                while (true) {
                    if ((s = FalconKeyGen.mkgauss(rng, logn)) < -127 || s > 127) {
                        continue;
                    }
                    if (u != n - 1) break;
                    if ((mod2 ^ s & 1) == 0) {
                        continue;
                    }
                    break block4;
                    break;
                }
                mod2 ^= s & 1;
            }
            srcf[u] = (byte)s;
        }
    }

    static void keygen(SHAKEDigest rc, byte[] srcf, byte[] srcg, byte[] srcF, short[] srch, int logn) {
        int n = FalconKeyGen.mkn(logn);
        while (true) {
            int[] itmp;
            int tmp2;
            int h2;
            int normg;
            int normf;
            int norm;
            int u;
            double[] ftmp = new double[3 * n];
            FalconKeyGen.poly_small_mkgauss(rc, srcf, logn);
            FalconKeyGen.poly_small_mkgauss(rc, srcg, logn);
            int lim = 1 << FalconCodec.max_fg_bits[logn] - 1;
            for (u = 0; u < n; ++u) {
                if (srcf[u] < lim && srcf[u] > -lim && srcg[u] < lim && srcg[u] > -lim) continue;
                lim = -1;
                break;
            }
            if (lim < 0 || ((long)(norm = (normf = FalconKeyGen.poly_small_sqnorm(srcf, logn)) + (normg = FalconKeyGen.poly_small_sqnorm(srcg, logn)) | -((normf | normg) >>> 31)) & 0xFFFFFFFFL) >= 16823L) continue;
            int rt1 = 0;
            int rt2 = rt1 + n;
            int rt3 = rt2 + n;
            FalconKeyGen.poly_small_to_fp(ftmp, rt1, srcf, logn);
            FalconKeyGen.poly_small_to_fp(ftmp, rt2, srcg, logn);
            FalconFFT.FFT(ftmp, rt1, logn);
            FalconFFT.FFT(ftmp, rt2, logn);
            FalconFFT.poly_invnorm2_fft(ftmp, rt3, ftmp, rt1, ftmp, rt2, logn);
            FalconFFT.poly_adj_fft(ftmp, rt1, logn);
            FalconFFT.poly_adj_fft(ftmp, rt2, logn);
            FalconFFT.poly_mulconst(ftmp, rt1, 12289.0, logn);
            FalconFFT.poly_mulconst(ftmp, rt2, 12289.0, logn);
            FalconFFT.poly_mul_autoadj_fft(ftmp, rt1, ftmp, rt3, logn);
            FalconFFT.poly_mul_autoadj_fft(ftmp, rt2, ftmp, rt3, logn);
            FalconFFT.iFFT(ftmp, rt1, logn);
            FalconFFT.iFFT(ftmp, rt2, logn);
            double bnorm = 0.0;
            for (u = 0; u < n; ++u) {
                bnorm += ftmp[rt1 + u] * ftmp[rt1 + u] + ftmp[rt2 + u] * ftmp[rt2 + u];
            }
            if (bnorm >= 16822.4121) continue;
            short[] stmp = new short[2 * n];
            if (srch == null) {
                h2 = 0;
                srch = stmp;
                tmp2 = h2 + n;
            } else {
                h2 = 0;
                tmp2 = 0;
            }
            if (FalconVrfy.compute_public(srch, h2, srcf, srcg, logn, stmp, tmp2) != 0 && FalconKeyGen.solve_NTRU(logn, srcF, srcf, srcg, lim = (1 << FalconCodec.max_FG_bits[logn] - 1) - 1, itmp = logn > 2 ? new int[28 * n] : new int[28 * n * 3]) != 0) break;
        }
    }

    private static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }
}

