/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Longs;

abstract class AsconBaseEngine
implements AEADCipher {
    protected static final int UNINITIALIZED = 0;
    protected static final int ENCINIT = 1;
    protected static final int ENCAAD = 2;
    protected static final int ENCDATA = 3;
    protected static final int ENCFINAL = 4;
    protected static final int DECINIT = 5;
    protected static final int DECAAD = 6;
    protected static final int DECDATA = 7;
    protected static final int DECFINAL = 8;
    protected static final State Uninitialized = new State(0);
    protected static final State EncInit = new State(1);
    protected static final State EncAad = new State(2);
    protected static final State EncData = new State(3);
    protected static final State EncFinal = new State(4);
    protected static final State DecInit = new State(5);
    protected static final State DecAad = new State(6);
    protected static final State DecData = new State(7);
    protected static final State DecFinal = new State(8);
    protected State m_state = Uninitialized;
    protected String algorithmName;
    protected byte[] mac;
    protected byte[] initialAssociatedText;
    protected int CRYPTO_KEYBYTES;
    protected int CRYPTO_ABYTES;
    protected int nr;
    protected int ASCON_AEAD_RATE;
    protected long K0;
    protected long K1;
    protected long N0;
    protected long N1;
    protected long ASCON_IV;
    protected long x0;
    protected long x1;
    protected long x2;
    protected long x3;
    protected long x4;
    protected int m_bufferSizeDecrypt;
    protected byte[] m_buf;
    protected int m_bufPos = 0;
    protected long dsep;

    AsconBaseEngine() {
    }

    protected abstract long pad(int var1);

    protected abstract long loadBytes(byte[] var1, int var2);

    protected abstract void setBytes(long var1, byte[] var3, int var4);

    private void round(long C) {
        long t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
        long t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
        long t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
        long t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        long t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = t0 ^ Longs.rotateRight(t0, 19) ^ Longs.rotateRight(t0, 28);
        this.x1 = t1 ^ Longs.rotateRight(t1, 39) ^ Longs.rotateRight(t1, 61);
        this.x2 = t2 ^ Longs.rotateRight(t2, 1) ^ Longs.rotateRight(t2, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = t3 ^ Longs.rotateRight(t3, 10) ^ Longs.rotateRight(t3, 17);
        this.x4 = t4 ^ Longs.rotateRight(t4, 7) ^ Longs.rotateRight(t4, 41);
    }

    protected void p(int nr) {
        if (nr == 12) {
            this.round(240L);
            this.round(225L);
            this.round(210L);
            this.round(195L);
        }
        if (nr >= 8) {
            this.round(180L);
            this.round(165L);
        }
        this.round(150L);
        this.round(135L);
        this.round(120L);
        this.round(105L);
        this.round(90L);
        this.round(75L);
    }

    protected abstract void ascon_aeadinit();

    protected void checkAAD() {
        switch (this.m_state.ord) {
            case 5: {
                this.m_state = DecAad;
                break;
            }
            case 1: {
                this.m_state = EncAad;
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    protected boolean checkData() {
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                this.finishAAD(DecData);
                return false;
            }
            case 1: 
            case 2: {
                this.finishAAD(EncData);
                return true;
            }
            case 7: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    private void finishAAD(State nextState) {
        switch (this.m_state.ord) {
            case 2: 
            case 6: {
                this.processFinalAadBlock();
                this.p(this.nr);
                break;
            }
        }
        this.x4 ^= this.dsep;
        this.m_bufPos = 0;
        this.m_state = nextState;
    }

    protected abstract void processFinalAadBlock();

    protected abstract void processFinalDecrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void processFinalEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected void processBufferAAD(byte[] buffer, int inOff) {
        this.x0 ^= this.loadBytes(buffer, inOff);
        if (this.ASCON_AEAD_RATE == 16) {
            this.x1 ^= this.loadBytes(buffer, 8 + inOff);
        }
        this.p(this.nr);
    }

    protected void processBufferDecrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        if (outOff + this.ASCON_AEAD_RATE > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        long t0 = this.loadBytes(buffer, bufOff);
        this.setBytes(this.x0 ^ t0, output, outOff);
        this.x0 = t0;
        if (this.ASCON_AEAD_RATE == 16) {
            long t1 = this.loadBytes(buffer, bufOff + 8);
            this.setBytes(this.x1 ^ t1, output, outOff + 8);
            this.x1 = t1;
        }
        this.p(this.nr);
    }

    protected void processBufferEncrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        if (outOff + this.ASCON_AEAD_RATE > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.x0 ^= this.loadBytes(buffer, bufOff);
        this.setBytes(this.x0, output, outOff);
        if (this.ASCON_AEAD_RATE == 16) {
            this.x1 ^= this.loadBytes(buffer, bufOff + 8);
            this.setBytes(this.x1, output, outOff + 8);
        }
        this.p(this.nr);
    }

    public void processAADByte(byte in) {
        this.checkAAD();
        this.m_buf[this.m_bufPos] = in;
        if (++this.m_bufPos == this.ASCON_AEAD_RATE) {
            this.processBufferAAD(this.m_buf, 0);
            this.m_bufPos = 0;
        }
    }

    public void processAADBytes(byte[] inBytes, int inOff, int len) {
        if (inOff + len > inBytes.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (len <= 0) {
            return;
        }
        this.checkAAD();
        if (this.m_bufPos > 0) {
            int available = this.ASCON_AEAD_RATE - this.m_bufPos;
            if (len < available) {
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return;
            }
            System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.processBufferAAD(this.m_buf, 0);
        }
        while (len >= this.ASCON_AEAD_RATE) {
            this.processBufferAAD(inBytes, inOff);
            inOff += this.ASCON_AEAD_RATE;
            len -= this.ASCON_AEAD_RATE;
        }
        System.arraycopy(inBytes, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
    }

    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{in}, 0, 1, out, outOff);
    }

    public int processBytes(byte[] inBytes, int inOff, int len, byte[] outBytes, int outOff) throws DataLengthException {
        if (inOff + len > inBytes.length) {
            throw new DataLengthException("input buffer too short");
        }
        boolean forEncryption = this.checkData();
        int resultLength = 0;
        if (forEncryption) {
            if (this.m_bufPos > 0) {
                int available = this.ASCON_AEAD_RATE - this.m_bufPos;
                if (len < available) {
                    System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                    this.m_bufPos += len;
                    return 0;
                }
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                len -= available;
                this.processBufferEncrypt(this.m_buf, 0, outBytes, outOff);
                resultLength = this.ASCON_AEAD_RATE;
            }
            while (len >= this.ASCON_AEAD_RATE) {
                this.processBufferEncrypt(inBytes, inOff, outBytes, outOff + resultLength);
                inOff += this.ASCON_AEAD_RATE;
                len -= this.ASCON_AEAD_RATE;
                resultLength += this.ASCON_AEAD_RATE;
            }
        } else {
            int available = this.m_bufferSizeDecrypt - this.m_bufPos;
            if (len < available) {
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return 0;
            }
            while (this.m_bufPos >= this.ASCON_AEAD_RATE) {
                this.processBufferDecrypt(this.m_buf, 0, outBytes, outOff + resultLength);
                this.m_bufPos -= this.ASCON_AEAD_RATE;
                System.arraycopy(this.m_buf, this.ASCON_AEAD_RATE, this.m_buf, 0, this.m_bufPos);
                resultLength += this.ASCON_AEAD_RATE;
                if (len >= (available += this.ASCON_AEAD_RATE)) continue;
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return resultLength;
            }
            available = this.ASCON_AEAD_RATE - this.m_bufPos;
            System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.processBufferDecrypt(this.m_buf, 0, outBytes, outOff + resultLength);
            resultLength += this.ASCON_AEAD_RATE;
            while (len >= this.m_bufferSizeDecrypt) {
                this.processBufferDecrypt(inBytes, inOff, outBytes, outOff + resultLength);
                inOff += this.ASCON_AEAD_RATE;
                len -= this.ASCON_AEAD_RATE;
                resultLength += this.ASCON_AEAD_RATE;
            }
        }
        System.arraycopy(inBytes, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
        return resultLength;
    }

    public int doFinal(byte[] outBytes, int outOff) throws IllegalStateException, InvalidCipherTextException, DataLengthException {
        int resultLength;
        boolean forEncryption = this.checkData();
        if (forEncryption) {
            resultLength = this.m_bufPos + this.CRYPTO_ABYTES;
            if (outOff + resultLength > outBytes.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.processFinalEncrypt(this.m_buf, this.m_bufPos, outBytes, outOff);
            this.mac = new byte[this.CRYPTO_ABYTES];
            this.setBytes(this.x3, this.mac, 0);
            this.setBytes(this.x4, this.mac, 8);
            System.arraycopy(this.mac, 0, outBytes, outOff + this.m_bufPos, this.CRYPTO_ABYTES);
            this.reset(false);
        } else {
            if (this.m_bufPos < this.CRYPTO_ABYTES) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.CRYPTO_ABYTES;
            resultLength = this.m_bufPos;
            if (outOff + resultLength > outBytes.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.processFinalDecrypt(this.m_buf, this.m_bufPos, outBytes, outOff);
            this.x3 ^= this.loadBytes(this.m_buf, this.m_bufPos);
            this.x4 ^= this.loadBytes(this.m_buf, this.m_bufPos + 8);
            if ((this.x3 | this.x4) != 0L) {
                throw new InvalidCipherTextException("mac check in " + this.getAlgorithmName() + " failed");
            }
            this.reset(true);
        }
        return resultLength;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public int getUpdateOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                total = Math.max(0, total - this.CRYPTO_ABYTES);
                break;
            }
            case 7: 
            case 8: {
                total = Math.max(0, total + this.m_bufPos - this.CRYPTO_ABYTES);
                break;
            }
            case 3: 
            case 4: {
                total += this.m_bufPos;
                break;
            }
        }
        return total - total % this.ASCON_AEAD_RATE;
    }

    public int getOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                return Math.max(0, total - this.CRYPTO_ABYTES);
            }
            case 7: 
            case 8: {
                return Math.max(0, total + this.m_bufPos - this.CRYPTO_ABYTES);
            }
            case 3: 
            case 4: {
                return total + this.m_bufPos + this.CRYPTO_ABYTES;
            }
        }
        return total + this.CRYPTO_ABYTES;
    }

    public void reset() {
        this.reset(true);
    }

    protected void reset(boolean clearMac) {
        if (clearMac) {
            this.mac = null;
        }
        Arrays.clear(this.m_buf);
        this.m_bufPos = 0;
        switch (this.m_state.ord) {
            case 1: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_state = DecInit;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.m_state = EncFinal;
                return;
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
        this.ascon_aeadinit();
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public int getKeyBytesSize() {
        return this.CRYPTO_KEYBYTES;
    }

    public int getIVBytesSize() {
        return this.CRYPTO_ABYTES;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public abstract String getAlgorithmVersion();

    protected static class State {
        int ord;

        private State(int ord) {
            this.ord = ord;
        }
    }
}

