/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.AsconXofBase;
import org.bouncycastle.util.Pack;

public class AsconXof128
extends AsconXofBase {
    public AsconXof128() {
        this.algorithmName = "Ascon-XOF-128";
        this.reset();
    }

    protected long pad(int i) {
        return 1L << (i << 3);
    }

    protected long loadBytes(byte[] bytes, int inOff) {
        return Pack.littleEndianToLong(bytes, inOff);
    }

    protected long loadBytes(byte[] bytes, int inOff, int n) {
        return Pack.littleEndianToLong(bytes, inOff, n);
    }

    protected void setBytes(long w, byte[] bytes, int inOff) {
        Pack.longToLittleEndian(w, bytes, inOff);
    }

    protected void setBytes(long w, byte[] bytes, int inOff, int n) {
        Pack.longToLittleEndian(w, bytes, inOff, n);
    }

    public void reset() {
        super.reset();
        this.p.set(-2701369817892108309L, -3711838248891385495L, -1778763697082575311L, 1072114354614917324L, -2282070310009238562L);
    }
}

