/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.mldsa.Packing;
import org.bouncycastle.pqc.crypto.mldsa.Poly;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecMatrix;
import org.bouncycastle.pqc.crypto.mldsa.Symmetric;
import org.bouncycastle.util.Arrays;

class MLDSAEngine {
    private final SecureRandom random;
    final SHAKEDigest shake256Digest = new SHAKEDigest(256);
    public static final int DilithiumN = 256;
    public static final int DilithiumQ = 8380417;
    public static final int DilithiumQinv = 58728449;
    public static final int DilithiumD = 13;
    public static final int SeedBytes = 32;
    public static final int CrhBytes = 64;
    public static final int RndBytes = 32;
    public static final int TrBytes = 64;
    public static final int DilithiumPolyT1PackedBytes = 320;
    public static final int DilithiumPolyT0PackedBytes = 416;
    private final int DilithiumPolyVecHPackedBytes;
    private final int DilithiumPolyZPackedBytes;
    private final int DilithiumPolyW1PackedBytes;
    private final int DilithiumPolyEtaPackedBytes;
    private final int DilithiumMode;
    private final int DilithiumK;
    private final int DilithiumL;
    private final int DilithiumEta;
    private final int DilithiumTau;
    private final int DilithiumBeta;
    private final int DilithiumGamma1;
    private final int DilithiumGamma2;
    private final int DilithiumOmega;
    private final int DilithiumCTilde;
    private final int CryptoPublicKeyBytes;
    private final int CryptoSecretKeyBytes;
    private final int CryptoBytes;
    private final int PolyUniformGamma1NBlocks;
    private final Symmetric symmetric;

    protected Symmetric GetSymmetric() {
        return this.symmetric;
    }

    int getDilithiumPolyZPackedBytes() {
        return this.DilithiumPolyZPackedBytes;
    }

    int getDilithiumPolyW1PackedBytes() {
        return this.DilithiumPolyW1PackedBytes;
    }

    int getDilithiumPolyEtaPackedBytes() {
        return this.DilithiumPolyEtaPackedBytes;
    }

    int getDilithiumK() {
        return this.DilithiumK;
    }

    int getDilithiumL() {
        return this.DilithiumL;
    }

    int getDilithiumEta() {
        return this.DilithiumEta;
    }

    int getDilithiumTau() {
        return this.DilithiumTau;
    }

    int getDilithiumBeta() {
        return this.DilithiumBeta;
    }

    int getDilithiumGamma1() {
        return this.DilithiumGamma1;
    }

    int getDilithiumGamma2() {
        return this.DilithiumGamma2;
    }

    int getDilithiumOmega() {
        return this.DilithiumOmega;
    }

    int getDilithiumCTilde() {
        return this.DilithiumCTilde;
    }

    int getCryptoPublicKeyBytes() {
        return this.CryptoPublicKeyBytes;
    }

    int getPolyUniformGamma1NBlocks() {
        return this.PolyUniformGamma1NBlocks;
    }

    MLDSAEngine(int mode, SecureRandom random) {
        this.DilithiumMode = mode;
        switch (mode) {
            case 2: {
                this.DilithiumK = 4;
                this.DilithiumL = 4;
                this.DilithiumEta = 2;
                this.DilithiumTau = 39;
                this.DilithiumBeta = 78;
                this.DilithiumGamma1 = 131072;
                this.DilithiumGamma2 = 95232;
                this.DilithiumOmega = 80;
                this.DilithiumPolyZPackedBytes = 576;
                this.DilithiumPolyW1PackedBytes = 192;
                this.DilithiumPolyEtaPackedBytes = 96;
                this.DilithiumCTilde = 32;
                break;
            }
            case 3: {
                this.DilithiumK = 6;
                this.DilithiumL = 5;
                this.DilithiumEta = 4;
                this.DilithiumTau = 49;
                this.DilithiumBeta = 196;
                this.DilithiumGamma1 = 524288;
                this.DilithiumGamma2 = 261888;
                this.DilithiumOmega = 55;
                this.DilithiumPolyZPackedBytes = 640;
                this.DilithiumPolyW1PackedBytes = 128;
                this.DilithiumPolyEtaPackedBytes = 128;
                this.DilithiumCTilde = 48;
                break;
            }
            case 5: {
                this.DilithiumK = 8;
                this.DilithiumL = 7;
                this.DilithiumEta = 2;
                this.DilithiumTau = 60;
                this.DilithiumBeta = 120;
                this.DilithiumGamma1 = 524288;
                this.DilithiumGamma2 = 261888;
                this.DilithiumOmega = 75;
                this.DilithiumPolyZPackedBytes = 640;
                this.DilithiumPolyW1PackedBytes = 128;
                this.DilithiumPolyEtaPackedBytes = 96;
                this.DilithiumCTilde = 64;
                break;
            }
            default: {
                throw new IllegalArgumentException("The mode " + mode + "is not supported by Crystals Dilithium!");
            }
        }
        this.symmetric = new Symmetric.ShakeSymmetric();
        this.random = random;
        this.DilithiumPolyVecHPackedBytes = this.DilithiumOmega + this.DilithiumK;
        this.CryptoPublicKeyBytes = 32 + this.DilithiumK * 320;
        this.CryptoSecretKeyBytes = 128 + this.DilithiumL * this.DilithiumPolyEtaPackedBytes + this.DilithiumK * this.DilithiumPolyEtaPackedBytes + this.DilithiumK * 416;
        this.CryptoBytes = this.DilithiumCTilde + this.DilithiumL * this.DilithiumPolyZPackedBytes + this.DilithiumPolyVecHPackedBytes;
        if (this.DilithiumGamma1 == 131072) {
            this.PolyUniformGamma1NBlocks = (576 + this.symmetric.stream256BlockBytes - 1) / this.symmetric.stream256BlockBytes;
        } else if (this.DilithiumGamma1 == 524288) {
            this.PolyUniformGamma1NBlocks = (640 + this.symmetric.stream256BlockBytes - 1) / this.symmetric.stream256BlockBytes;
        } else {
            throw new RuntimeException("Wrong Dilithium Gamma1!");
        }
    }

    byte[][] generateKeyPairInternal(byte[] seed) {
        byte[] buf = new byte[128];
        byte[] tr = new byte[64];
        byte[] rho = new byte[32];
        byte[] rhoPrime = new byte[64];
        byte[] key = new byte[32];
        PolyVecMatrix aMatrix = new PolyVecMatrix(this);
        PolyVecL s1 = new PolyVecL(this);
        PolyVecK s2 = new PolyVecK(this);
        PolyVecK t1 = new PolyVecK(this);
        PolyVecK t0 = new PolyVecK(this);
        this.shake256Digest.update(seed, 0, 32);
        this.shake256Digest.update((byte)this.DilithiumK);
        this.shake256Digest.update((byte)this.DilithiumL);
        this.shake256Digest.doFinal(buf, 0, 128);
        System.arraycopy(buf, 0, rho, 0, 32);
        System.arraycopy(buf, 32, rhoPrime, 0, 64);
        System.arraycopy(buf, 96, key, 0, 32);
        aMatrix.expandMatrix(rho);
        s1.uniformEta(rhoPrime, (short)0);
        s2.uniformEta(rhoPrime, (short)this.DilithiumL);
        PolyVecL s1hat = new PolyVecL(this);
        s1.copyTo(s1hat);
        s1hat.polyVecNtt();
        aMatrix.pointwiseMontgomery(t1, s1hat);
        t1.reduce();
        t1.invNttToMont();
        t1.addPolyVecK(s2);
        t1.conditionalAddQ();
        t1.power2Round(t0);
        byte[] encT1 = Packing.packPublicKey(t1, this);
        this.shake256Digest.update(rho, 0, rho.length);
        this.shake256Digest.update(encT1, 0, encT1.length);
        this.shake256Digest.doFinal(tr, 0, 64);
        byte[][] sk = Packing.packSecretKey(rho, tr, key, t0, s1, s2, this);
        return new byte[][]{sk[0], sk[1], sk[2], sk[3], sk[4], sk[5], encT1, seed};
    }

    byte[] deriveT1(byte[] rho, byte[] key, byte[] tr, byte[] s1Enc, byte[] s2Enc, byte[] t0Enc) {
        PolyVecMatrix aMatrix = new PolyVecMatrix(this);
        PolyVecL s1 = new PolyVecL(this);
        PolyVecK s2 = new PolyVecK(this);
        PolyVecK t1 = new PolyVecK(this);
        PolyVecK t0 = new PolyVecK(this);
        Packing.unpackSecretKey(t0, s1, s2, t0Enc, s1Enc, s2Enc, this);
        aMatrix.expandMatrix(rho);
        PolyVecL s1hat = new PolyVecL(this);
        s1.copyTo(s1hat);
        s1hat.polyVecNtt();
        aMatrix.pointwiseMontgomery(t1, s1hat);
        t1.reduce();
        t1.invNttToMont();
        t1.addPolyVecK(s2);
        t1.conditionalAddQ();
        t1.power2Round(t0);
        byte[] encT1 = Packing.packPublicKey(t1, this);
        return encT1;
    }

    SHAKEDigest getShake256Digest() {
        return new SHAKEDigest(this.shake256Digest);
    }

    void initSign(byte[] tr, boolean isPreHash, byte[] ctx) {
        this.shake256Digest.update(tr, 0, 64);
        this.absorbCtx(isPreHash, ctx);
    }

    void initVerify(byte[] rho, byte[] encT1, boolean isPreHash, byte[] ctx) {
        byte[] mu = new byte[64];
        this.shake256Digest.update(rho, 0, rho.length);
        this.shake256Digest.update(encT1, 0, encT1.length);
        this.shake256Digest.doFinal(mu, 0, 64);
        this.shake256Digest.update(mu, 0, 64);
        this.absorbCtx(isPreHash, ctx);
    }

    void absorbCtx(boolean isPreHash, byte[] ctx) {
        if (ctx != null) {
            this.shake256Digest.update(isPreHash ? (byte)1 : 0);
            this.shake256Digest.update((byte)ctx.length);
            this.shake256Digest.update(ctx, 0, ctx.length);
        }
    }

    byte[] signInternal(byte[] msg, int msglen, byte[] rho, byte[] key, byte[] t0Enc, byte[] s1Enc, byte[] s2Enc, byte[] rnd) {
        SHAKEDigest shake256 = new SHAKEDigest(this.shake256Digest);
        shake256.update(msg, 0, msglen);
        return this.generateSignature(this.generateMu(shake256), shake256, rho, key, t0Enc, s1Enc, s2Enc, rnd);
    }

    byte[] generateMu(SHAKEDigest shake256Digest) {
        byte[] mu = new byte[64];
        shake256Digest.doFinal(mu, 0, 64);
        return mu;
    }

    byte[] generateSignature(byte[] mu, SHAKEDigest shake256Digest, byte[] rho, byte[] key, byte[] t0Enc, byte[] s1Enc, byte[] s2Enc, byte[] rnd) {
        byte[] outSig = new byte[this.CryptoBytes];
        byte[] rhoPrime = new byte[64];
        short nonce = 0;
        PolyVecL s1 = new PolyVecL(this);
        PolyVecL y = new PolyVecL(this);
        PolyVecL z = new PolyVecL(this);
        PolyVecK t0 = new PolyVecK(this);
        PolyVecK s2 = new PolyVecK(this);
        PolyVecK w1 = new PolyVecK(this);
        PolyVecK w0 = new PolyVecK(this);
        PolyVecK h = new PolyVecK(this);
        Poly cp = new Poly(this);
        PolyVecMatrix aMatrix = new PolyVecMatrix(this);
        Packing.unpackSecretKey(t0, s1, s2, t0Enc, s1Enc, s2Enc, this);
        byte[] keyMu = Arrays.copyOf(key, 128);
        System.arraycopy(rnd, 0, keyMu, 32, 32);
        System.arraycopy(mu, 0, keyMu, 64, 64);
        shake256Digest.update(keyMu, 0, 128);
        shake256Digest.doFinal(rhoPrime, 0, 64);
        aMatrix.expandMatrix(rho);
        s1.polyVecNtt();
        s2.polyVecNtt();
        t0.polyVecNtt();
        int count = 0;
        while (count < 1000) {
            ++count;
            short s = nonce;
            nonce = (short)(nonce + 1);
            y.uniformGamma1(rhoPrime, s);
            y.copyTo(z);
            z.polyVecNtt();
            aMatrix.pointwiseMontgomery(w1, z);
            w1.reduce();
            w1.invNttToMont();
            w1.conditionalAddQ();
            w1.decompose(w0);
            w1.packW1(this, outSig, 0);
            shake256Digest.update(mu, 0, 64);
            shake256Digest.update(outSig, 0, this.DilithiumK * this.DilithiumPolyW1PackedBytes);
            shake256Digest.doFinal(outSig, 0, this.DilithiumCTilde);
            cp.challenge(outSig, 0, this.DilithiumCTilde);
            cp.polyNtt();
            z.pointwisePolyMontgomery(cp, s1);
            z.invNttToMont();
            z.addPolyVecL(y);
            z.reduce();
            if (z.checkNorm(this.DilithiumGamma1 - this.DilithiumBeta)) continue;
            h.pointwisePolyMontgomery(cp, s2);
            h.invNttToMont();
            w0.subtract(h);
            w0.reduce();
            if (w0.checkNorm(this.DilithiumGamma2 - this.DilithiumBeta)) continue;
            h.pointwisePolyMontgomery(cp, t0);
            h.invNttToMont();
            h.reduce();
            if (h.checkNorm(this.DilithiumGamma2)) continue;
            w0.addPolyVecK(h);
            w0.conditionalAddQ();
            int n = h.makeHint(w0, w1);
            if (n > this.DilithiumOmega) continue;
            Packing.packSignature(outSig, z, h, this);
            return outSig;
        }
        return null;
    }

    boolean verifyInternalMu(byte[] providedMu) {
        byte[] mu = new byte[64];
        this.shake256Digest.doFinal(mu, 0);
        return Arrays.constantTimeAreEqual(mu, providedMu);
    }

    boolean verifyInternalMuSignature(byte[] mu, byte[] sig, int siglen, SHAKEDigest shake256Digest, byte[] rho, byte[] encT1) {
        byte[] buf = new byte[Math.max(64 + this.DilithiumK * this.DilithiumPolyW1PackedBytes, this.DilithiumCTilde)];
        System.arraycopy(mu, 0, buf, 0, mu.length);
        return this.doVerifyInternal(buf, sig, siglen, shake256Digest, rho, encT1);
    }

    boolean verifyInternal(byte[] sig, int siglen, SHAKEDigest shake256Digest, byte[] rho, byte[] encT1) {
        byte[] buf = new byte[Math.max(64 + this.DilithiumK * this.DilithiumPolyW1PackedBytes, this.DilithiumCTilde)];
        shake256Digest.doFinal(buf, 0);
        return this.doVerifyInternal(buf, sig, siglen, shake256Digest, rho, encT1);
    }

    private boolean doVerifyInternal(byte[] buf, byte[] sig, int siglen, SHAKEDigest shake256Digest, byte[] rho, byte[] encT1) {
        if (siglen != this.CryptoBytes) {
            return false;
        }
        PolyVecL z = new PolyVecL(this);
        PolyVecK h = new PolyVecK(this);
        if (!Packing.unpackSignature(z, h, sig, this)) {
            return false;
        }
        if (z.checkNorm(this.getDilithiumGamma1() - this.getDilithiumBeta())) {
            return false;
        }
        Poly cp = new Poly(this);
        PolyVecMatrix aMatrix = new PolyVecMatrix(this);
        PolyVecK t1 = new PolyVecK(this);
        PolyVecK w1 = new PolyVecK(this);
        t1 = Packing.unpackPublicKey(t1, encT1, this);
        cp.challenge(sig, 0, this.DilithiumCTilde);
        aMatrix.expandMatrix(rho);
        z.polyVecNtt();
        aMatrix.pointwiseMontgomery(w1, z);
        cp.polyNtt();
        t1.shiftLeft();
        t1.polyVecNtt();
        t1.pointwisePolyMontgomery(cp, t1);
        w1.subtract(t1);
        w1.reduce();
        w1.invNttToMont();
        w1.conditionalAddQ();
        w1.useHint(w1, h);
        w1.packW1(this, buf, 64);
        shake256Digest.update(buf, 0, 64 + this.DilithiumK * this.DilithiumPolyW1PackedBytes);
        shake256Digest.doFinal(buf, 0, this.DilithiumCTilde);
        return Arrays.constantTimeAreEqual(this.DilithiumCTilde, sig, 0, buf, 0);
    }

    byte[][] generateKeyPair() {
        byte[] seedBuf = new byte[32];
        this.random.nextBytes(seedBuf);
        return this.generateKeyPairInternal(seedBuf);
    }
}

