/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.ParametersWithContext;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.DigestUtils;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;

public class HashMLDSASigner
implements Signer {
    private static final byte[] EMPTY_CONTEXT = new byte[0];
    private MLDSAPublicKeyParameters pubKey;
    private MLDSAPrivateKeyParameters privKey;
    private SecureRandom random;
    private MLDSAEngine engine;
    private Digest digest;

    public void init(boolean forSigning, CipherParameters param) {
        byte[] digestOIDEncoding;
        MLDSAParameters parameters;
        byte[] ctx = EMPTY_CONTEXT;
        if (param instanceof ParametersWithContext) {
            ParametersWithContext withContext = (ParametersWithContext)param;
            ctx = withContext.getContext();
            param = withContext.getParameters();
            if (ctx.length > 255) {
                throw new IllegalArgumentException("context too long");
            }
        }
        if (forSigning) {
            this.pubKey = null;
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom withRandom = (ParametersWithRandom)param;
                this.privKey = (MLDSAPrivateKeyParameters)withRandom.getParameters();
                this.random = withRandom.getRandom();
            } else {
                this.privKey = (MLDSAPrivateKeyParameters)param;
                this.random = null;
            }
            parameters = this.privKey.getParameters();
            this.engine = parameters.getEngine(this.random);
            this.engine.initSign(this.privKey.tr, true, ctx);
        } else {
            this.pubKey = (MLDSAPublicKeyParameters)param;
            this.privKey = null;
            this.random = null;
            parameters = this.pubKey.getParameters();
            this.engine = parameters.getEngine(null);
            this.engine.initVerify(this.pubKey.rho, this.pubKey.t1, true, ctx);
        }
        this.digest = this.engine.shake256Digest;
        try {
            digestOIDEncoding = DigestUtils.getDigestOid(this.digest.getAlgorithmName()).getEncoded("DER");
        }
        catch (IOException e) {
            throw new IllegalStateException("oid encoding failed: " + e.getMessage());
        }
        this.digest.update(digestOIDEncoding, 0, digestOIDEncoding.length);
    }

    public void update(byte b) {
        this.digest.update(b);
    }

    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        byte[] rnd = new byte[32];
        if (this.random != null) {
            this.random.nextBytes(rnd);
        }
        byte[] mu = this.engine.generateMu(this.engine.shake256Digest);
        return this.engine.generateSignature(mu, this.engine.getShake256Digest(), this.privKey.rho, this.privKey.k, this.privKey.t0, this.privKey.s1, this.privKey.s2, rnd);
    }

    public boolean verifySignature(byte[] signature) {
        byte[] mu = this.engine.generateMu(this.engine.shake256Digest);
        return this.engine.verifyInternalMuSignature(mu, signature, signature.length, this.engine.getShake256Digest(), this.pubKey.rho, this.pubKey.t1);
    }

    public void reset() {
        this.digest.reset();
    }
}

