/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider;

import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import org.bouncycastle.pqc.jcajce.provider.picnic.PicnicKeyFactorySpi;

public class Picnic {
    private static final String PREFIX = "org.bouncycastle.pqc.jcajce.provider.picnic.";

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("KeyFactory.PICNIC", "org.bouncycastle.pqc.jcajce.provider.picnic.PicnicKeyFactorySpi");
            provider.addAlgorithm("KeyPairGenerator.PICNIC", "org.bouncycastle.pqc.jcajce.provider.picnic.PicnicKeyPairGeneratorSpi");
            this.addSignatureAlgorithm(provider, "PICNIC", "org.bouncycastle.pqc.jcajce.provider.picnic.SignatureSpi$Base", BCObjectIdentifiers.picnic_signature);
            this.addSignatureAlgorithm(provider, "SHAKE256", "PICNIC", "org.bouncycastle.pqc.jcajce.provider.picnic.SignatureSpi$withShake256", BCObjectIdentifiers.picnic_with_shake256);
            this.addSignatureAlgorithm(provider, "SHA512", "PICNIC", "org.bouncycastle.pqc.jcajce.provider.picnic.SignatureSpi$withSha512", BCObjectIdentifiers.picnic_with_sha512);
            this.addSignatureAlgorithm(provider, "SHA3-512", "PICNIC", "org.bouncycastle.pqc.jcajce.provider.picnic.SignatureSpi$withSha3512", BCObjectIdentifiers.picnic_with_sha3_512);
            PicnicKeyFactorySpi keyFact = new PicnicKeyFactorySpi();
            this.registerOid(provider, BCObjectIdentifiers.picnic_key, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl1fs, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl1ur, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl3fs, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl3ur, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl5fs, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl5ur, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnic3l1, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnic3l3, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnic3l5, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl1full, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl3full, "Picnic", keyFact);
            this.registerOid(provider, BCObjectIdentifiers.picnicl5full, "Picnic", keyFact);
        }
    }
}

