/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.slhdsa;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.jcajce.provider.asymmetric.slhdsa.BCSLHDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.slhdsa.BCSLHDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseDeterministicOrRandomSignature;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSASigner;

public class SignatureSpi
extends BaseDeterministicOrRandomSignature {
    private final ByteArrayOutputStream bOut = new ByteArrayOutputStream();
    private final SLHDSASigner signer;

    protected SignatureSpi(SLHDSASigner signer) {
        super("SLH-DSA");
        this.signer = signer;
    }

    protected void verifyInit(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCSLHDSAPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to SLH-DSA");
        }
        BCSLHDSAPublicKey key = (BCSLHDSAPublicKey)publicKey;
        this.keyParams = key.getKeyParams();
    }

    protected void signInit(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.appRandom = random;
        if (!(privateKey instanceof BCSLHDSAPrivateKey)) {
            throw new InvalidKeyException("unknown private key passed to SLH-DSA");
        }
        BCSLHDSAPrivateKey key = (BCSLHDSAPrivateKey)privateKey;
        this.keyParams = key.getKeyParams();
    }

    protected void updateEngine(byte b) throws SignatureException {
        this.bOut.write(b);
    }

    protected void updateEngine(byte[] buf, int off, int len) throws SignatureException {
        this.bOut.write(buf, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        AsymmetricKeyParameter param = this.keyParams;
        if (!(param instanceof SLHDSAPrivateKeyParameters)) {
            throw new SignatureException("engine initialized for verification");
        }
        try {
            byte[] sig;
            byte[] byArray = sig = this.signer.generateSignature(this.bOut.toByteArray());
            return byArray;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
        finally {
            this.isInitState = true;
            this.bOut.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        AsymmetricKeyParameter param = this.keyParams;
        if (!(param instanceof SLHDSAPublicKeyParameters)) {
            throw new SignatureException("engine initialized for signing");
        }
        try {
            boolean bl = this.signer.verifySignature(this.bOut.toByteArray(), sigBytes);
            return bl;
        }
        finally {
            this.isInitState = true;
            this.bOut.reset();
        }
    }

    protected void reInitialize(boolean forSigning, CipherParameters params) {
        this.signer.init(forSigning, params);
        this.bOut.reset();
    }

    public static class Direct
    extends SignatureSpi {
        public Direct() {
            super(new SLHDSASigner());
        }
    }
}

