/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;

public class DeltaCertificateDescriptor
extends ASN1Object {
    private final ASN1Integer serialNumber;
    private AlgorithmIdentifier signature;
    private X500Name issuer;
    private ASN1Sequence validity;
    private X500Name subject;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private Extensions extensions;
    private final ASN1BitString signatureValue;

    public static DeltaCertificateDescriptor getInstance(Object obj) {
        if (obj instanceof DeltaCertificateDescriptor) {
            return (DeltaCertificateDescriptor)obj;
        }
        if (obj != null) {
            return new DeltaCertificateDescriptor(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static DeltaCertificateDescriptor fromExtensions(Extensions extensions) {
        return DeltaCertificateDescriptor.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.deltaCertificateDescriptor));
    }

    private DeltaCertificateDescriptor(ASN1Sequence seq) {
        ASN1TaggedObject tagged;
        this.serialNumber = ASN1Integer.getInstance(seq.getObjectAt(0));
        int idx = 1;
        ASN1Encodable next = seq.getObjectAt(idx);
        while (next instanceof ASN1TaggedObject) {
            tagged = ASN1TaggedObject.getInstance(next);
            switch (tagged.getTagNo()) {
                case 0: {
                    this.signature = AlgorithmIdentifier.getInstance(tagged, false);
                    break;
                }
                case 1: {
                    this.issuer = X500Name.getInstance(tagged, true);
                    break;
                }
                case 2: {
                    this.validity = ASN1Sequence.getInstance(tagged, false);
                    break;
                }
                case 3: {
                    this.subject = X500Name.getInstance(tagged, true);
                }
            }
            next = seq.getObjectAt(idx++);
        }
        this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(next);
        next = seq.getObjectAt(idx);
        while (next instanceof ASN1TaggedObject) {
            tagged = ASN1TaggedObject.getInstance(next);
            switch (tagged.getTagNo()) {
                case 4: {
                    this.extensions = Extensions.getInstance(tagged, false);
                }
            }
            next = seq.getObjectAt(idx++);
        }
        this.signatureValue = ASN1BitString.getInstance(next);
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public ASN1Sequence getValidity() {
        return this.validity;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public ASN1BitString getSignatureValue() {
        return this.signatureValue;
    }

    public DeltaCertificateDescriptor trimTo(TBSCertificate baseTbsCertificate, Extensions tbsExtensions) {
        ASN1TaggedObject tagged;
        AlgorithmIdentifier signature = baseTbsCertificate.signature;
        X500Name issuer = baseTbsCertificate.issuer;
        DERSequence validity = new DERSequence(new ASN1Encodable[]{baseTbsCertificate.startDate, baseTbsCertificate.endDate});
        X500Name subject = baseTbsCertificate.subject;
        ASN1Sequence s = ASN1Sequence.getInstance(this.toASN1Primitive());
        ASN1EncodableVector v = new ASN1EncodableVector();
        Enumeration en = s.getObjects();
        v.add((ASN1Encodable)en.nextElement());
        ASN1Encodable next = (ASN1Encodable)en.nextElement();
        while (next instanceof ASN1TaggedObject) {
            tagged = ASN1TaggedObject.getInstance(next);
            switch (tagged.getTagNo()) {
                case 0: {
                    AlgorithmIdentifier sig = AlgorithmIdentifier.getInstance(tagged, false);
                    if (sig.equals(signature)) break;
                    v.add(next);
                    break;
                }
                case 1: {
                    X500Name iss = X500Name.getInstance(tagged, true);
                    if (iss.equals(issuer)) break;
                    v.add(next);
                    break;
                }
                case 2: {
                    ASN1Sequence val = ASN1Sequence.getInstance(tagged, false);
                    if (val.equals(validity)) break;
                    v.add(next);
                    break;
                }
                case 3: {
                    X500Name sub = X500Name.getInstance(tagged, true);
                    if (sub.equals(subject)) break;
                    v.add(next);
                }
            }
            next = (ASN1Encodable)en.nextElement();
        }
        v.add(next);
        next = (ASN1Encodable)en.nextElement();
        while (next instanceof ASN1TaggedObject) {
            tagged = ASN1TaggedObject.getInstance(next);
            switch (tagged.getTagNo()) {
                case 4: {
                    Extensions deltaExts = Extensions.getInstance(tagged, false);
                    ExtensionsGenerator deltaExtGen = new ExtensionsGenerator();
                    Enumeration extEn = deltaExts.oids();
                    while (extEn.hasMoreElements()) {
                        Extension deltaExt = deltaExts.getExtension((ASN1ObjectIdentifier)extEn.nextElement());
                        Extension primaryExt = tbsExtensions.getExtension(deltaExt.getExtnId());
                        if (primaryExt == null || deltaExt.equals(primaryExt)) continue;
                        deltaExtGen.addExtension(deltaExt);
                    }
                    if (deltaExtGen.isEmpty()) break;
                    v.add(new DERTaggedObject(false, 4, (ASN1Encodable)deltaExtGen.generate()));
                }
            }
            next = (ASN1Encodable)en.nextElement();
        }
        v.add(next);
        return new DeltaCertificateDescriptor(new DERSequence(v));
    }

    private void addOptional(ASN1EncodableVector v, int tag, boolean explicit, ASN1Object obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(explicit, tag, (ASN1Encodable)obj));
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(7);
        v.add(this.serialNumber);
        this.addOptional(v, 0, false, this.signature);
        this.addOptional(v, 1, true, this.issuer);
        this.addOptional(v, 2, false, this.validity);
        this.addOptional(v, 3, true, this.subject);
        v.add(this.subjectPublicKeyInfo);
        this.addOptional(v, 4, false, this.extensions);
        v.add(this.signatureValue);
        return new DERSequence(v);
    }
}

