/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.math.raw.Bits;

public class Integers {
    private static final byte[] DEBRUIJN_TZ = new byte[]{0, 1, 2, 24, 3, 19, 6, 25, 22, 4, 20, 10, 16, 7, 12, 26, 31, 23, 18, 5, 21, 9, 15, 11, 30, 17, 8, 14, 29, 13, 28, 27};

    public static int numberOfLeadingZeros(int i) {
        if (i <= 0) {
            return ~i >>> 26 & 0x20;
        }
        int n = 1;
        if (0 == i >>> 16) {
            n += 16;
            i <<= 16;
        }
        if (0 == i >>> 24) {
            n += 8;
            i <<= 8;
        }
        if (0 == i >>> 28) {
            n += 4;
            i <<= 4;
        }
        if (0 == i >>> 30) {
            n += 2;
            i <<= 2;
        }
        return n -= i >>> 31;
    }

    public static int numberOfTrailingZeros(int i) {
        return DEBRUIJN_TZ[(i & -i) * 81224991 >>> 27];
    }

    public static int reverse(int i) {
        i = Bits.bitPermuteStepSimple(i, 0x55555555, 1);
        i = Bits.bitPermuteStepSimple(i, 0x33333333, 2);
        i = Bits.bitPermuteStepSimple(i, 0xF0F0F0F, 4);
        return Integers.reverseBytes(i);
    }

    public static int reverseBytes(int i) {
        return Integers.rotateLeft(i & 0xFF00FF00, 8) | Integers.rotateLeft(i & 0xFF00FF, 24);
    }

    public static int rotateLeft(int i, int distance) {
        return i << distance ^ i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> distance ^ i << -distance;
    }

    public static Integer valueOf(int value) {
        return new Integer(value);
    }
}

