/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public class PGPSecretKey {
    SecretKeyPacket secret;
    PGPPublicKey pub;

    public PGPSecretKey(SecretKeyPacket secretKeyPacket, PGPPublicKey pGPPublicKey) {
        this.secret = secretKeyPacket;
        this.pub = pGPPublicKey;
    }

    PGPSecretKey(PGPPrivateKey pGPPrivateKey, PGPPublicKey pGPPublicKey, PGPDigestCalculator pGPDigestCalculator, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this(pGPPrivateKey, pGPPublicKey, pGPDigestCalculator, false, pBESecretKeyEncryptor);
    }

    public PGPSecretKey(PGPPrivateKey pGPPrivateKey, PGPPublicKey pGPPublicKey, PGPDigestCalculator pGPDigestCalculator, boolean bl, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.pub = PGPSecretKey.buildPublicKey(bl, pGPPublicKey);
        this.secret = PGPSecretKey.buildSecretKeyPacket(bl, pGPPrivateKey, pGPPublicKey, pBESecretKeyEncryptor, pGPDigestCalculator);
    }

    private static PGPPublicKey buildPublicKey(boolean bl, PGPPublicKey pGPPublicKey) {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.publicPk;
        if (bl && (!pGPPublicKey.isEncryptionKey() || publicKeyPacket.getAlgorithm() == 1)) {
            PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
            pGPPublicKey2.publicPk = new PublicKeyPacket(publicKeyPacket.getAlgorithm(), publicKeyPacket.getTime(), publicKeyPacket.getKey());
            return pGPPublicKey2;
        }
        PGPPublicKey pGPPublicKey3 = new PGPPublicKey(pGPPublicKey);
        pGPPublicKey3.publicPk = new PublicSubkeyPacket(publicKeyPacket.getAlgorithm(), publicKeyPacket.getTime(), publicKeyPacket.getKey());
        return pGPPublicKey3;
    }

    private static SecretKeyPacket buildSecretKeyPacket(boolean bl, PGPPrivateKey pGPPrivateKey, PGPPublicKey pGPPublicKey, PBESecretKeyEncryptor pBESecretKeyEncryptor, PGPDigestCalculator pGPDigestCalculator) throws PGPException {
        BCPGObject bCPGObject = (BCPGObject)((Object)pGPPrivateKey.getPrivateKeyDataPacket());
        if (bCPGObject == null) {
            if (bl) {
                return new SecretKeyPacket(pGPPublicKey.publicPk, 0, null, null, new byte[0]);
            }
            return new SecretSubkeyPacket(pGPPublicKey.publicPk, 0, null, null, new byte[0]);
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
            bCPGOutputStream.writeObject(bCPGObject);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n2 = n = pBESecretKeyEncryptor != null ? pBESecretKeyEncryptor.getAlgorithm() : 0;
            if (n != 0) {
                int n3;
                bCPGOutputStream.write(PGPSecretKey.checksum(pGPDigestCalculator, byArray, byArray.length));
                byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = pBESecretKeyEncryptor.encryptKeyData(byArray, 0, byArray.length);
                byte[] byArray3 = pBESecretKeyEncryptor.getCipherIV();
                S2K s2K = pBESecretKeyEncryptor.getS2K();
                if (pGPDigestCalculator != null) {
                    if (pGPDigestCalculator.getAlgorithm() != 2) {
                        throw new PGPException("only SHA1 supported for key checksum calculations.");
                    }
                    n3 = 254;
                } else {
                    n3 = 255;
                }
                if (bl) {
                    return new SecretKeyPacket(pGPPublicKey.publicPk, n, n3, s2K, byArray3, byArray2);
                }
                return new SecretSubkeyPacket(pGPPublicKey.publicPk, n, n3, s2K, byArray3, byArray2);
            }
            bCPGOutputStream.write(PGPSecretKey.checksum(null, byArray, byArray.length));
            if (bl) {
                return new SecretKeyPacket(pGPPublicKey.publicPk, n, null, null, byteArrayOutputStream.toByteArray());
            }
            return new SecretSubkeyPacket(pGPPublicKey.publicPk, n, null, null, byteArrayOutputStream.toByteArray());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception encrypting key", exception);
        }
    }

    public PGPSecretKey(int n, PGPKeyPair pGPKeyPair, String string, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this(n, pGPKeyPair, string, null, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, pGPContentSignerBuilder, pBESecretKeyEncryptor);
    }

    public PGPSecretKey(PGPKeyPair pGPKeyPair, PGPKeyPair pGPKeyPair2, PGPDigestCalculator pGPDigestCalculator, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this(pGPKeyPair, pGPKeyPair2, pGPDigestCalculator, null, null, pGPContentSignerBuilder, pBESecretKeyEncryptor);
    }

    public PGPSecretKey(PGPKeyPair pGPKeyPair, PGPKeyPair pGPKeyPair2, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        Object object;
        Object object2;
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(pGPContentSignerBuilder);
        pGPSignatureGenerator.init(24, pGPKeyPair.getPrivateKey());
        if (!pGPKeyPair2.getPublicKey().isEncryptionKey()) {
            if (pGPSignatureSubpacketVector == null) {
                object2 = new PGPSignatureGenerator(pGPContentSignerBuilder);
                ((PGPSignatureGenerator)object2).init(25, pGPKeyPair2.getPrivateKey());
                object = new PGPSignatureSubpacketGenerator();
                try {
                    ((PGPSignatureSubpacketGenerator)object).addEmbeddedSignature(false, ((PGPSignatureGenerator)object2).generateCertification(pGPKeyPair.getPublicKey(), pGPKeyPair2.getPublicKey()));
                    pGPSignatureSubpacketVector = ((PGPSignatureSubpacketGenerator)object).generate();
                }
                catch (IOException iOException) {
                    throw new PGPException(iOException.getMessage(), iOException);
                }
            } else if (!pGPSignatureSubpacketVector.hasSubpacket(32)) {
                throw new PGPException("signing subkey requires embedded PRIMARYKEY_BINDING signature");
            }
        }
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
        pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
        object2 = new ArrayList();
        object2.add(pGPSignatureGenerator.generateCertification(pGPKeyPair.getPublicKey(), pGPKeyPair2.getPublicKey()));
        object = new PGPPublicKey(pGPKeyPair2.getPublicKey(), null, (List)object2);
        ((PGPPublicKey)object).publicPk = new PublicSubkeyPacket(((PGPPublicKey)object).getAlgorithm(), ((PGPPublicKey)object).getCreationTime(), ((PGPPublicKey)object).publicPk.getKey());
        this.pub = object;
        this.secret = PGPSecretKey.buildSecretKeyPacket(false, pGPKeyPair2.getPrivateKey(), pGPKeyPair2.getPublicKey(), pBESecretKeyEncryptor, pGPDigestCalculator);
    }

    public PGPSecretKey(int n, PGPKeyPair pGPKeyPair, String string, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this(pGPKeyPair.getPrivateKey(), PGPSecretKey.certifiedPublicKey(n, pGPKeyPair, string, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, pGPContentSignerBuilder), pGPDigestCalculator, true, pBESecretKeyEncryptor);
    }

    private static PGPPublicKey certifiedPublicKey(int n, PGPKeyPair pGPKeyPair, String string, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder) throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        try {
            pGPSignatureGenerator = new PGPSignatureGenerator(pGPContentSignerBuilder);
        }
        catch (Exception exception) {
            throw new PGPException("creating signature generator: " + exception, exception);
        }
        pGPSignatureGenerator.init(n, pGPKeyPair.getPrivateKey());
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
        pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
        try {
            PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(string, pGPKeyPair.getPublicKey());
            return PGPPublicKey.addCertification(pGPKeyPair.getPublicKey(), string, pGPSignature);
        }
        catch (Exception exception) {
            throw new PGPException("exception doing certification: " + exception, exception);
        }
    }

    public boolean isSigningKey() {
        int n = this.pub.getAlgorithm();
        return n == 1 || n == 3 || n == 17 || n == 19 || n == 22 || n == 20;
    }

    public boolean isMasterKey() {
        return this.pub.isMasterKey();
    }

    public boolean isPrivateKeyEmpty() {
        byte[] byArray = this.secret.getSecretKeyData();
        return byArray == null || byArray.length < 1;
    }

    public int getKeyEncryptionAlgorithm() {
        return this.secret.getEncAlgorithm();
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public byte[] getFingerprint() {
        return this.pub.getFingerprint();
    }

    public int getS2KUsage() {
        return this.secret.getS2KUsage();
    }

    public S2K getS2K() {
        return this.secret.getS2K();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public Iterator getUserIDs() {
        return this.pub.getUserIDs();
    }

    public Iterator getUserAttributes() {
        return this.pub.getUserAttributes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] extractKeyData(PBESecretKeyDecryptor pBESecretKeyDecryptor) throws PGPException {
        byte[] byArray = this.secret.getSecretKeyData();
        byte[] byArray2 = null;
        if (this.secret.getEncAlgorithm() == 0) return byArray;
        try {
            int n;
            int n2;
            if (this.secret.getPublicKeyPacket().getVersion() == 4) {
                byte[] byArray3 = pBESecretKeyDecryptor.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K());
                byArray2 = pBESecretKeyDecryptor.recoverKeyData(this.secret.getEncAlgorithm(), byArray3, this.secret.getIV(), byArray, 0, byArray.length);
                boolean bl = this.secret.getS2KUsage() == 254;
                byte[] byArray4 = PGPSecretKey.checksum(bl ? pBESecretKeyDecryptor.getChecksumCalculator(2) : null, byArray2, bl ? byArray2.length - 20 : byArray2.length - 2);
                if (Arrays.constantTimeAreEqual((int)byArray4.length, (byte[])byArray4, (int)0, (byte[])byArray2, (int)(byArray2.length - byArray4.length))) return byArray2;
                throw new PGPException("checksum mismatch at in checksum of " + byArray4.length + " bytes");
            }
            byte[] byArray5 = pBESecretKeyDecryptor.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K());
            byArray2 = new byte[byArray.length];
            byte[] byArray6 = new byte[this.secret.getIV().length];
            System.arraycopy(this.secret.getIV(), 0, byArray6, 0, byArray6.length);
            int n3 = 0;
            for (n2 = 0; n2 != 4; ++n2) {
                n = (((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF) + 7) / 8;
                byArray2[n3] = byArray[n3];
                byArray2[n3 + 1] = byArray[n3 + 1];
                if (n > byArray.length - (n3 + 2)) {
                    throw new PGPException("out of range encLen found in encData");
                }
                byte[] byArray7 = pBESecretKeyDecryptor.recoverKeyData(this.secret.getEncAlgorithm(), byArray5, byArray6, byArray, n3 + 2, n);
                System.arraycopy(byArray7, 0, byArray2, n3 + 2, byArray7.length);
                n3 += 2 + n;
                if (n2 == 3) continue;
                System.arraycopy(byArray, n3 - byArray6.length, byArray6, 0, byArray6.length);
            }
            byArray2[n3] = byArray[n3];
            byArray2[n3 + 1] = byArray[n3 + 1];
            n2 = byArray[n3] << 8 & 0xFF00 | byArray[n3 + 1] & 0xFF;
            n = 0;
            for (int i = 0; i < byArray2.length - 2; ++i) {
                n += byArray2[i] & 0xFF;
            }
            if ((n &= 0xFFFF) == n2) return byArray2;
            throw new PGPException("checksum mismatch: passphrase wrong, expected " + Integer.toHexString(n2) + " found " + Integer.toHexString(n));
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception decrypting key", exception);
        }
    }

    public PGPKeyPair extractKeyPair(PBESecretKeyDecryptor pBESecretKeyDecryptor) throws PGPException {
        return new PGPKeyPair(this.getPublicKey(), this.extractPrivateKey(pBESecretKeyDecryptor));
    }

    public PGPPrivateKey extractPrivateKey(PBESecretKeyDecryptor pBESecretKeyDecryptor) throws PGPException {
        if (this.isPrivateKeyEmpty()) {
            return null;
        }
        PublicKeyPacket publicKeyPacket = this.secret.getPublicKeyPacket();
        try {
            byte[] byArray = this.extractKeyData(pBESecretKeyDecryptor);
            BCPGInputStream bCPGInputStream = new BCPGInputStream(new ByteArrayInputStream(byArray));
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSASecretBCPGKey rSASecretBCPGKey = new RSASecretBCPGKey(bCPGInputStream);
                    return new PGPPrivateKey(this.getKeyID(), publicKeyPacket, rSASecretBCPGKey);
                }
                case 17: {
                    DSASecretBCPGKey dSASecretBCPGKey = new DSASecretBCPGKey(bCPGInputStream);
                    return new PGPPrivateKey(this.getKeyID(), publicKeyPacket, dSASecretBCPGKey);
                }
                case 16: 
                case 20: {
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = new ElGamalSecretBCPGKey(bCPGInputStream);
                    return new PGPPrivateKey(this.getKeyID(), publicKeyPacket, elGamalSecretBCPGKey);
                }
                case 18: 
                case 19: {
                    ECSecretBCPGKey eCSecretBCPGKey = new ECSecretBCPGKey(bCPGInputStream);
                    return new PGPPrivateKey(this.getKeyID(), publicKeyPacket, eCSecretBCPGKey);
                }
                case 22: {
                    EdSecretBCPGKey edSecretBCPGKey = new EdSecretBCPGKey(bCPGInputStream);
                    return new PGPPrivateKey(this.getKeyID(), publicKeyPacket, edSecretBCPGKey);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    private static byte[] checksum(PGPDigestCalculator pGPDigestCalculator, byte[] byArray, int n) throws PGPException {
        if (pGPDigestCalculator != null) {
            OutputStream outputStream = pGPDigestCalculator.getOutputStream();
            try {
                outputStream.write(byArray, 0, n);
                outputStream.close();
            }
            catch (Exception exception) {
                throw new PGPException("checksum digest calculation failed: " + exception.getMessage(), exception);
            }
            return pGPDigestCalculator.getDigest();
        }
        int n2 = 0;
        for (int i = 0; i != n; ++i) {
            n2 += byArray[i] & 0xFF;
        }
        byte[] byArray2 = new byte[]{(byte)(n2 >> 8), (byte)n2};
        return byArray2;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = BCPGOutputStream.wrap(outputStream);
        bCPGOutputStream.writePacket(this.secret);
        if (this.pub.trustPk != null) {
            bCPGOutputStream.writePacket(this.pub.trustPk);
        }
        if (this.pub.subSigs == null) {
            int n;
            for (n = 0; n != this.pub.keySigs.size(); ++n) {
                ((PGPSignature)this.pub.keySigs.get(n)).encode(bCPGOutputStream);
            }
            for (n = 0; n != this.pub.ids.size(); ++n) {
                Object object;
                if (this.pub.ids.get(n) instanceof UserIDPacket) {
                    object = (UserIDPacket)this.pub.ids.get(n);
                    bCPGOutputStream.writePacket((ContainedPacket)object);
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.pub.ids.get(n);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                if (this.pub.idTrusts.get(n) != null) {
                    bCPGOutputStream.writePacket((TrustPacket)this.pub.idTrusts.get(n));
                }
                object = (List)this.pub.idSigs.get(n);
                for (int i = 0; i != object.size(); ++i) {
                    ((PGPSignature)object.get(i)).encode(bCPGOutputStream);
                }
            }
        } else {
            for (int i = 0; i != this.pub.subSigs.size(); ++i) {
                ((PGPSignature)this.pub.subSigs.get(i)).encode(bCPGOutputStream);
            }
        }
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey pGPSecretKey, PBESecretKeyDecryptor pBESecretKeyDecryptor, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        return PGPSecretKey.copyWithNewPassword(pGPSecretKey, pBESecretKeyDecryptor, pBESecretKeyEncryptor, null);
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey pGPSecretKey, PBESecretKeyDecryptor pBESecretKeyDecryptor, PBESecretKeyEncryptor pBESecretKeyEncryptor, PGPDigestCalculator pGPDigestCalculator) throws PGPException {
        Object object;
        byte[] byArray;
        if (pGPSecretKey.isPrivateKeyEmpty()) {
            throw new PGPException("no private key in this SecretKey - public key present only.");
        }
        byte[] byArray2 = pGPSecretKey.extractKeyData(pBESecretKeyDecryptor);
        int n = pGPSecretKey.secret.getS2KUsage();
        byte[] byArray3 = null;
        S2K s2K = null;
        int n2 = 0;
        if (pBESecretKeyEncryptor == null || pBESecretKeyEncryptor.getAlgorithm() == 0) {
            n = 0;
            if (pGPSecretKey.secret.getS2KUsage() == 254) {
                byArray = new byte[byArray2.length - 18];
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length - 2);
                object = PGPSecretKey.checksum(null, byArray, byArray.length - 2);
                byArray[byArray.length - 2] = object[0];
                byArray[byArray.length - 1] = object[1];
            } else {
                byArray = byArray2;
            }
        } else if (pGPSecretKey.secret.getPublicKeyPacket().getVersion() < 4) {
            if (n == 0) {
                n = 255;
            }
            object = pBESecretKeyEncryptor.getKey();
            byArray = new byte[byArray2.length];
            if (pBESecretKeyEncryptor.getHashAlgorithm() != 1) {
                throw new PGPException("MD5 Digest Calculator required for version 3 key encryptor.");
            }
            int n3 = 0;
            for (int i = 0; i != 4; ++i) {
                byte[] byArray4;
                int n4 = (((byArray2[n3] & 0xFF) << 8 | byArray2[n3 + 1] & 0xFF) + 7) / 8;
                byArray[n3] = byArray2[n3];
                byArray[n3 + 1] = byArray2[n3 + 1];
                if (n4 > byArray2.length - (n3 + 2)) {
                    throw new PGPException("out of range encLen found in rawKeyData");
                }
                if (i == 0) {
                    byArray4 = pBESecretKeyEncryptor.encryptKeyData((byte[])object, byArray2, n3 + 2, n4);
                    byArray3 = pBESecretKeyEncryptor.getCipherIV();
                } else {
                    byte[] byArray5 = new byte[byArray3.length];
                    System.arraycopy(byArray, n3 - byArray3.length, byArray5, 0, byArray5.length);
                    byArray4 = pBESecretKeyEncryptor.encryptKeyData((byte[])object, byArray5, byArray2, n3 + 2, n4);
                }
                System.arraycopy(byArray4, 0, byArray, n3 + 2, byArray4.length);
                n3 += 2 + n4;
            }
            byArray[n3] = byArray2[n3];
            byArray[n3 + 1] = byArray2[n3 + 1];
            s2K = pBESecretKeyEncryptor.getS2K();
            n2 = pBESecretKeyEncryptor.getAlgorithm();
        } else {
            if (n == 0) {
                if (pGPDigestCalculator != null) {
                    if (pGPDigestCalculator.getAlgorithm() != 2) {
                        throw new IllegalArgumentException("only SHA-1 supported for checksums");
                    }
                    n = 254;
                    object = PGPSecretKey.checksum(pGPDigestCalculator, byArray2, byArray2.length);
                    byArray2 = Arrays.concatenate((byte[])byArray2, (byte[])object);
                    byArray = pBESecretKeyEncryptor.encryptKeyData(byArray2, 0, byArray2.length);
                } else {
                    n = 255;
                    byArray = pBESecretKeyEncryptor.encryptKeyData(byArray2, 0, byArray2.length);
                }
            } else {
                byArray = pBESecretKeyEncryptor.encryptKeyData(byArray2, 0, byArray2.length);
            }
            byArray3 = pBESecretKeyEncryptor.getCipherIV();
            s2K = pBESecretKeyEncryptor.getS2K();
            n2 = pBESecretKeyEncryptor.getAlgorithm();
        }
        object = pGPSecretKey.secret instanceof SecretSubkeyPacket ? (Object)new SecretSubkeyPacket(pGPSecretKey.secret.getPublicKeyPacket(), n2, n, s2K, byArray3, byArray) : (Object)new SecretKeyPacket(pGPSecretKey.secret.getPublicKeyPacket(), n2, n, s2K, byArray3, byArray);
        return new PGPSecretKey((SecretKeyPacket)object, pGPSecretKey.pub);
    }

    public static PGPSecretKey replacePublicKey(PGPSecretKey pGPSecretKey, PGPPublicKey pGPPublicKey) {
        if (pGPPublicKey.getKeyID() != pGPSecretKey.getKeyID()) {
            throw new IllegalArgumentException("keyIDs do not match");
        }
        return new PGPSecretKey(pGPSecretKey.secret, pGPPublicKey);
    }

    public static PGPSecretKey parseSecretKeyFromSExpr(InputStream inputStream, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, PGPPublicKey pGPPublicKey) throws IOException, PGPException {
        return new SExprParser(null).parseSecretKey(inputStream, pBEProtectionRemoverFactory, pGPPublicKey);
    }

    public static PGPSecretKey parseSecretKeyFromSExpr(InputStream inputStream, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        return new SExprParser(null).parseSecretKey(inputStream, pBEProtectionRemoverFactory, keyFingerPrintCalculator);
    }
}

