/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Longs;

public class PGPPublicKeyRing
extends PGPKeyRing
implements Iterable {
    private static final Logger LOG = Logger.getLogger(PGPPublicKeyRing.class.getName());
    List keys;

    public PGPPublicKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    private static List checkKeys(List list) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(list.size());
        for (int i = 0; i != list.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)list.get(i);
            if (i == 0) {
                if (!pGPPublicKey.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (pGPPublicKey.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            arrayList.add(pGPPublicKey);
        }
        return arrayList;
    }

    public PGPPublicKeyRing(List list) {
        this.keys = PGPPublicKeyRing.checkKeys(list);
    }

    public PGPPublicKeyRing(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this.keys = new ArrayList();
        BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream);
        int n = bCPGInputStream.skipMarkerAndPaddingPackets();
        if (n != 6 && n != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(n));
        }
        PublicKeyPacket publicKeyPacket = PGPPublicKeyRing.readPublicKeyPacket(bCPGInputStream);
        TrustPacket trustPacket = PGPPublicKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPPublicKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        PGPPublicKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        try {
            this.keys.add(new PGPPublicKey(publicKeyPacket, trustPacket, list, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator));
            while (bCPGInputStream.nextPacketTag() == 14) {
                PGPPublicKey pGPPublicKey = PGPPublicKeyRing.readSubkey(bCPGInputStream, keyFingerPrintCalculator);
                if (pGPPublicKey == null) continue;
                this.keys.add(pGPPublicKey);
            }
        }
        catch (PGPException pGPException) {
            throw new IOException("processing exception: " + pGPException.toString());
        }
    }

    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    public PGPPublicKey getPublicKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(byte[] byArray) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (!Arrays.areEqual((byte[])byArray, (byte[])pGPPublicKey.getFingerprint())) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public Iterator getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            Iterator iterator = pGPPublicKey.getSignaturesForKeyID(l);
            if (!iterator.hasNext()) continue;
            arrayList.add(pGPPublicKey);
        }
        return arrayList.iterator();
    }

    public Iterator getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public Iterator iterator() {
        return this.getPublicKeys();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            pGPPublicKey.encode(outputStream, bl);
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(pGPPublicKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(i);
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                bl = true;
                arrayList.set(i, pGPPublicKey);
            }
            if (!pGPPublicKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPPublicKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPPublicKey);
            } else {
                arrayList.add(pGPPublicKey);
            }
        }
        return new PGPPublicKeyRing(arrayList);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        int n = pGPPublicKeyRing.keys.size();
        long l = pGPPublicKey.getKeyID();
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)pGPPublicKeyRing.keys.get(i);
            if (pGPPublicKey2.getKeyID() == l) {
                bl = true;
                continue;
            }
            arrayList.add(pGPPublicKey2);
        }
        if (!bl) {
            return null;
        }
        return new PGPPublicKeyRing(arrayList);
    }

    static PublicKeyPacket readPublicKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof PublicKeyPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (PublicKeyPacket)packet;
    }

    static PGPPublicKey readSubkey(BCPGInputStream bCPGInputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        try {
            PublicKeyPacket publicKeyPacket = PGPPublicKeyRing.readPublicKeyPacket(bCPGInputStream);
            TrustPacket trustPacket = PGPPublicKeyRing.readOptionalTrustPacket(bCPGInputStream);
            List list = PGPPublicKeyRing.readSignaturesAndTrust(bCPGInputStream);
            return new PGPPublicKey(publicKeyPacket, trustPacket, list, keyFingerPrintCalculator);
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (ArmoredInputException armoredInputException) {
            throw armoredInputException;
        }
        catch (IOException iOException) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("skipping unknown subkey: " + iOException.getMessage());
            }
            return null;
        }
    }

    public static PGPPublicKeyRing join(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKeyRing pGPPublicKeyRing2) throws PGPException {
        return PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2, false, false);
    }

    public static PGPPublicKeyRing join(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKeyRing pGPPublicKeyRing2, boolean bl, boolean bl2) throws PGPException {
        Object object;
        Iterator iterator;
        if (!Arrays.areEqual((byte[])pGPPublicKeyRing.getPublicKey().getFingerprint(), (byte[])pGPPublicKeyRing2.getPublicKey().getFingerprint())) {
            throw new IllegalArgumentException("Cannot merge certificates with differing primary keys.");
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        Object object2 = pGPPublicKeyRing2.iterator();
        while (object2.hasNext()) {
            iterator = (PGPPublicKey)object2.next();
            hashSet.add(Longs.valueOf((long)((PGPPublicKey)((Object)iterator)).getKeyID()));
        }
        object2 = new ArrayList();
        iterator = pGPPublicKeyRing.iterator();
        while (iterator.hasNext()) {
            object = (PGPPublicKey)iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing2.getPublicKey(((PGPPublicKey)object).getKeyID());
            if (pGPPublicKey != null) {
                object2.add(PGPPublicKey.join((PGPPublicKey)object, pGPPublicKey, bl, bl2));
                hashSet.remove(Longs.valueOf((long)((PGPPublicKey)object).getKeyID()));
                continue;
            }
            object2.add(object);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Long)iterator.next();
            object2.add(pGPPublicKeyRing2.getPublicKey((Long)object));
        }
        return new PGPPublicKeyRing((List)object2);
    }
}

