/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGHeaderObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean useOldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;
    private boolean forceSessionKey = false;

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder) {
        this(pGPDataEncryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder, boolean bl) {
        this.dataEncryptorBuilder = pGPDataEncryptorBuilder;
        this.useOldFormat = bl;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
    }

    public void setForceSessionKey(boolean bl) {
        this.forceSessionKey = bl;
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator) {
        this.methods.add(pGPKeyEncryptionMethodGenerator);
    }

    private void addCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        byArray[byArray.length - 2] = (byte)(n >> 8);
        byArray[byArray.length - 1] = (byte)n;
    }

    private byte[] createSessionInfo(int n, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 3];
        byArray2[0] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.addCheckSum(byArray2);
        return byArray2;
    }

    private OutputStream open(OutputStream outputStream, long l, byte[] byArray) throws IOException, PGPException, IllegalStateException {
        Object object;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        byte[] byArray2 = null;
        this.pOut = new BCPGOutputStream(outputStream);
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        if (this.methods.size() == 1) {
            boolean bl = this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator;
            if (bl && !this.forceSessionKey) {
                PBEKeyEncryptionMethodGenerator pBEKeyEncryptionMethodGenerator = (PBEKeyEncryptionMethodGenerator)this.methods.get(0);
                byArray2 = pBEKeyEncryptionMethodGenerator.getKey(this.defAlgorithm);
                this.pOut.writePacket(pBEKeyEncryptionMethodGenerator.generate(this.defAlgorithm, null));
            } else {
                byArray2 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
                byte[] byArray3 = this.createSessionInfo(this.defAlgorithm, byArray2);
                object = (PGPKeyEncryptionMethodGenerator)this.methods.get(0);
                this.writeWrappedSessionKey((PGPKeyEncryptionMethodGenerator)object, byArray3);
            }
        } else {
            byArray2 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            byte[] byArray4 = this.createSessionInfo(this.defAlgorithm, byArray2);
            for (int i = 0; i != this.methods.size(); ++i) {
                object = (PGPKeyEncryptionMethodGenerator)this.methods.get(i);
                this.writeWrappedSessionKey((PGPKeyEncryptionMethodGenerator)object, byArray4);
            }
        }
        try {
            InputStreamPacket inputStreamPacket;
            PGPDataEncryptor pGPDataEncryptor = this.dataEncryptorBuilder.build(byArray2);
            this.digestCalc = pGPDataEncryptor.getIntegrityCalculator();
            if (pGPDataEncryptor instanceof PGPAEADDataEncryptor) {
                PGPAEADDataEncryptor pGPAEADDataEncryptor = (PGPAEADDataEncryptor)pGPDataEncryptor;
                object = pGPAEADDataEncryptor.getIV();
                AEADEncDataPacket aEADEncDataPacket = new AEADEncDataPacket(this.dataEncryptorBuilder.getAlgorithm(), pGPAEADDataEncryptor.getAEADAlgorithm(), pGPAEADDataEncryptor.getChunkSize(), (byte[])object);
                if (byArray != null) {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)aEADEncDataPacket, byArray);
                } else {
                    long l2 = 1L << pGPAEADDataEncryptor.getChunkSize() + 6;
                    long l3 = (l + l2 - 1L) / l2 * 16L + 16L;
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)aEADEncDataPacket, l + l3 + 4L + (long)((Object)object).length);
                }
                this.genOut = this.cOut = pGPDataEncryptor.getOutputStream(this.pOut);
                return new WrappedGeneratorStream(this.genOut, this);
            }
            if (this.digestCalc != null) {
                inputStreamPacket = new SymmetricEncIntegrityPacket();
                if (this.useOldFormat) {
                    throw new PGPException("symmetric-enc-integrity packets not supported in old PGP format");
                }
            } else {
                inputStreamPacket = new SymmetricEncDataPacket();
            }
            if (byArray == null) {
                long l4 = this.digestCalc == null ? l + (long)pGPDataEncryptor.getBlockSize() + 2L : l + (long)pGPDataEncryptor.getBlockSize() + 2L + 1L + 22L;
                this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), l4, this.useOldFormat);
            } else {
                this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), byArray);
            }
            this.genOut = this.cOut = pGPDataEncryptor.getOutputStream(this.pOut);
            if (this.digestCalc != null) {
                this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
            }
            byte[] byArray5 = new byte[pGPDataEncryptor.getBlockSize() + 2];
            this.rand.nextBytes(byArray5);
            byArray5[byArray5.length - 1] = byArray5[byArray5.length - 3];
            byArray5[byArray5.length - 2] = byArray5[byArray5.length - 4];
            this.genOut.write(byArray5);
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    private void writeWrappedSessionKey(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator, byte[] byArray) throws IOException, PGPException {
        if (pGPKeyEncryptionMethodGenerator instanceof PBEKeyEncryptionMethodGenerator) {
            this.pOut.writePacket(pGPKeyEncryptionMethodGenerator.generate(((PBEKeyEncryptionMethodGenerator)pGPKeyEncryptionMethodGenerator).getSessionKeyWrapperAlgorithm(this.defAlgorithm), byArray));
        } else {
            this.pOut.writePacket(pGPKeyEncryptionMethodGenerator.generate(this.defAlgorithm, byArray));
        }
    }

    public OutputStream open(OutputStream outputStream, long l) throws IOException, PGPException {
        return this.open(outputStream, l, null);
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        return this.open(outputStream, 0L, byArray);
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(this.genOut, 19, 20L);
                bCPGOutputStream.flush();
                byte[] byArray = this.digestCalc.getDigest();
                this.cOut.write(byArray);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    private static class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, byte[] byArray) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), byArray);
            bCPGHeaderObject.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, long l, boolean bl) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), l, bl);
            bCPGHeaderObject.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, long l) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), l);
            bCPGHeaderObject.encode(this);
        }

        public void close() throws IOException {
            this.finish();
        }
    }
}

