/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;

public class OpenPGPKeyReader {
    private final OpenPGPImplementation implementation;
    private final OpenPGPPolicy policy;

    public OpenPGPKeyReader() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPKeyReader(OpenPGPImplementation implementation) {
        this(implementation, implementation.policy());
    }

    public OpenPGPKeyReader(OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        this.implementation = implementation;
        this.policy = policy;
    }

    public OpenPGPCertificate parseCertificate(String armored) throws IOException {
        OpenPGPCertificate certificate = this.parseKeyOrCertificate(armored);
        if (certificate instanceof OpenPGPKey) {
            throw new IOException("Could not parse OpenPGPCertificate: Is OpenPGPKey.");
        }
        return certificate;
    }

    public OpenPGPCertificate parseCertificate(InputStream inputStream) throws IOException {
        OpenPGPCertificate certificate = this.parseKeyOrCertificate(inputStream);
        if (certificate instanceof OpenPGPKey) {
            throw new IOException("Could not parse OpenPGPCertificate: Is OpenPGPKey.");
        }
        return certificate;
    }

    public OpenPGPCertificate parseCertificate(byte[] bytes) throws IOException {
        OpenPGPCertificate certificate = this.parseKeyOrCertificate(bytes);
        if (certificate instanceof OpenPGPKey) {
            throw new IOException("Could not parse OpenPGPCertificate: Is OpenPGPKey.");
        }
        return certificate;
    }

    @Deprecated
    public OpenPGPCertificate parseCertificateOrKey(String armored) throws IOException {
        return this.parseKeyOrCertificate(armored);
    }

    @Deprecated
    public OpenPGPCertificate parseCertificateOrKey(InputStream inputStream) throws IOException {
        return this.parseKeyOrCertificate(inputStream);
    }

    @Deprecated
    public OpenPGPCertificate parseCertificateOrKey(byte[] bytes) throws IOException {
        return this.parseKeyOrCertificate(bytes);
    }

    public OpenPGPCertificate parseKeyOrCertificate(String armored) throws IOException {
        return this.parseKeyOrCertificate(Strings.toUTF8ByteArray((String)armored));
    }

    public OpenPGPCertificate parseKeyOrCertificate(InputStream inputStream) throws IOException {
        return this.parseKeyOrCertificate(Streams.readAll((InputStream)inputStream));
    }

    public OpenPGPCertificate parseKeyOrCertificate(byte[] bytes) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        InputStream decoderStream = PGPUtil.getDecoderStream(bIn);
        BCPGInputStream pIn = BCPGInputStream.wrap(decoderStream);
        PGPObjectFactory objectFactory = this.implementation.pgpObjectFactory(pIn);
        Object object = objectFactory.nextObject();
        while (object instanceof PGPMarker) {
            object = objectFactory.nextObject();
        }
        if (object instanceof PGPSecretKeyRing) {
            return new OpenPGPKey((PGPSecretKeyRing)object, this.implementation, this.policy);
        }
        if (object instanceof PGPPublicKeyRing) {
            return new OpenPGPCertificate((PGPPublicKeyRing)object, this.implementation, this.policy);
        }
        throw new IOException("Neither a certificate, nor secret key.");
    }

    public OpenPGPKey parseKey(String armored) throws IOException {
        return this.parseKey(Strings.toUTF8ByteArray((String)armored));
    }

    public OpenPGPKey parseKey(InputStream inputStream) throws IOException {
        return this.parseKey(Streams.readAll((InputStream)inputStream));
    }

    public OpenPGPKey parseKey(byte[] bytes) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        InputStream decoderStream = PGPUtil.getDecoderStream(bIn);
        BCPGInputStream pIn = BCPGInputStream.wrap(decoderStream);
        PGPObjectFactory objectFactory = this.implementation.pgpObjectFactory(pIn);
        Object object = objectFactory.nextObject();
        while (object instanceof PGPMarker) {
            object = objectFactory.nextObject();
        }
        if (!(object instanceof PGPSecretKeyRing)) {
            throw new IOException("Not a secret key.");
        }
        PGPSecretKeyRing keyRing = (PGPSecretKeyRing)object;
        return new OpenPGPKey(keyRing, this.implementation, this.policy);
    }

    public List<OpenPGPCertificate> parseKeysOrCertificates(String armored) throws IOException {
        return this.parseKeysOrCertificates(Strings.toUTF8ByteArray((String)armored));
    }

    public List<OpenPGPCertificate> parseKeysOrCertificates(InputStream inputStream) throws IOException {
        return this.parseKeysOrCertificates(Streams.readAll((InputStream)inputStream));
    }

    public List<OpenPGPCertificate> parseKeysOrCertificates(byte[] bytes) throws IOException {
        Object object;
        ArrayList<OpenPGPCertificate> certsOrKeys = new ArrayList<OpenPGPCertificate>();
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        InputStream decoderStream = PGPUtil.getDecoderStream(bIn);
        decoderStream = PGPUtil.getDecoderStream(decoderStream);
        PGPObjectFactory objectFactory = this.implementation.pgpObjectFactory(decoderStream);
        while ((object = objectFactory.nextObject()) != null) {
            if (object instanceof PGPMarker) continue;
            if (object instanceof PGPSecretKeyRing) {
                certsOrKeys.add(new OpenPGPKey((PGPSecretKeyRing)object, this.implementation, this.policy));
                continue;
            }
            if (object instanceof PGPPublicKeyRing) {
                certsOrKeys.add(new OpenPGPCertificate((PGPPublicKeyRing)object, this.implementation, this.policy));
                continue;
            }
            throw new IOException("Neither a certificate, nor secret key.");
        }
        return certsOrKeys;
    }

    public List<OpenPGPCertificate> parseCertificates(String armored) throws IOException {
        return this.parseCertificates(Strings.toUTF8ByteArray((String)armored));
    }

    public List<OpenPGPCertificate> parseCertificates(InputStream inputStream) throws IOException {
        return this.parseCertificates(Streams.readAll((InputStream)inputStream));
    }

    public List<OpenPGPCertificate> parseCertificates(byte[] bytes) throws IOException {
        Object object;
        ArrayList<OpenPGPCertificate> certs = new ArrayList<OpenPGPCertificate>();
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        InputStream decoderStream = PGPUtil.getDecoderStream(bIn);
        decoderStream = PGPUtil.getDecoderStream(decoderStream);
        PGPObjectFactory objectFactory = this.implementation.pgpObjectFactory(decoderStream);
        while ((object = objectFactory.nextObject()) != null) {
            if (object instanceof PGPMarker) continue;
            if (object instanceof PGPPublicKeyRing) {
                certs.add(new OpenPGPCertificate((PGPPublicKeyRing)object, this.implementation, this.policy));
                continue;
            }
            throw new IOException("Encountered unexpected packet: " + object.getClass().getName());
        }
        return certs;
    }

    public List<OpenPGPKey> parseKeys(String armored) throws IOException {
        return this.parseKeys(Strings.toUTF8ByteArray((String)armored));
    }

    public List<OpenPGPKey> parseKeys(InputStream inputStream) throws IOException {
        return this.parseKeys(Streams.readAll((InputStream)inputStream));
    }

    public List<OpenPGPKey> parseKeys(byte[] bytes) throws IOException {
        Object object;
        ArrayList<OpenPGPKey> keys = new ArrayList<OpenPGPKey>();
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        InputStream decoderStream = PGPUtil.getDecoderStream(bIn);
        decoderStream = PGPUtil.getDecoderStream(decoderStream);
        PGPObjectFactory objectFactory = this.implementation.pgpObjectFactory(decoderStream);
        while ((object = objectFactory.nextObject()) != null) {
            if (object instanceof PGPMarker) continue;
            if (object instanceof PGPSecretKeyRing) {
                keys.add(new OpenPGPKey((PGPSecretKeyRing)object, this.implementation, this.policy));
                continue;
            }
            throw new IOException("Encountered unexpected packet: " + object.getClass().getName());
        }
        return keys;
    }
}

