/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Date;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.AbstractOpenPGPKeySignatureGenerator;
import org.bouncycastle.openpgp.api.KeyPairGeneratorCallback;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.SignatureParameters;
import org.bouncycastle.openpgp.api.Utils;
import org.bouncycastle.openpgp.api.exception.OpenPGPKeyException;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;

public class OpenPGPKeyEditor
extends AbstractOpenPGPKeySignatureGenerator {
    private final OpenPGPImplementation implementation;
    private final OpenPGPPolicy policy;
    private OpenPGPKey key;
    private final OpenPGPKey.OpenPGPPrivateKey primaryKey;

    public OpenPGPKeyEditor(OpenPGPKey key, KeyPassphraseProvider passphraseProvider) throws PGPException {
        this(key, passphraseProvider, key.implementation);
    }

    public OpenPGPKeyEditor(OpenPGPKey key, KeyPassphraseProvider passphraseProvider, OpenPGPImplementation implementation) throws PGPException {
        this(key, passphraseProvider, implementation, implementation.policy());
    }

    public OpenPGPKeyEditor(OpenPGPKey key, KeyPassphraseProvider passphraseProvider, OpenPGPImplementation implementation, OpenPGPPolicy policy) throws PGPException {
        this.key = key;
        this.primaryKey = key.getPrimarySecretKey().unlock(passphraseProvider);
        this.implementation = implementation;
        this.policy = policy;
    }

    public OpenPGPKeyEditor addDirectKeySignature(SignatureParameters.Callback signatureCallback) throws PGPException {
        SignatureParameters parameters = Utils.applySignatureParameters(signatureCallback, SignatureParameters.directKeySignature(this.policy));
        if (parameters != null) {
            PGPPublicKey publicPrimaryKey = this.key.getPrimaryKey().getPGPPublicKey();
            PGPSignatureGenerator dkSigGen = Utils.getPgpSignatureGenerator(this.implementation, publicPrimaryKey, this.primaryKey.getKeyPair().getPrivateKey(), parameters, parameters.getSignatureCreationTime(), null);
            PGPPublicKey pubKey = Utils.injectCertification(publicPrimaryKey, dkSigGen);
            this.key = this.generateOpenPGPKey(pubKey);
        }
        return this;
    }

    public OpenPGPKeyEditor addUserId(String userId) throws PGPException {
        return this.addUserId(userId, null);
    }

    public OpenPGPKeyEditor addUserId(String userId, SignatureParameters.Callback signatureCallback) throws PGPException {
        if (userId == null || userId.trim().length() == 0) {
            throw new IllegalArgumentException("User-ID cannot be null or empty.");
        }
        SignatureParameters parameters = Utils.applySignatureParameters(signatureCallback, SignatureParameters.certification(this.policy));
        if (parameters != null) {
            PGPPublicKey publicPrimaryKey = this.key.getPrimaryKey().getPGPPublicKey();
            PGPSignatureGenerator uidSigGen = Utils.getPgpSignatureGenerator(this.implementation, publicPrimaryKey, this.primaryKey.getKeyPair().getPrivateKey(), parameters, parameters.getSignatureCreationTime(), null);
            this.key = this.generateOpenPGPKey(Utils.injectCertification(userId, publicPrimaryKey, uidSigGen));
        }
        return this;
    }

    public OpenPGPKeyEditor revokeIdentity(OpenPGPCertificate.OpenPGPIdentityComponent identity) throws PGPException {
        return this.revokeIdentity(identity, null);
    }

    public OpenPGPKeyEditor revokeIdentity(OpenPGPCertificate.OpenPGPIdentityComponent identity, SignatureParameters.Callback signatureCallback) throws PGPException {
        if (!this.key.getComponents().contains(identity)) {
            throw new IllegalArgumentException("UserID or UserAttribute is not part of the certificate.");
        }
        SignatureParameters parameters = Utils.applySignatureParameters(signatureCallback, SignatureParameters.certificationRevocation(this.policy));
        if (parameters != null) {
            PGPPublicKey pubKey;
            PGPPublicKey publicPrimaryKey = this.key.getPrimaryKey().getPGPPublicKey();
            PGPSignatureGenerator idSigGen = Utils.getPgpSignatureGenerator(this.implementation, publicPrimaryKey, this.primaryKey.getKeyPair().getPrivateKey(), parameters, parameters.getSignatureCreationTime(), null);
            if (identity instanceof OpenPGPCertificate.OpenPGPUserId) {
                OpenPGPCertificate.OpenPGPUserId userId = (OpenPGPCertificate.OpenPGPUserId)identity;
                pubKey = Utils.injectCertification(userId.getUserId(), publicPrimaryKey, idSigGen);
            } else {
                OpenPGPCertificate.OpenPGPUserAttribute userAttribute = (OpenPGPCertificate.OpenPGPUserAttribute)identity;
                PGPSignature uattrSig = idSigGen.generateCertification(userAttribute.getUserAttribute(), publicPrimaryKey);
                pubKey = PGPPublicKey.addCertification(publicPrimaryKey, userAttribute.getUserAttribute(), uattrSig);
            }
            this.key = this.generateOpenPGPKey(pubKey);
        }
        return this;
    }

    public OpenPGPKeyEditor addEncryptionSubkey() throws PGPException {
        return this.addEncryptionSubkey(KeyPairGeneratorCallback.Util.encryptionKey());
    }

    public OpenPGPKeyEditor addEncryptionSubkey(KeyPairGeneratorCallback keyGenCallback) throws PGPException {
        return this.addEncryptionSubkey(keyGenCallback, this.key.getPrimaryKey().getVersion(), new Date());
    }

    public OpenPGPKeyEditor addEncryptionSubkey(KeyPairGeneratorCallback keyGenCallback, int version, Date creationTime) throws PGPException {
        PGPKeyPairGenerator kpGen = this.implementation.pgpKeyPairGeneratorProvider().get(version, creationTime);
        return this.addEncryptionSubkey(keyGenCallback.generateFrom(kpGen), null);
    }

    public OpenPGPKeyEditor addEncryptionSubkey(PGPKeyPair encryptionSubkey, SignatureParameters.Callback bindingSigCallback) throws PGPException {
        if (!encryptionSubkey.getPublicKey().isEncryptionKey()) {
            throw new PGPKeyValidationException("Provided subkey is not encryption-capable.");
        }
        this.updateKey(encryptionSubkey, bindingSigCallback, this.key.getPrimaryKey().getPGPPublicKey(), new Utils.HashedSubpacketsOperation(){

            @Override
            public void operate(PGPSignatureSubpacketGenerator hashedSubpackets) throws PGPException {
                hashedSubpackets.setKeyFlags(12);
            }
        });
        return this;
    }

    public OpenPGPKeyEditor addSigningSubkey() throws PGPException {
        return this.addSigningSubkey(KeyPairGeneratorCallback.Util.signingKey());
    }

    public OpenPGPKeyEditor addSigningSubkey(KeyPairGeneratorCallback keyGenCallback) throws PGPException {
        return this.addSigningSubkey(keyGenCallback, this.key.getPrimaryKey().getVersion(), new Date());
    }

    public OpenPGPKeyEditor addSigningSubkey(KeyPairGeneratorCallback keyGenCallback, int version, Date creationTime) throws PGPException {
        PGPKeyPairGenerator kpGen = this.implementation.pgpKeyPairGeneratorProvider().get(version, creationTime);
        return this.addSigningSubkey(keyGenCallback.generateFrom(kpGen), null, null);
    }

    public OpenPGPKeyEditor addSigningSubkey(PGPKeyPair signingSubkey, SignatureParameters.Callback bindingSigCallback, SignatureParameters.Callback backSigCallback) throws PGPException {
        if (!PublicKeyUtils.isSigningAlgorithm(signingSubkey.getPublicKey().getAlgorithm())) {
            throw new PGPKeyValidationException("Provided subkey is not signing-capable.");
        }
        SignatureParameters backSigParameters = Utils.applySignatureParameters(backSigCallback, SignatureParameters.primaryKeyBinding(this.policy));
        PGPPublicKey publicPrimaryKey = this.key.getPrimaryKey().getPGPPublicKey();
        final PGPSignature backSig = Utils.getBackSignature(signingSubkey, backSigParameters, publicPrimaryKey, this.implementation, null);
        this.updateKey(signingSubkey, bindingSigCallback, publicPrimaryKey, new Utils.HashedSubpacketsOperation(){
            final /* synthetic */ OpenPGPKeyEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void operate(PGPSignatureSubpacketGenerator hashedSubpackets) throws PGPException {
                hashedSubpackets.setKeyFlags(2);
                Utils.addEmbeddedSiganture(backSig, hashedSubpackets);
            }
        });
        return this;
    }

    public OpenPGPKeyEditor addSubkey(PGPKeyPair subkey, SignatureParameters.Callback bindingSigCallback, SignatureParameters.Callback backSigCallback) throws PGPException {
        if (PublicKeyUtils.isSigningAlgorithm(subkey.getPublicKey().getAlgorithm()) && backSigCallback != null) {
            throw new PGPKeyValidationException("Provided subkey is not signing-capable, so we cannot create a back-signature.");
        }
        PGPPublicKey publicSubKey = subkey.getPublicKey();
        SignatureParameters backSigParameters = Utils.applySignatureParameters(backSigCallback, SignatureParameters.primaryKeyBinding(this.policy));
        PGPPublicKey publicPrimaryKey = this.key.getPrimaryKey().getPGPPublicKey();
        final PGPSignature backSig = Utils.getBackSignature(subkey, backSigParameters, publicPrimaryKey, this.implementation, null);
        SignatureParameters parameters = Utils.applySignatureParameters(bindingSigCallback, SignatureParameters.subkeyBinding(this.policy));
        if (parameters != null) {
            PGPSignatureGenerator subKeySigGen = Utils.getPgpSignatureGenerator(this.implementation, publicPrimaryKey, this.primaryKey.getKeyPair().getPrivateKey(), parameters, parameters.getSignatureCreationTime(), new Utils.HashedSubpacketsOperation(){
                final /* synthetic */ OpenPGPKeyEditor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void operate(PGPSignatureSubpacketGenerator hashedSubpackets) throws PGPException {
                    Utils.addEmbeddedSiganture(backSig, hashedSubpackets);
                }
            });
            publicSubKey = Utils.injectCertification(publicSubKey, subKeySigGen, publicPrimaryKey);
        }
        this.key = this.generateOpenPGPKey(subkey, publicSubKey);
        return this;
    }

    public OpenPGPKeyEditor revokeComponentKey(OpenPGPCertificate.OpenPGPComponentKey componentKey) throws PGPException {
        return this.revokeComponentKey(componentKey, null);
    }

    public OpenPGPKeyEditor revokeComponentKey(OpenPGPCertificate.OpenPGPComponentKey componentKey, SignatureParameters.Callback revocationSignatureCallback) throws PGPException {
        boolean contained;
        boolean bl = contained = this.key.getKey(componentKey.getKeyIdentifier()) != null;
        if (!contained) {
            throw new IllegalArgumentException("Provided component key is not part of the OpenPGP key.");
        }
        boolean isSubkeyRevocation = !componentKey.getKeyIdentifier().equals(this.key.getKeyIdentifier());
        SignatureParameters parameters = isSubkeyRevocation ? SignatureParameters.subkeyRevocation(this.policy) : SignatureParameters.keyRevocation(this.policy);
        parameters = Utils.applySignatureParameters(revocationSignatureCallback, parameters);
        PGPPublicKey publicPrimaryKey = this.key.getPrimaryKey().getPGPPublicKey();
        PGPSignatureGenerator revGen = Utils.getPgpSignatureGenerator(this.implementation, publicPrimaryKey, this.primaryKey.getKeyPair().getPrivateKey(), parameters, parameters.getSignatureCreationTime(), null);
        publicPrimaryKey = isSubkeyRevocation ? Utils.injectCertification(componentKey.getPGPPublicKey(), revGen, publicPrimaryKey) : Utils.injectCertification(publicPrimaryKey, revGen);
        this.key = this.generateOpenPGPKey(publicPrimaryKey);
        return this;
    }

    public OpenPGPKeyEditor revokeKey() throws PGPException {
        return this.revokeKey(null);
    }

    public OpenPGPKeyEditor revokeKey(SignatureParameters.Callback revocationSignatureCallback) throws PGPException {
        return this.revokeComponentKey(this.key.getPrimaryKey(), revocationSignatureCallback);
    }

    public OpenPGPKeyEditor changePassphrase(KeyIdentifier componentKeyIdentifier, char[] oldPassphrase, char[] newPassphrase, boolean useAEAD) throws OpenPGPKeyException, PGPException {
        OpenPGPKey.OpenPGPSecretKey secretKey = this.key.getSecretKey(componentKeyIdentifier);
        if (secretKey == null) {
            throw new OpenPGPKeyException(this.key, "Secret component key " + componentKeyIdentifier + " is missing from the key.");
        }
        OpenPGPKey.OpenPGPPrivateKey privateKey = secretKey.unlock(oldPassphrase);
        secretKey = privateKey.changePassphrase(newPassphrase, this.implementation, useAEAD);
        this.key.replaceSecretKey(secretKey);
        return this;
    }

    public OpenPGPKey done() {
        return this.key;
    }

    private OpenPGPKey generateOpenPGPKey(PGPPublicKey publicPrimaryKey) {
        PGPPublicKeyRing publicKeyRing = PGPPublicKeyRing.insertPublicKey(this.key.getPGPPublicKeyRing(), publicPrimaryKey);
        PGPSecretKeyRing secretKeyRing = PGPSecretKeyRing.replacePublicKeys(this.key.getPGPKeyRing(), publicKeyRing);
        return new OpenPGPKey(secretKeyRing, this.implementation, this.policy);
    }

    private OpenPGPKey generateOpenPGPKey(PGPKeyPair subkey, PGPPublicKey publicSubKey) throws PGPException {
        PGPSecretKey secretSubkey = new PGPSecretKey(subkey.getPrivateKey(), publicSubKey, this.implementation.pgpDigestCalculatorProvider().get(2), false, null);
        PGPSecretKeyRing secretKeyRing = PGPSecretKeyRing.insertSecretKey(this.key.getPGPKeyRing(), secretSubkey);
        return new OpenPGPKey(secretKeyRing, this.implementation, this.policy);
    }

    private void updateKey(PGPKeyPair subkey, SignatureParameters.Callback bindingSigCallback, PGPPublicKey publicPrimaryKey, Utils.HashedSubpacketsOperation operation) throws PGPException {
        SignatureParameters parameters = Utils.applySignatureParameters(bindingSigCallback, SignatureParameters.subkeyBinding(this.policy));
        if (parameters != null) {
            PGPSignatureGenerator subKeySigGen = Utils.getPgpSignatureGenerator(this.implementation, publicPrimaryKey, this.primaryKey.getKeyPair().getPrivateKey(), parameters, parameters.getSignatureCreationTime(), operation);
            PGPPublicKey publicSubKey = Utils.injectCertification(subkey.getPublicKey(), subKeySigGen, publicPrimaryKey);
            this.key = this.generateOpenPGPKey(subkey, publicSubKey);
        }
    }
}

