/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureException;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPMessageProcessor;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.OpenPGPSignature;

public class OpenPGPMessageInputStream
extends InputStream {
    public static int MAX_RECURSION = 16;
    private final PGPObjectFactory objectFactory;
    private final OpenPGPImplementation implementation;
    private final OpenPGPMessageProcessor processor;
    private final Result.Builder resultBuilder;
    private final Layer layer;
    private InputStream in;
    private final List<PacketHandler> packetHandlers = new ArrayList<PacketHandler>(){
        {
            this.add(new SignatureListHandler());
            this.add(new OnePassSignatureHandler());
            this.add(new MarkerHandler());
            this.add(new LiteralDataHandler());
            this.add(new CompressedDataHandler());
            this.add(new EncryptedDataHandler());
            this.add(new DefaultPacketHandler());
        }
    };
    private final List<PacketHandler> closeHandlers = new ArrayList<PacketHandler>(){
        {
            this.add(new SignatureListHandler());
            this.add(new PaddingHandler());
            this.add(new MarkerHandler());
            this.add(new DefaultPacketHandler());
        }
    };

    OpenPGPMessageInputStream(PGPObjectFactory objectFactory, OpenPGPMessageProcessor processor) {
        this(objectFactory, processor, Result.builder());
    }

    private OpenPGPMessageInputStream(PGPObjectFactory objectFactory, OpenPGPMessageProcessor processor, Result.Builder resultBuilder) {
        this.objectFactory = objectFactory;
        this.processor = processor;
        this.implementation = processor.getImplementation();
        this.resultBuilder = resultBuilder;
        try {
            this.layer = resultBuilder.openLayer();
        }
        catch (PGPException e) {
            throw new AssertionError((Object)e);
        }
    }

    void process() throws IOException, PGPException {
        Object next;
        while ((next = this.objectFactory.nextObject()) != null) {
            for (PacketHandler handler : this.packetHandlers) {
                if (!handler.canHandle(next)) continue;
                handler.handle(next);
                break;
            }
            if (this.in == null) continue;
            return;
        }
    }

    @Override
    public void close() throws IOException {
        Object next;
        this.in.close();
        while ((next = this.objectFactory.nextObject()) != null) {
            boolean handled = false;
            for (PacketHandler handler : this.closeHandlers) {
                if (!handler.canHandle(next)) continue;
                handler.close(next);
                handled = true;
                break;
            }
            if (handled) continue;
            this.processor.onException(new PGPException("Unexpected trailing packet encountered: " + next.getClass().getName()));
        }
        this.resultBuilder.verifySignatures(this.processor);
        this.resultBuilder.closeLayer();
    }

    @Override
    public int read() throws IOException {
        int i = this.in.read();
        if (i >= 0) {
            this.layer.onePassSignatures.update(i);
            this.layer.prefixedSignatures.update(i);
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i = this.in.read(b);
        if (i >= 0) {
            this.layer.onePassSignatures.update(b, 0, i);
            this.layer.prefixedSignatures.update(b, 0, i);
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead > 0) {
            this.layer.onePassSignatures.update(b, off, bytesRead);
            this.layer.prefixedSignatures.update(b, off, bytesRead);
        }
        return bytesRead;
    }

    public Result getResult() {
        return this.resultBuilder.build();
    }

    static class CompressedData
    extends Nested {
        private final int compressionAlgorithm;

        public CompressedData(int algorithm) {
            this.compressionAlgorithm = algorithm;
        }
    }

    private class CompressedDataHandler
    extends PacketHandler {
        private CompressedDataHandler() {
        }

        @Override
        public boolean canHandle(Object packet) {
            return packet instanceof PGPCompressedData;
        }

        @Override
        public void handle(Object packet) throws IOException, PGPException {
            PGPCompressedData compressedData = (PGPCompressedData)packet;
            OpenPGPMessageInputStream.this.resultBuilder.compressed(compressedData.getAlgorithm());
            InputStream decompressed = compressedData.getDataStream();
            this.processNestedStream(decompressed);
        }

        private void processNestedStream(InputStream input) throws IOException, PGPException {
            BCPGInputStream decodeIn = BCPGInputStream.wrap(input);
            PGPObjectFactory decFac = OpenPGPMessageInputStream.this.implementation.pgpObjectFactory(decodeIn);
            OpenPGPMessageInputStream nestedIn = new OpenPGPMessageInputStream(decFac, OpenPGPMessageInputStream.this.processor, OpenPGPMessageInputStream.this.resultBuilder);
            OpenPGPMessageInputStream.this.in = nestedIn;
            nestedIn.process();
        }
    }

    private class DefaultPacketHandler
    extends PacketHandler {
        private DefaultPacketHandler() {
        }

        @Override
        public boolean canHandle(Object packet) {
            return true;
        }

        @Override
        public void handle(Object packet) throws PGPException {
            OpenPGPMessageInputStream.this.processor.onException(new PGPException("Unexpected packet: " + packet.getClass().getName()));
        }
    }

    static class EncryptedData
    extends Nested {
        private final OpenPGPCertificate.OpenPGPComponentKey decryptionKey;
        private final char[] decryptionPassphrase;
        private final PGPSessionKey sessionKey;
        private final MessageEncryptionMechanism encryption;

        EncryptedData(OpenPGPMessageProcessor.Decrypted decrypted) {
            this.decryptionKey = decrypted.decryptionKey;
            this.decryptionPassphrase = decrypted.decryptionPassphrase;
            this.sessionKey = decrypted.sessionKey;
            if (decrypted.esk.getEncData() instanceof SymmetricEncIntegrityPacket) {
                SymmetricEncIntegrityPacket seipd = (SymmetricEncIntegrityPacket)decrypted.esk.getEncData();
                this.encryption = seipd.getVersion() == 2 ? MessageEncryptionMechanism.aead(seipd.getCipherAlgorithm(), seipd.getAeadAlgorithm()) : MessageEncryptionMechanism.integrityProtected(this.sessionKey.getAlgorithm());
            } else if (decrypted.esk.getEncData() instanceof AEADEncDataPacket) {
                this.encryption = MessageEncryptionMechanism.librePgp(this.sessionKey.getAlgorithm());
            } else {
                throw new RuntimeException("Unexpected encrypted data packet type: " + decrypted.esk.getClass().getName());
            }
        }
    }

    private class EncryptedDataHandler
    extends PacketHandler {
        private EncryptedDataHandler() {
        }

        @Override
        public boolean canHandle(Object packet) {
            return packet instanceof PGPEncryptedDataList;
        }

        @Override
        public void handle(Object packet) throws IOException, PGPException {
            PGPEncryptedDataList encryptedDataList = (PGPEncryptedDataList)packet;
            OpenPGPMessageProcessor.Decrypted decrypted = OpenPGPMessageInputStream.this.processor.decrypt(encryptedDataList);
            OpenPGPMessageInputStream.this.resultBuilder.encrypted(decrypted);
            this.processNestedStream(decrypted.inputStream);
        }

        private void processNestedStream(InputStream input) throws IOException, PGPException {
            BCPGInputStream decodeIn = BCPGInputStream.wrap(input);
            PGPObjectFactory decFac = OpenPGPMessageInputStream.this.implementation.pgpObjectFactory(decodeIn);
            OpenPGPMessageInputStream nestedIn = new OpenPGPMessageInputStream(decFac, OpenPGPMessageInputStream.this.processor, OpenPGPMessageInputStream.this.resultBuilder);
            OpenPGPMessageInputStream.this.in = nestedIn;
            nestedIn.process();
        }
    }

    static class Layer {
        private final OnePassSignatures onePassSignatures = new OnePassSignatures();
        private final PrefixedSignatures prefixedSignatures = new PrefixedSignatures();
        private List<OpenPGPSignature.OpenPGPDocumentSignature> signatures = null;
        private Nested nested;
        private boolean open = true;

        Layer() {
        }

        void setNested(Nested nested) {
            this.nested = nested;
        }

        void close() {
            this.open = false;
        }

        boolean isOpen() {
            return this.open;
        }
    }

    static class LiteralData
    extends Nested {
        private final String filename;
        private final char encoding;
        private final Date modificationTime;

        LiteralData(String filename, char encoding, Date modificationTime) {
            this.filename = filename;
            this.encoding = encoding;
            this.modificationTime = modificationTime;
        }
    }

    private class LiteralDataHandler
    extends PacketHandler {
        private LiteralDataHandler() {
        }

        @Override
        public boolean canHandle(Object packet) {
            return packet instanceof PGPLiteralData;
        }

        @Override
        public void handle(Object packet) throws IOException, PGPException {
            PGPLiteralData literalData = (PGPLiteralData)packet;
            OpenPGPMessageInputStream.this.resultBuilder.literalData(literalData.getFileName(), (char)literalData.getFormat(), literalData.getModificationTime());
            OpenPGPMessageInputStream.this.in = literalData.getDataStream();
            OpenPGPMessageInputStream.this.resultBuilder.initSignatures(OpenPGPMessageInputStream.this.processor);
        }
    }

    private static class MarkerHandler
    extends PacketHandler {
        private MarkerHandler() {
        }

        @Override
        public boolean canHandle(Object packet) {
            return packet instanceof PGPMarker;
        }
    }

    static class Nested {
        Nested() {
        }
    }

    private class OnePassSignatureHandler
    extends PacketHandler {
        private OnePassSignatureHandler() {
        }

        @Override
        public boolean canHandle(Object packet) {
            return packet instanceof PGPOnePassSignatureList;
        }

        @Override
        public void handle(Object packet) throws IOException, PGPException {
            PGPOnePassSignatureList pgpOnePassSignatures = (PGPOnePassSignatureList)packet;
            OpenPGPMessageInputStream.this.resultBuilder.onePassSignatures(pgpOnePassSignatures);
        }
    }

    static class OnePassSignatures {
        private final List<PGPOnePassSignature> onePassSignatures = new ArrayList<PGPOnePassSignature>();
        private final List<PGPSignature> signatures = new ArrayList<PGPSignature>();
        private final Map<PGPOnePassSignature, OpenPGPCertificate.OpenPGPComponentKey> issuers = new HashMap<PGPOnePassSignature, OpenPGPCertificate.OpenPGPComponentKey>();

        OnePassSignatures() {
        }

        void addOnePassSignatures(PGPOnePassSignatureList onePassSignatures) {
            Iterator<PGPOnePassSignature> it = onePassSignatures.iterator();
            while (it.hasNext()) {
                PGPOnePassSignature ops = it.next();
                this.onePassSignatures.add(ops);
            }
        }

        void addSignatures(PGPSignatureList signatures) {
            Iterator<PGPSignature> it = signatures.iterator();
            while (it.hasNext()) {
                PGPSignature signature = it.next();
                this.signatures.add(signature);
            }
        }

        void init(OpenPGPMessageProcessor processor) {
            for (PGPOnePassSignature ops : this.onePassSignatures) {
                KeyIdentifier identifier = ops.getKeyIdentifier();
                OpenPGPCertificate cert = processor.provideCertificate(identifier);
                if (cert == null) continue;
                try {
                    OpenPGPCertificate.OpenPGPComponentKey key = cert.getKey(identifier);
                    this.issuers.put(ops, key);
                    ops.init(processor.getImplementation().pgpContentVerifierBuilderProvider(), key.getPGPPublicKey());
                }
                catch (PGPException e) {
                    processor.onException(e);
                }
            }
        }

        void update(int i) {
            for (PGPOnePassSignature onePassSignature : this.onePassSignatures) {
                if (!this.issuers.containsKey(onePassSignature)) continue;
                onePassSignature.update((byte)i);
            }
        }

        void update(byte[] b, int off, int len) {
            for (PGPOnePassSignature onePassSignature : this.onePassSignatures) {
                if (!this.issuers.containsKey(onePassSignature)) continue;
                onePassSignature.update(b, off, len);
            }
        }

        List<OpenPGPSignature.OpenPGPDocumentSignature> verify(OpenPGPMessageProcessor processor) {
            OpenPGPPolicy policy = processor.getImplementation().policy();
            ArrayList<OpenPGPSignature.OpenPGPDocumentSignature> dataSignatures = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
            int num = this.onePassSignatures.size();
            for (int i = 0; i < this.signatures.size(); ++i) {
                PGPSignature signature = this.signatures.get(i);
                PGPOnePassSignature ops = this.onePassSignatures.get(num - i - 1);
                OpenPGPCertificate.OpenPGPComponentKey key = this.issuers.get(ops);
                if (key == null) continue;
                OpenPGPSignature.OpenPGPDocumentSignature dataSignature = new OpenPGPSignature.OpenPGPDocumentSignature(signature, key);
                try {
                    dataSignature.sanitize(key, policy);
                }
                catch (PGPSignatureException pGPSignatureException) {
                    // empty catch block
                }
                if (!dataSignature.createdInBounds(processor.getVerifyNotBefore(), processor.getVerifyNotAfter())) continue;
                try {
                    dataSignature.verify(ops);
                }
                catch (PGPException e) {
                    processor.onException(e);
                }
                dataSignatures.add(dataSignature);
            }
            return dataSignatures;
        }
    }

    private static class PacketHandler {
        private PacketHandler() {
        }

        public boolean canHandle(Object packet) {
            return false;
        }

        public void handle(Object packet) throws IOException, PGPException {
        }

        public void close(Object packet) throws IOException {
        }
    }

    private static class PaddingHandler
    extends PacketHandler {
        private PaddingHandler() {
        }

        @Override
        public boolean canHandle(Object packet) {
            return packet instanceof PGPPadding;
        }
    }

    static class PrefixedSignatures {
        private final List<PGPSignature> prefixedSignatures = new ArrayList<PGPSignature>();
        private final List<OpenPGPSignature.OpenPGPDocumentSignature> dataSignatures = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();

        PrefixedSignatures() {
        }

        void addAll(PGPSignatureList signatures) {
            Iterator<PGPSignature> it = signatures.iterator();
            while (it.hasNext()) {
                PGPSignature signature = it.next();
                this.prefixedSignatures.add(signature);
            }
        }

        void init(OpenPGPMessageProcessor processor) {
            for (PGPSignature sig : this.prefixedSignatures) {
                KeyIdentifier identifier = OpenPGPSignature.getMostExpressiveIdentifier(sig.getKeyIdentifiers());
                if (identifier == null) {
                    this.dataSignatures.add(new OpenPGPSignature.OpenPGPDocumentSignature(sig, null));
                    continue;
                }
                OpenPGPCertificate cert = processor.provideCertificate(identifier);
                if (cert == null) {
                    this.dataSignatures.add(new OpenPGPSignature.OpenPGPDocumentSignature(sig, null));
                    continue;
                }
                OpenPGPCertificate.OpenPGPComponentKey key = cert.getKey(identifier);
                OpenPGPSignature.OpenPGPDocumentSignature signature = new OpenPGPSignature.OpenPGPDocumentSignature(sig, key);
                this.dataSignatures.add(signature);
                try {
                    signature.signature.init(processor.getImplementation().pgpContentVerifierBuilderProvider(), cert.getKey(identifier).getPGPPublicKey());
                }
                catch (PGPException e) {
                    processor.onException(e);
                }
            }
        }

        void update(int i) {
            for (PGPSignature signature : this.prefixedSignatures) {
                signature.update((byte)i);
            }
        }

        void update(byte[] buf, int off, int len) {
            for (PGPSignature signature : this.prefixedSignatures) {
                signature.update(buf, off, len);
            }
        }

        List<OpenPGPSignature.OpenPGPDocumentSignature> verify(OpenPGPMessageProcessor processor) {
            ArrayList<OpenPGPSignature.OpenPGPDocumentSignature> verifiedSignatures = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
            OpenPGPPolicy policy = processor.getImplementation().policy();
            for (OpenPGPSignature.OpenPGPDocumentSignature sig : this.dataSignatures) {
                try {
                    sig.sanitize(sig.issuer, policy);
                }
                catch (PGPSignatureException e) {
                    processor.onException(e);
                    continue;
                }
                try {
                    sig.verify();
                }
                catch (PGPException e) {
                    processor.onException(e);
                }
                verifiedSignatures.add(sig);
            }
            return verifiedSignatures;
        }
    }

    public static class Result {
        private final List<OpenPGPSignature.OpenPGPDocumentSignature> documentSignatures = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
        private OpenPGPCertificate.OpenPGPComponentKey decryptionKey;
        private char[] decryptionPassphrase;
        private PGPSessionKey sessionKey;
        private MessageEncryptionMechanism encryptionMethod = MessageEncryptionMechanism.unencrypted();
        private int compressionAlgorithm = 0;
        private String filename;
        private char fileFormat;
        private Date fileModificationTime;

        private Result(List<Layer> layers) {
            for (Layer l : layers) {
                if (l.signatures != null) {
                    this.documentSignatures.addAll(l.signatures);
                }
                if (l.nested instanceof EncryptedData) {
                    EncryptedData encryptedData = (EncryptedData)l.nested;
                    this.encryptionMethod = encryptedData.encryption;
                    this.sessionKey = encryptedData.sessionKey;
                    this.decryptionKey = encryptedData.decryptionKey;
                    this.decryptionPassphrase = encryptedData.decryptionPassphrase;
                    continue;
                }
                if (l.nested instanceof CompressedData) {
                    CompressedData compressedData = (CompressedData)l.nested;
                    this.compressionAlgorithm = compressedData.compressionAlgorithm;
                    continue;
                }
                if (!(l.nested instanceof LiteralData)) continue;
                LiteralData literalData = (LiteralData)l.nested;
                this.filename = literalData.filename;
                this.fileFormat = literalData.encoding;
                this.fileModificationTime = literalData.modificationTime;
            }
        }

        static Builder builder() {
            return new Builder();
        }

        public MessageEncryptionMechanism getEncryptionMethod() {
            return this.encryptionMethod;
        }

        public OpenPGPCertificate.OpenPGPComponentKey getDecryptionKey() {
            return this.decryptionKey;
        }

        public char[] getDecryptionPassphrase() {
            return this.decryptionPassphrase;
        }

        public PGPSessionKey getSessionKey() {
            return this.sessionKey;
        }

        public int getCompressionAlgorithm() {
            return this.compressionAlgorithm;
        }

        public String getFilename() {
            return this.filename;
        }

        public char getFileFormat() {
            return this.fileFormat;
        }

        public Date getFileModificationTime() {
            return this.fileModificationTime;
        }

        public List<OpenPGPSignature.OpenPGPDocumentSignature> getSignatures() {
            return new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>(this.documentSignatures);
        }

        static class Builder {
            private final List<Layer> layers = new ArrayList<Layer>();

            private Builder() {
            }

            Layer last() {
                return this.layers.get(this.layers.size() - 1);
            }

            Layer openLayer() throws PGPException {
                if (this.layers.size() >= MAX_RECURSION) {
                    throw new PGPException("Exceeded maximum packet nesting depth.");
                }
                Layer layer = new Layer();
                this.layers.add(layer);
                return layer;
            }

            void closeLayer() {
                for (int i = this.layers.size() - 1; i >= 0; --i) {
                    Layer l = this.layers.get(i);
                    if (!l.isOpen()) continue;
                    l.close();
                    return;
                }
            }

            void compressed(int compressionAlgorithm) {
                this.last().setNested(new CompressedData(compressionAlgorithm));
            }

            void onePassSignatures(PGPOnePassSignatureList pgpOnePassSignatures) {
                this.last().onePassSignatures.addOnePassSignatures(pgpOnePassSignatures);
            }

            Result build() {
                return new Result(this.layers);
            }

            void prefixedSignatures(PGPSignatureList prefixedSigs) {
                this.last().prefixedSignatures.addAll(prefixedSigs);
            }

            void initSignatures(OpenPGPMessageProcessor processor) {
                this.last().onePassSignatures.init(processor);
                this.last().prefixedSignatures.init(processor);
            }

            void verifySignatures(OpenPGPMessageProcessor processor) {
                Layer last = this.last();
                if (last.signatures != null) {
                    return;
                }
                last.signatures = new ArrayList();
                last.signatures.addAll(last.onePassSignatures.verify(processor));
                last.signatures.addAll(last.prefixedSignatures.verify(processor));
            }

            void literalData(String fileName, char format, Date modificationTime) {
                this.last().setNested(new LiteralData(fileName, format, modificationTime));
            }

            void encrypted(OpenPGPMessageProcessor.Decrypted decrypted) {
                this.last().setNested(new EncryptedData(decrypted));
            }
        }
    }

    private class SignatureListHandler
    extends PacketHandler {
        private SignatureListHandler() {
        }

        @Override
        public boolean canHandle(Object packet) {
            return packet instanceof PGPSignatureList;
        }

        @Override
        public void handle(Object packet) {
            PGPSignatureList prefixedSigs = (PGPSignatureList)packet;
            OpenPGPMessageInputStream.this.resultBuilder.prefixedSignatures(prefixedSigs);
        }

        @Override
        public void close(Object packet) {
            PGPSignatureList sigList = (PGPSignatureList)packet;
            OpenPGPMessageInputStream.this.resultBuilder.last().onePassSignatures.addSignatures(sigList);
        }
    }
}

