/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPKeyMaterialProvider;

public abstract class OpenPGPKeyMaterialPool<M extends OpenPGPCertificate>
implements OpenPGPKeyMaterialProvider<M> {
    private final Map<KeyIdentifier, M> pool = new HashMap<KeyIdentifier, M>();
    private OpenPGPKeyMaterialProvider<M> callback = null;
    private boolean cacheResultsFromCallback = true;

    public OpenPGPKeyMaterialPool() {
    }

    public OpenPGPKeyMaterialPool(M item) {
        this.addItem(item);
    }

    public OpenPGPKeyMaterialPool(Collection<M> items) {
        for (OpenPGPCertificate item : items) {
            this.addItem(item);
        }
    }

    public OpenPGPKeyMaterialPool<M> setMissingItemCallback(OpenPGPKeyMaterialProvider<M> callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        this.callback = callback;
        return this;
    }

    public OpenPGPKeyMaterialPool<M> setCacheResultsFromCallback(boolean cacheResults) {
        this.cacheResultsFromCallback = cacheResults;
        return this;
    }

    @Override
    public M provide(KeyIdentifier componentKeyIdentifier) {
        OpenPGPCertificate result = (OpenPGPCertificate)this.pool.get(componentKeyIdentifier);
        if (result == null && this.callback != null) {
            result = this.callback.provide(componentKeyIdentifier);
            if (this.cacheResultsFromCallback) {
                this.addItem(result);
            }
        }
        return (M)result;
    }

    public OpenPGPKeyMaterialPool<M> addItem(M item) {
        if (item != null) {
            Iterator<KeyIdentifier> it = ((OpenPGPCertificate)item).getAllKeyIdentifiers().iterator();
            while (it.hasNext()) {
                this.pool.put(it.next(), item);
            }
        }
        return this;
    }

    public Collection<M> getAllItems() {
        Stream<M> distinct = this.pool.values().stream().distinct();
        return distinct.collect(Collectors.toList());
    }

    public static class OpenPGPCertificatePool
    extends OpenPGPKeyMaterialPool<OpenPGPCertificate>
    implements OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider {
        public OpenPGPCertificatePool() {
        }

        public OpenPGPCertificatePool(Collection<OpenPGPCertificate> items) {
            super(items);
        }

        public OpenPGPCertificatePool setMissingItemCallback(OpenPGPKeyMaterialProvider<OpenPGPCertificate> callback) {
            super.setMissingItemCallback(callback);
            return this;
        }

        public OpenPGPCertificatePool setCacheResultsFromCallback(boolean cacheResults) {
            super.setCacheResultsFromCallback(cacheResults);
            return this;
        }

        public OpenPGPCertificatePool addItem(OpenPGPCertificate item) {
            super.addItem(item);
            return this;
        }
    }

    public static class OpenPGPKeyPool
    extends OpenPGPKeyMaterialPool<OpenPGPKey>
    implements OpenPGPKeyMaterialProvider.OpenPGPKeyProvider {
        public OpenPGPKeyPool() {
        }

        public OpenPGPKeyPool(Collection<OpenPGPKey> items) {
            super(items);
        }

        public OpenPGPKeyPool setMissingItemCallback(OpenPGPKeyMaterialProvider<OpenPGPKey> callback) {
            super.setMissingItemCallback(callback);
            return this;
        }

        public OpenPGPKeyPool setCacheResultsFromCallback(boolean cacheResults) {
            super.setCacheResultsFromCallback(cacheResults);
            return this;
        }

        public OpenPGPKeyPool addItem(OpenPGPKey item) {
            super.addItem(item);
            return this;
        }
    }
}

