/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPMessageGenerator;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;

public abstract class OpenPGPEncryptionNegotiator {
    public abstract MessageEncryptionMechanism negotiateEncryption(OpenPGPMessageGenerator var1);

    static PreferredAEADCiphersuites negotiateAEADCiphersuite(List<OpenPGPCertificate> certificates, OpenPGPPolicy policy) {
        return new PreferredAEADCiphersuites(false, new PreferredAEADCiphersuites.Combination[]{OpenPGPEncryptionNegotiator.bestAEADCiphersuiteByWeight(certificates, policy)});
    }

    static boolean allRecipientsSupportSeipd2(List<OpenPGPCertificate> certificates) {
        return OpenPGPEncryptionNegotiator.allRecipientsSupportEncryptionFeature(certificates, (byte)8);
    }

    static boolean allRecipientsSupportLibrePGPOED(List<OpenPGPCertificate> certificates) {
        return OpenPGPEncryptionNegotiator.allRecipientsSupportEncryptionFeature(certificates, (byte)2);
    }

    static boolean allRecipientsSupportEncryptionFeature(List<OpenPGPCertificate> certificates, byte feature) {
        Iterator<OpenPGPCertificate> it = certificates.iterator();
        while (it.hasNext()) {
            List<OpenPGPCertificate.OpenPGPComponentKey> encryptionKeys = it.next().getEncryptionKeys();
            if (encryptionKeys.isEmpty()) continue;
            boolean recipientHasSupport = false;
            Iterator<OpenPGPCertificate.OpenPGPComponentKey> ckIt = encryptionKeys.iterator();
            while (ckIt.hasNext()) {
                Features features = ckIt.next().getFeatures();
                if (features == null || !features.supportsFeature(feature)) continue;
                recipientHasSupport = true;
                break;
            }
            if (recipientHasSupport) continue;
            return false;
        }
        return true;
    }

    public static PreferredAEADCiphersuites.Combination bestAEADCiphersuiteByWeight(Collection<OpenPGPCertificate> certificates, OpenPGPPolicy policy) {
        return OpenPGPEncryptionNegotiator.processCertificates(certificates, policy, new KeyProcessor<PreferredAEADCiphersuites, PreferredAEADCiphersuites.Combination>(){

            @Override
            public boolean processKey(OpenPGPCertificate.OpenPGPComponentKey key, Map<OpenPGPCertificate.OpenPGPComponentKey, PreferredAEADCiphersuites> capableKeys) {
                PreferredAEADCiphersuites prefs;
                Features features = key.getFeatures();
                if (features != null && features.supportsSEIPDv2() && (prefs = key.getAEADCipherSuitePreferences()) != null) {
                    capableKeys.put(key, prefs);
                    return true;
                }
                return false;
            }

            @Override
            public List<PreferredAEADCiphersuites.Combination> getAlgorithms(PreferredAEADCiphersuites prefs, OpenPGPPolicy policy) {
                ArrayList<PreferredAEADCiphersuites.Combination> result = new ArrayList<PreferredAEADCiphersuites.Combination>();
                for (PreferredAEADCiphersuites.Combination c : prefs.getAlgorithms()) {
                    if (c.getSymmetricAlgorithm() == 0 || !policy.isAcceptableSymmetricKeyAlgorithm(c.getSymmetricAlgorithm())) continue;
                    result.add(c);
                }
                return result;
            }
        }, PreferredAEADCiphersuites.DEFAULT().getAlgorithms()[0]);
    }

    static int bestSymmetricKeyAlgorithmByWeight(Collection<OpenPGPCertificate> certificates, OpenPGPPolicy policy) {
        return OpenPGPEncryptionNegotiator.processCertificates(certificates, policy, new KeyProcessor<PreferredAlgorithms, Integer>(){

            @Override
            public boolean processKey(OpenPGPCertificate.OpenPGPComponentKey key, Map<OpenPGPCertificate.OpenPGPComponentKey, PreferredAlgorithms> capableKeys) {
                PreferredAlgorithms prefs;
                Features features = key.getFeatures();
                if (features != null && features.supportsModificationDetection() && (prefs = key.getSymmetricCipherPreferences()) != null) {
                    capableKeys.put(key, prefs);
                    return true;
                }
                return false;
            }

            @Override
            public List<Integer> getAlgorithms(PreferredAlgorithms preferences, OpenPGPPolicy policy) {
                ArrayList<Integer> result = new ArrayList<Integer>();
                int[] prefs = preferences.getPreferences();
                for (int i = 0; i < prefs.length; ++i) {
                    int alg = prefs[i];
                    if (alg == 0 || !policy.isAcceptableSymmetricKeyAlgorithm(alg)) continue;
                    result.add(alg);
                }
                return result;
            }
        }, 7);
    }

    static int bestOEDEncryptionModeByWeight(Collection<OpenPGPCertificate> certificates, OpenPGPPolicy policy) {
        return OpenPGPEncryptionNegotiator.processCertificates(certificates, policy, new KeyProcessor<PreferredAlgorithms, Integer>(){

            @Override
            public boolean processKey(OpenPGPCertificate.OpenPGPComponentKey key, Map<OpenPGPCertificate.OpenPGPComponentKey, PreferredAlgorithms> capableKeys) {
                PreferredAlgorithms prefs;
                Features features = key.getFeatures();
                if (features != null && features.supportsFeature((byte)2) && (prefs = key.getSymmetricCipherPreferences()) != null) {
                    capableKeys.put(key, prefs);
                    return true;
                }
                return false;
            }

            @Override
            public List<Integer> getAlgorithms(PreferredAlgorithms preferences, OpenPGPPolicy policy) {
                ArrayList<Integer> result = new ArrayList<Integer>();
                int[] prefs = preferences.getPreferences();
                for (int i = 0; i < prefs.length; ++i) {
                    int alg = prefs[i];
                    if (!this.isOEDCompatible(alg) || !policy.isAcceptableSymmetricKeyAlgorithm(alg)) continue;
                    result.add(alg);
                }
                return result;
            }

            private boolean isOEDCompatible(int alg) {
                switch (alg) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
        }, 7);
    }

    private static <T, R> R processCertificates(Collection<OpenPGPCertificate> certificates, OpenPGPPolicy policy, KeyProcessor<T, R> keyProcessor, R defaultResult) {
        HashMap<R, Float> weights = new HashMap<R, Float>();
        Iterator<OpenPGPCertificate> it = certificates.iterator();
        while (it.hasNext()) {
            List<OpenPGPCertificate.OpenPGPComponentKey> encryptionKeys = it.next().getEncryptionKeys();
            if (encryptionKeys.isEmpty()) continue;
            HashMap capableKeys = new HashMap();
            Iterator<OpenPGPCertificate.OpenPGPComponentKey> ckIt = encryptionKeys.iterator();
            while (ckIt.hasNext()) {
                keyProcessor.processKey(ckIt.next(), capableKeys);
            }
            ckIt = capableKeys.keySet().iterator();
            while (ckIt.hasNext()) {
                Object prefs = capableKeys.get(ckIt.next());
                List<R> algorithms = keyProcessor.getAlgorithms(prefs, policy);
                for (int i = 0; i < algorithms.size(); ++i) {
                    R c = algorithms.get(i);
                    float current = weights.containsKey(c) ? ((Float)weights.get(c)).floatValue() : 0.0f;
                    weights.put(c, Float.valueOf(current + 1.0f / (float)(i + 1) / (float)capableKeys.size()));
                }
            }
        }
        Object maxKey = defaultResult;
        float maxWeight = -1.0f;
        for (Map.Entry entry : weights.entrySet()) {
            if (!(((Float)entry.getValue()).floatValue() > maxWeight)) continue;
            maxWeight = ((Float)entry.getValue()).floatValue();
            maxKey = entry.getKey();
        }
        return maxKey;
    }

    private static interface KeyProcessor<T, R> {
        public boolean processKey(OpenPGPCertificate.OpenPGPComponentKey var1, Map<OpenPGPCertificate.OpenPGPComponentKey, T> var2);

        public List<R> getAlgorithms(T var1, OpenPGPPolicy var2);
    }
}

