/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey key) {
        super(key);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(PGPPublicKey pubKey, byte[] sessionInfo) throws PGPException {
        try {
            AsymmetricKeyParameter cryptoPublicKey = this.keyConverter.getPublicKey(pubKey);
            PublicKeyPacket pubKeyPacket = pubKey.getPublicKeyPacket();
            if (pubKey.getAlgorithm() == 18) {
                ECDHPublicBCPGKey ecPubKey = (ECDHPublicBCPGKey)pubKeyPacket.getKey();
                byte[] userKeyingMaterial = RFC6637Utils.createUserKeyingMaterial(pubKeyPacket, new BcKeyFingerprintCalculator());
                if (ecPubKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                    AsymmetricCipherKeyPair ephKp = this.getAsymmetricCipherKeyPair((AsymmetricCipherKeyPairGenerator)new X25519KeyPairGenerator(), (KeyGenerationParameters)new X25519KeyGenerationParameters(this.random));
                    byte[] secret = BcUtil.getSecret((RawAgreement)new X25519Agreement(), ephKp.getPrivate(), cryptoPublicKey);
                    byte[] ephPubEncoding = new byte[33];
                    ephPubEncoding[0] = 64;
                    ((X25519PublicKeyParameters)ephKp.getPublic()).encode(ephPubEncoding, 1);
                    return this.encryptSessionInfo(sessionInfo, secret, userKeyingMaterial, ephPubEncoding, ecPubKey.getHashAlgorithm(), ecPubKey.getSymmetricKeyAlgorithm());
                }
                AsymmetricCipherKeyPair ephKp = this.getAsymmetricCipherKeyPair((AsymmetricCipherKeyPairGenerator)new ECKeyPairGenerator(), (KeyGenerationParameters)new ECKeyGenerationParameters(((ECPublicKeyParameters)cryptoPublicKey).getParameters(), this.random));
                ECDHBasicAgreement agreement = new ECDHBasicAgreement();
                agreement.init((CipherParameters)ephKp.getPrivate());
                BigInteger S = agreement.calculateAgreement((CipherParameters)cryptoPublicKey);
                byte[] secret = BigIntegers.asUnsignedByteArray((int)agreement.getFieldSize(), (BigInteger)S);
                byte[] ephPubEncoding = ((ECPublicKeyParameters)ephKp.getPublic()).getQ().getEncoded(false);
                return this.encryptSessionInfo(sessionInfo, secret, userKeyingMaterial, ephPubEncoding, ecPubKey.getHashAlgorithm(), ecPubKey.getSymmetricKeyAlgorithm());
            }
            if (pubKey.getAlgorithm() == 25) {
                return this.encryptSessionInfo(pubKeyPacket, sessionInfo, 8, 7, "X25519", (AsymmetricCipherKeyPairGenerator)new X25519KeyPairGenerator(), (KeyGenerationParameters)new X25519KeyGenerationParameters(this.random), (RawAgreement)new X25519Agreement(), cryptoPublicKey, 32, new EphPubEncodingOperation(){

                    @Override
                    public void getEphPubEncoding(AsymmetricKeyParameter publicKey, byte[] ephPubEncoding) {
                        ((X25519PublicKeyParameters)publicKey).encode(ephPubEncoding, 0);
                    }
                });
            }
            if (pubKey.getAlgorithm() == 26) {
                return this.encryptSessionInfo(pubKeyPacket, sessionInfo, 10, 9, "X448", (AsymmetricCipherKeyPairGenerator)new X448KeyPairGenerator(), (KeyGenerationParameters)new X448KeyGenerationParameters(this.random), (RawAgreement)new X448Agreement(), cryptoPublicKey, 56, new EphPubEncodingOperation(){

                    @Override
                    public void getEphPubEncoding(AsymmetricKeyParameter publicKey, byte[] ephPubEncoding) {
                        ((X448PublicKeyParameters)publicKey).encode(ephPubEncoding, 0);
                    }
                });
            }
            AsymmetricBlockCipher c = BcImplProvider.createPublicKeyCipher(pubKey.getAlgorithm());
            c.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)cryptoPublicKey, this.random));
            return c.processBlock(sessionInfo, 0, sessionInfo.length);
        }
        catch (Exception e) {
            throw new PGPException("exception encrypting session info: " + e.getMessage(), e);
        }
    }

    private byte[] encryptSessionInfo(byte[] sessionInfo, byte[] secret, byte[] userKeyingMaterial, byte[] ephPubEncoding, int hashAlgorithm, int symmetricKeyAlgorithm) throws IOException, PGPException {
        RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(hashAlgorithm), symmetricKeyAlgorithm);
        KeyParameter key = new KeyParameter(rfc6637KDFCalculator.createKey(secret, userKeyingMaterial));
        byte[] paddedSessionData = PGPPad.padSessionData(sessionInfo, this.sessionKeyObfuscation);
        return BcPublicKeyKeyEncryptionMethodGenerator.getSessionInfo(ephPubEncoding, this.getWrapper(symmetricKeyAlgorithm, key, paddedSessionData));
    }

    private byte[] encryptSessionInfo(PublicKeyPacket pubKeyPacket, byte[] sessionInfo, int hashAlgorithm, int symmetricKeyAlgorithm, String algorithmName, AsymmetricCipherKeyPairGenerator gen, KeyGenerationParameters parameters, RawAgreement agreement, AsymmetricKeyParameter cryptoPublicKey, int keySize, EphPubEncodingOperation ephPubEncodingOperation) throws PGPException, IOException {
        AsymmetricCipherKeyPair ephKp = this.getAsymmetricCipherKeyPair(gen, parameters);
        byte[] secret = BcUtil.getSecret(agreement, ephKp.getPrivate(), cryptoPublicKey);
        byte[] ephPubEncoding = new byte[keySize];
        ephPubEncodingOperation.getEphPubEncoding(ephKp.getPublic(), ephPubEncoding);
        KeyParameter key = new KeyParameter(RFC6637KDFCalculator.createKey(hashAlgorithm, symmetricKeyAlgorithm, Arrays.concatenate((byte[])ephPubEncoding, (byte[])pubKeyPacket.getKey().getEncoded(), (byte[])secret), "OpenPGP " + algorithmName));
        byte[] sessionData = new byte[sessionInfo.length - 3];
        System.arraycopy(sessionInfo, 1, sessionData, 0, sessionData.length);
        return BcPublicKeyKeyEncryptionMethodGenerator.getSessionInfo(ephPubEncoding, sessionInfo[0], this.getWrapper(symmetricKeyAlgorithm, key, sessionData));
    }

    private byte[] getWrapper(int symmetricKeyAlgorithm, KeyParameter key, byte[] sessionData) throws PGPException {
        Wrapper c = BcImplProvider.createWrapper(symmetricKeyAlgorithm);
        c.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)key, this.random));
        return c.wrap(sessionData, 0, sessionData.length);
    }

    private AsymmetricCipherKeyPair getAsymmetricCipherKeyPair(AsymmetricCipherKeyPairGenerator gen, KeyGenerationParameters parameters) {
        gen.init(parameters);
        return gen.generateKeyPair();
    }

    @FunctionalInterface
    private static interface EphPubEncodingOperation {
        public void getEphPubEncoding(AsymmetricKeyParameter var1, byte[] var2);
    }
}

