/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private static final BcPGPKeyConverter KEY_CONVERTER = new BcPGPKeyConverter();
    private final PGPPrivateKey pgpPrivKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pgpPrivKey) {
        this.pgpPrivKey = pgpPrivKey;
    }

    @Override
    public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
        try {
            AsymmetricKeyParameter privKey = KEY_CONVERTER.getPrivateKey(this.pgpPrivKey);
            if (keyAlgorithm == 25) {
                return this.getSessionData(secKeyData[0], privKey, 32, 8, 7, (RawAgreement)new X25519Agreement(), "X25519", new PublicKeyParametersOperation(){

                    @Override
                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] pEnc, int pEncOff) {
                        return new X25519PublicKeyParameters(pEnc, 0);
                    }
                });
            }
            if (keyAlgorithm == 26) {
                return this.getSessionData(secKeyData[0], privKey, 56, 10, 9, (RawAgreement)new X448Agreement(), "X448", new PublicKeyParametersOperation(){

                    @Override
                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] pEnc, int pEncOff) {
                        return new X448PublicKeyParameters(pEnc, 0);
                    }
                });
            }
            if (keyAlgorithm == 18) {
                byte[] secret;
                byte[] enc = secKeyData[0];
                int pLen = (((enc[0] & 0xFF) << 8) + (enc[1] & 0xFF) + 7) / 8;
                BcPublicKeyDataDecryptorFactory.assertOutOfRange(2 + pLen + 1, enc);
                byte[] pEnc = new byte[pLen];
                System.arraycopy(enc, 2, pEnc, 0, pLen);
                int keyLen = enc[pLen + 2] & 0xFF;
                BcPublicKeyDataDecryptorFactory.assertOutOfRange(2 + pLen + 1 + keyLen, enc);
                byte[] keyEnc = new byte[keyLen];
                System.arraycopy(enc, 2 + pLen + 1, keyEnc, 0, keyLen);
                ECDHPublicBCPGKey ecPubKey = (ECDHPublicBCPGKey)this.pgpPrivKey.getPublicKeyPacket().getKey();
                if (ecPubKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                    if (pEnc.length != 33 || 64 != pEnc[0]) {
                        throw new IllegalArgumentException("Invalid Curve25519 public key");
                    }
                    secret = BcUtil.getSecret((RawAgreement)new X25519Agreement(), privKey, (AsymmetricKeyParameter)new X25519PublicKeyParameters(pEnc, 1));
                } else {
                    ECDomainParameters ecParameters = ((ECPrivateKeyParameters)privKey).getParameters();
                    ECPublicKeyParameters ephPub = new ECPublicKeyParameters(ecParameters.getCurve().decodePoint(pEnc), ecParameters);
                    ECDHBasicAgreement agreement = new ECDHBasicAgreement();
                    agreement.init((CipherParameters)privKey);
                    BigInteger S = agreement.calculateAgreement((CipherParameters)ephPub);
                    secret = BigIntegers.asUnsignedByteArray((int)agreement.getFieldSize(), (BigInteger)S);
                }
                byte hashAlgorithm = ecPubKey.getHashAlgorithm();
                byte symmetricKeyAlgorithm = ecPubKey.getSymmetricKeyAlgorithm();
                byte[] userKeyingMaterial = RFC6637Utils.createUserKeyingMaterial(this.pgpPrivKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator());
                RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(hashAlgorithm), symmetricKeyAlgorithm);
                KeyParameter key = new KeyParameter(rfc6637KDFCalculator.createKey(secret, userKeyingMaterial));
                return PGPPad.unpadSessionData(BcPublicKeyDataDecryptorFactory.unwrapSessionData(keyEnc, symmetricKeyAlgorithm, key));
            }
            AsymmetricBlockCipher c = BcImplProvider.createPublicKeyCipher(keyAlgorithm);
            BufferedAsymmetricBlockCipher c1 = new BufferedAsymmetricBlockCipher(c);
            c1.init(false, (CipherParameters)privKey);
            if (keyAlgorithm == 2 || keyAlgorithm == 1) {
                byte[] bi = secKeyData[0];
                c1.processBytes(bi, 2, bi.length - 2);
            } else {
                ElGamalPrivateKeyParameters parms = (ElGamalPrivateKeyParameters)privKey;
                int size = (parms.getParameters().getP().bitLength() + 7) / 8;
                byte[] tmp = new byte[size];
                byte[] bi = secKeyData[0];
                if (bi.length - 2 > size) {
                    c1.processBytes(bi, 3, bi.length - 3);
                } else {
                    System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                    c1.processBytes(tmp, 0, tmp.length);
                }
                bi = secKeyData[1];
                Arrays.fill((byte[])tmp, (byte)0);
                if (bi.length - 2 > size) {
                    c1.processBytes(bi, 3, bi.length - 3);
                } else {
                    System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                    c1.processBytes(tmp, 0, tmp.length);
                }
            }
            return c1.doFinal();
        }
        catch (IOException e) {
            throw new PGPException("exception creating user keying material: " + e.getMessage(), e);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("exception decrypting session info: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
        return BcUtil.createDataDecryptor(withIntegrityPacket, engine, key);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aeadEncDataPacket, sessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(seipd, sessionKey);
    }

    private byte[] getSessionData(byte[] enc, AsymmetricKeyParameter privKey, int pLen, int hashAlgorithm, int symmetricKeyAlgorithm, RawAgreement agreement, String algorithmName, PublicKeyParametersOperation pkp) throws PGPException, InvalidCipherTextException {
        byte[] pEnc = new byte[pLen];
        System.arraycopy(enc, 0, pEnc, 0, pLen);
        int keyLen = enc[pLen] & 0xFF;
        BcPublicKeyDataDecryptorFactory.assertOutOfRange(pLen + 1 + keyLen, enc);
        byte[] keyEnc = new byte[keyLen - 1];
        System.arraycopy(enc, pLen + 2, keyEnc, 0, keyEnc.length);
        byte[] secret = BcUtil.getSecret(agreement, privKey, pkp.getPublicKeyParameters(pEnc, 0));
        KeyParameter key = new KeyParameter(RFC6637KDFCalculator.createKey(hashAlgorithm, symmetricKeyAlgorithm, Arrays.concatenate((byte[])pEnc, (byte[])this.pgpPrivKey.getPublicKeyPacket().getKey().getEncoded(), (byte[])secret), "OpenPGP " + algorithmName));
        return Arrays.concatenate((byte[])new byte[]{enc[pLen + 1]}, (byte[])BcPublicKeyDataDecryptorFactory.unwrapSessionData(keyEnc, symmetricKeyAlgorithm, key));
    }

    private static byte[] unwrapSessionData(byte[] keyEnc, int symmetricKeyAlgorithm, KeyParameter key) throws PGPException, InvalidCipherTextException {
        Wrapper c = BcImplProvider.createWrapper(symmetricKeyAlgorithm);
        c.init(false, (CipherParameters)key);
        return c.unwrap(keyEnc, 0, keyEnc.length);
    }

    private static void assertOutOfRange(int pLen, byte[] enc) throws PGPException {
        if (pLen > enc.length) {
            throw new PGPException("encoded length out of range");
        }
    }

    @FunctionalInterface
    private static interface PublicKeyParametersOperation {
        public AsymmetricKeyParameter getPublicKeyParameters(byte[] var1, int var2);
    }
}

