/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.StreamUtil;

public class OnePassSignaturePacket
extends ContainedPacket {
    private int version;
    private int sigType;
    private int hashAlgorithm;
    private int keyAlgorithm;
    private long keyID;
    private int isContaining;

    OnePassSignaturePacket(BCPGInputStream in) throws IOException {
        super(4);
        this.version = in.read();
        this.sigType = in.read();
        this.hashAlgorithm = in.read();
        this.keyAlgorithm = in.read();
        this.keyID |= (long)in.read() << 56;
        this.keyID |= (long)in.read() << 48;
        this.keyID |= (long)in.read() << 40;
        this.keyID |= (long)in.read() << 32;
        this.keyID |= (long)in.read() << 24;
        this.keyID |= (long)in.read() << 16;
        this.keyID |= (long)in.read() << 8;
        this.keyID |= (long)in.read();
        this.isContaining = in.read();
    }

    public OnePassSignaturePacket(int sigType, int hashAlgorithm, int keyAlgorithm, long keyID, boolean isNested) {
        super(4);
        this.version = 3;
        this.sigType = sigType;
        this.hashAlgorithm = hashAlgorithm;
        this.keyAlgorithm = keyAlgorithm;
        this.keyID = keyID;
        this.isContaining = isNested ? 0 : 1;
    }

    public int getSignatureType() {
        return this.sigType;
    }

    public int getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public boolean isContaining() {
        return this.isContaining == 1;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        pOut.write(this.sigType);
        pOut.write(this.hashAlgorithm);
        pOut.write(this.keyAlgorithm);
        StreamUtil.writeKeyID(pOut, this.keyID);
        pOut.write(this.isContaining);
        pOut.close();
        out.writePacket(4, bOut.toByteArray());
    }
}

