/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import org.bouncycastle.util.io.TeeInputStream;

public class PGPSymmetricKeyEncryptedData
extends PGPEncryptedData {
    protected PGPSymmetricKeyEncryptedData(InputStreamPacket encData) {
        super(encData);
    }

    protected InputStream createDecryptionStream(PGPDataDecryptorFactory dataDecryptorFactory, PGPSessionKey sessionKey) throws PGPException {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
            if (aeadData.getAlgorithm() != sessionKey.getAlgorithm()) {
                throw new PGPException("session key and AEAD algorithm mismatch");
            }
            PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(aeadData, sessionKey);
            BCPGInputStream encIn = this.encData.getInputStream();
            return new BCPGInputStream(dataDecryptor.getInputStream(encIn));
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket seipd = (SymmetricEncIntegrityPacket)this.encData;
            if (seipd.getVersion() == 1) {
                PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(true, sessionKey.getAlgorithm(), sessionKey.getKey());
                return this.getDataStream(true, dataDecryptor);
            }
            if (seipd.getVersion() == 2) {
                PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(seipd, sessionKey);
                return new BCPGInputStream(dataDecryptor.getInputStream(this.encData.getInputStream()));
            }
            throw new UnsupportedPacketVersionException("Unsupported SEIPD packet version: " + seipd.getVersion());
        }
        PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(false, sessionKey.getAlgorithm(), sessionKey.getKey());
        return this.getDataStream(false, dataDecryptor);
    }

    private InputStream getDataStream(boolean withIntegrityPacket, PGPDataDecryptor dataDecryptor) throws PGPException {
        try {
            boolean zeroesCheckPassed;
            BCPGInputStream encIn = this.encData.getInputStream();
            encIn.mark(dataDecryptor.getBlockSize() + 2);
            this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(encIn));
            if (withIntegrityPacket) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                this.integrityCalculator = dataDecryptor.getIntegrityCalculator();
                this.encStream = new TeeInputStream((InputStream)this.truncStream, this.integrityCalculator.getOutputStream());
            }
            byte[] iv = new byte[dataDecryptor.getBlockSize()];
            for (int i = 0; i != iv.length; ++i) {
                int ch = this.encStream.read();
                if (ch < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                iv[i] = (byte)ch;
            }
            int v1 = this.encStream.read();
            int v2 = this.encStream.read();
            if (v1 < 0 || v2 < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean repeatCheckPassed = iv[iv.length - 2] == (byte)v1 && iv[iv.length - 1] == (byte)v2;
            boolean bl = zeroesCheckPassed = v1 == 0 && v2 == 0;
            if (!repeatCheckPassed && !zeroesCheckPassed) {
                encIn.reset();
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }
}

