/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.BigIntegers;

class JcaJcePGPUtil {
    JcaJcePGPUtil() {
    }

    public static SecretKey makeSymmetricKey(int algorithm, byte[] keyBytes) throws PGPException {
        String algName = PGPUtil.getSymmetricCipherName(algorithm);
        if (algName == null) {
            throw new PGPException("unknown symmetric algorithm: " + algorithm);
        }
        return new SecretKeySpec(keyBytes, algName);
    }

    static ECPoint decodePoint(BigInteger encodedPoint, ECCurve curve) throws IOException {
        return curve.decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)encodedPoint));
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier curveOID) {
        X9ECParameters x9Params = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)curveOID);
        if (x9Params == null) {
            return ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOID);
        }
        return x9Params;
    }
}

