/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretSubkeyPacket;

public class SecretKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int USAGE_NONE = 0;
    public static final int USAGE_CHECKSUM = 255;
    public static final int USAGE_SHA1 = 254;
    public static final int USAGE_AEAD = 253;
    private PublicKeyPacket pubKeyPacket;
    private byte[] secKeyData;
    private int s2kUsage;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] iv;

    SecretKeyPacket(BCPGInputStream in) throws IOException {
        this.pubKeyPacket = this instanceof SecretSubkeyPacket ? new PublicSubkeyPacket(in) : new PublicKeyPacket(in);
        this.s2kUsage = in.read();
        if (this.s2kUsage == 255 || this.s2kUsage == 254) {
            this.encAlgorithm = in.read();
            this.s2k = new S2K(in);
        } else {
            this.encAlgorithm = this.s2kUsage;
        }
        if ((this.s2k == null || this.s2k.getType() != 101 || this.s2k.getProtectionMode() != 1) && this.s2kUsage != 0) {
            this.iv = this.encAlgorithm < 7 ? new byte[8] : new byte[16];
            in.readFully(this.iv, 0, this.iv.length);
        }
        this.secKeyData = in.readAll();
    }

    public SecretKeyPacket(PublicKeyPacket pubKeyPacket, int encAlgorithm, S2K s2k, byte[] iv, byte[] secKeyData) {
        this.pubKeyPacket = pubKeyPacket;
        this.encAlgorithm = encAlgorithm;
        this.s2kUsage = encAlgorithm != 0 ? 255 : 0;
        this.s2k = s2k;
        this.iv = iv;
        this.secKeyData = secKeyData;
    }

    public SecretKeyPacket(PublicKeyPacket pubKeyPacket, int encAlgorithm, int s2kUsage, S2K s2k, byte[] iv, byte[] secKeyData) {
        this.pubKeyPacket = pubKeyPacket;
        this.encAlgorithm = encAlgorithm;
        this.s2kUsage = s2kUsage;
        this.s2k = s2k;
        this.iv = iv;
        this.secKeyData = secKeyData;
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public int getS2KUsage() {
        return this.s2kUsage;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.pubKeyPacket;
    }

    public byte[] getSecretKeyData() {
        return this.secKeyData;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.pubKeyPacket.getEncodedContents());
        pOut.write(this.s2kUsage);
        if (this.s2kUsage == 255 || this.s2kUsage == 254) {
            pOut.write(this.encAlgorithm);
            pOut.writeObject(this.s2k);
        }
        if (this.iv != null) {
            pOut.write(this.iv);
        }
        if (this.secKeyData != null && this.secKeyData.length > 0) {
            pOut.write(this.secKeyData);
        }
        pOut.close();
        return bOut.toByteArray();
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(5, this.getEncodedContents());
    }
}

