/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.TeeInputStream;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    private boolean confirmCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        return sessionInfo[sessionInfo.length - 2] == (byte)(check >> 8) && sessionInfo[sessionInfo.length - 1] == (byte)check;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        if (this.keyData.getVersion() == 3) {
            byte[] plain = dataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
            return plain[0];
        }
        if (this.keyData.getVersion() == 6) {
            return ((SymmetricEncIntegrityPacket)this.encData).getCipherAlgorithm();
        }
        throw new UnsupportedPacketVersionException("Unsupported packet version: " + this.keyData.getVersion());
    }

    public PGPSessionKey getSessionKey(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        if (!this.confirmCheckSum(sessionData)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        return new PGPSessionKey(sessionData[0] & 0xFF, Arrays.copyOfRange((byte[])sessionData, (int)1, (int)(sessionData.length - 2)));
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        return this.getDataStream(dataDecryptorFactory, this.getSessionKey(dataDecryptorFactory));
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        return this.getDataStream(dataDecryptorFactory, dataDecryptorFactory.getSessionKey());
    }

    private InputStream getDataStream(PGPDataDecryptorFactory dataDecryptorFactory, PGPSessionKey sessionKey) throws PGPException {
        if (sessionKey.getAlgorithm() != 0) {
            try {
                if (this.encData instanceof AEADEncDataPacket) {
                    AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
                    if (aeadData.getAlgorithm() != sessionKey.getAlgorithm()) {
                        throw new PGPException("session key and AEAD algorithm mismatch");
                    }
                    PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(aeadData, sessionKey);
                    BCPGInputStream encIn = this.encData.getInputStream();
                    this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(encIn));
                } else {
                    boolean withIntegrityPacket = this.encData instanceof SymmetricEncIntegrityPacket;
                    PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(withIntegrityPacket, sessionKey.getAlgorithm(), sessionKey.getKey());
                    BCPGInputStream encIn = this.encData.getInputStream();
                    this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(encIn));
                    if (withIntegrityPacket) {
                        this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                        this.integrityCalculator = dataDecryptor.getIntegrityCalculator();
                        this.encStream = new TeeInputStream((InputStream)this.truncStream, this.integrityCalculator.getOutputStream());
                    }
                    byte[] iv = new byte[dataDecryptor.getBlockSize()];
                    for (int i = 0; i != iv.length; ++i) {
                        int ch = this.encStream.read();
                        if (ch < 0) {
                            throw new EOFException("unexpected end of stream.");
                        }
                        iv[i] = (byte)ch;
                    }
                    int v1 = this.encStream.read();
                    int v2 = this.encStream.read();
                    if (v1 < 0 || v2 < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                }
                return this.encStream;
            }
            catch (PGPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PGPException("Exception starting decryption", e);
            }
        }
        return this.encData.getInputStream();
    }

    @Override
    public int getAlgorithm() {
        return this.keyData.getAlgorithm();
    }

    @Override
    public int getVersion() {
        return this.keyData.getVersion();
    }
}

