/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePBEDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private PGPDigestCalculatorProvider calculatorProvider;

    public JcePBEDataDecryptorFactoryBuilder() {
        this.calculatorProvider = null;
    }

    public JcePBEDataDecryptorFactoryBuilder(PGPDigestCalculatorProvider calculatorProvider) {
        this.calculatorProvider = calculatorProvider;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PBEDataDecryptorFactory build(char[] passPhrase) {
        if (this.calculatorProvider == null) {
            try {
                this.calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder(this.helper).build();
            }
            catch (PGPException e) {
                throw new IllegalStateException("digest calculator provider cannot be built with current helper: " + e.getMessage());
            }
        }
        return new PBEDataDecryptorFactory(passPhrase, this.calculatorProvider){

            @Override
            public byte[] recoverSessionData(int keyAlgorithm, byte[] key, byte[] secKeyData) throws PGPException {
                try {
                    if (secKeyData != null && secKeyData.length > 0) {
                        String cipherName = PGPUtil.getSymmetricCipherName(keyAlgorithm);
                        Cipher keyCipher = JcePBEDataDecryptorFactoryBuilder.this.helper.createCipher(cipherName + "/CFB/NoPadding");
                        keyCipher.init(2, (Key)new SecretKeySpec(key, cipherName), new IvParameterSpec(new byte[keyCipher.getBlockSize()]));
                        return keyCipher.doFinal(secKeyData);
                    }
                    byte[] keyBytes = new byte[key.length + 1];
                    keyBytes[0] = (byte)keyAlgorithm;
                    System.arraycopy(key, 0, keyBytes, 1, key.length);
                    return keyBytes;
                }
                catch (Exception e) {
                    throw new PGPException("Exception recovering session info", e);
                }
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.helper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(int aeadAlgorithm, byte[] iv, int chunkSize, int encAlgorithm, byte[] key) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.helper.createDataDecryptor(aeadAlgorithm, iv, chunkSize, encAlgorithm, key);
            }
        };
    }
}

