/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.EAXBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

class BcUtil {
    BcUtil() {
    }

    static BufferedBlockCipher createStreamCipher(boolean forEncryption, BlockCipher engine, boolean withIntegrityPacket, byte[] key) {
        BufferedBlockCipher c = withIntegrityPacket ? new BufferedBlockCipher((BlockCipher)new CFBBlockCipher(engine, engine.getBlockSize() * 8)) : new BufferedBlockCipher((BlockCipher)new OpenPGPCFBBlockCipher(engine));
        KeyParameter keyParameter = new KeyParameter(key);
        if (withIntegrityPacket) {
            c.init(forEncryption, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, new byte[engine.getBlockSize()]));
        } else {
            c.init(forEncryption, (CipherParameters)keyParameter);
        }
        return c;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, BlockCipher engine, byte[] key) {
        final BufferedBlockCipher c = BcUtil.createStreamCipher(false, engine, withIntegrityPacket, key);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream in) {
                return new CipherInputStream(in, c);
            }

            @Override
            public int getBlockSize() {
                return c.getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean forEncryption, BlockCipher engine, byte[] key, byte[] iv) {
        BufferedBlockCipher c = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher(engine, engine.getBlockSize() * 8));
        c.init(forEncryption, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        return c;
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier curveOID) {
        X9ECParameters x9 = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)curveOID);
        if (x9 == null) {
            x9 = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOID);
        }
        return x9;
    }

    static ECPoint decodePoint(BigInteger encodedPoint, ECCurve curve) {
        return curve.decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)encodedPoint));
    }

    private static long getChunkLength(int chunkSize) {
        return 1L << chunkSize + 6;
    }

    static PGPDataDecryptor createDataDecryptor(final int aeadAlgorithm, final byte[] iv, final int chunkSize, final int encAlgorithm, byte[] key) throws PGPException {
        final KeyParameter secretKey = new KeyParameter(key);
        final AEADBlockCipher c = BcUtil.createAEADCipher(encAlgorithm, aeadAlgorithm);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream in) {
                try {
                    return new PGPAeadInputStream(in, c, secretKey, iv, encAlgorithm, aeadAlgorithm, chunkSize);
                }
                catch (IOException e) {
                    throw Exceptions.illegalStateException((String)("unable to open stream: " + e.getMessage()), (Throwable)e);
                }
            }

            @Override
            public int getBlockSize() {
                return c.getUnderlyingCipher().getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    static AEADBlockCipher createAEADCipher(int encAlgorithm, int aeadAlgorithm) throws PGPException {
        if (encAlgorithm != 7 && encAlgorithm != 8 && encAlgorithm != 9) {
            throw new PGPException("AEAD only supported for AES based algorithms");
        }
        switch (aeadAlgorithm) {
            case 1: {
                return new EAXBlockCipher((BlockCipher)new AESEngine());
            }
            case 2: {
                return new OCBBlockCipher((BlockCipher)new AESEngine(), (BlockCipher)new AESEngine());
            }
            case 3: {
                return new GCMBlockCipher((BlockCipher)new AESEngine());
            }
        }
        throw new PGPException("unrecognised AEAD algorithm: " + aeadAlgorithm);
    }

    static byte[] getNonce(byte[] iv, long chunkIndex) {
        byte[] nonce = Arrays.clone((byte[])iv);
        BcUtil.xorChunkId(nonce, chunkIndex);
        return nonce;
    }

    static void xorChunkId(byte[] nonce, long chunkIndex) {
        int index = nonce.length - 8;
        int n = index++;
        nonce[n] = (byte)(nonce[n] ^ (byte)(chunkIndex >> 56));
        int n2 = index++;
        nonce[n2] = (byte)(nonce[n2] ^ (byte)(chunkIndex >> 48));
        int n3 = index++;
        nonce[n3] = (byte)(nonce[n3] ^ (byte)(chunkIndex >> 40));
        int n4 = index++;
        nonce[n4] = (byte)(nonce[n4] ^ (byte)(chunkIndex >> 32));
        int n5 = index++;
        nonce[n5] = (byte)(nonce[n5] ^ (byte)(chunkIndex >> 24));
        int n6 = index++;
        nonce[n6] = (byte)(nonce[n6] ^ (byte)(chunkIndex >> 16));
        int n7 = index++;
        nonce[n7] = (byte)(nonce[n7] ^ (byte)(chunkIndex >> 8));
        int n8 = index;
        nonce[n8] = (byte)(nonce[n8] ^ (byte)chunkIndex);
    }

    private static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadInputStream(InputStream in, AEADBlockCipher c, KeyParameter secretKey, byte[] iv, int encAlgorithm, int aeadAlgorithm, int chunkSize) throws IOException {
            this.in = in;
            this.iv = iv;
            this.chunkLength = (int)BcUtil.getChunkLength(chunkSize);
            this.buf = new byte[this.chunkLength + 32];
            this.c = c;
            this.secretKey = secretKey;
            this.aaData = new byte[5];
            this.aaData[0] = -44;
            this.aaData[1] = 1;
            this.aaData[2] = (byte)encAlgorithm;
            this.aaData[3] = (byte)aeadAlgorithm;
            this.aaData[4] = (byte)chunkSize;
            Streams.readFully((InputStream)in, (byte[])this.buf, (int)0, (int)32);
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int supplyLen = Math.min(len, this.available());
            System.arraycopy(this.data, this.dataOff, b, off, supplyLen);
            this.dataOff += supplyLen;
            return supplyLen;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int skip = (int)Math.min(n, (long)this.available());
            this.dataOff += skip;
            return skip;
        }

        @Override
        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            int dataLen = Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)32, (int)this.chunkLength);
            if (dataLen == 0) {
                return null;
            }
            byte[] adata = new byte[13];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            BcUtil.xorChunkId(adata, this.chunkIndex);
            byte[] decData = new byte[dataLen];
            try {
                this.c.init(false, (CipherParameters)new AEADParameters(this.secretKey, 128, BcUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(adata, 0, adata.length);
                int len = this.c.processBytes(this.buf, 0, dataLen + 16, decData, 0);
                this.c.doFinal(decData, len);
            }
            catch (InvalidCipherTextException e) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + e.getMessage());
            }
            this.totalBytes += (long)decData.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, dataLen + 16, this.buf, 0, 16);
            if (dataLen != this.chunkLength) {
                adata = new byte[13];
                System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
                BcUtil.xorChunkId(adata, this.chunkIndex);
                try {
                    this.c.init(false, (CipherParameters)new AEADParameters(this.secretKey, 128, BcUtil.getNonce(this.iv, this.chunkIndex)));
                    this.c.processAADBytes(adata, 0, adata.length);
                    this.c.processAADBytes(Pack.longToBigEndian((long)this.totalBytes), 0, 8);
                    this.c.processBytes(this.buf, 0, 16, this.buf, 0);
                    this.c.doFinal(this.buf, 0);
                }
                catch (InvalidCipherTextException e) {
                    throw new IOException("exception processing final tag: " + e.getMessage());
                }
            } else {
                Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)16, (int)16);
            }
            return decData;
        }
    }

    static class PGPAeadOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final byte[] data;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(OutputStream out, AEADBlockCipher c, KeyParameter secretKey, int encAlgorithm, int aeadAlgorithm, int chunkSize, byte[] iv) {
            this.out = out;
            this.iv = iv;
            this.chunkLength = (int)BcUtil.getChunkLength(chunkSize);
            this.data = new byte[this.chunkLength];
            this.c = c;
            this.secretKey = secretKey;
            this.aaData = new byte[5];
            this.aaData[0] = -44;
            this.aaData[1] = 1;
            this.aaData[2] = (byte)encAlgorithm;
            this.aaData[3] = (byte)aeadAlgorithm;
            this.aaData[4] = (byte)chunkSize;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (len < this.data.length - this.dataOff) {
                System.arraycopy(b, off, this.data, this.dataOff, len);
                this.dataOff += len;
            } else {
                int gap = this.data.length - this.dataOff;
                System.arraycopy(b, off, this.data, this.dataOff, gap);
                this.dataOff += gap;
                this.writeBlock();
                len -= gap;
                off += gap;
                while (len >= this.data.length) {
                    System.arraycopy(b, off, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    len -= this.data.length;
                    off += this.data.length;
                }
                if (len > 0) {
                    System.arraycopy(b, off, this.data, 0, len);
                    this.dataOff = len;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            byte[] adata = new byte[13];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            BcUtil.xorChunkId(adata, this.chunkIndex);
            try {
                this.c.init(true, (CipherParameters)new AEADParameters(this.secretKey, 128, BcUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(adata, 0, adata.length);
                int len = this.c.processBytes(this.data, 0, this.dataOff, this.data, 0);
                this.out.write(this.data, 0, len);
                len = this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, len);
            }
            catch (InvalidCipherTextException e) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + e.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            byte[] adata = new byte[13];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            BcUtil.xorChunkId(adata, this.chunkIndex);
            try {
                this.c.init(true, (CipherParameters)new AEADParameters(this.secretKey, 128, BcUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(adata, 0, adata.length);
                this.c.processAADBytes(Pack.longToBigEndian((long)this.totalBytes), 0, 8);
                this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, 16);
                this.out.close();
            }
            catch (InvalidCipherTextException e) {
                throw new IOException("exception processing final tag: " + e.getMessage());
            }
        }
    }
}

