/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketTags;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.bcpg.sig.EmbeddedSignature;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PolicyURI;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.RegularExpression;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    private final InputStream in;
    private final int limit;

    public SignatureSubpacketInputStream(InputStream in) {
        this(in, StreamUtil.findLimit(in));
    }

    public SignatureSubpacketInputStream(InputStream in, int limit) {
        this.in = in;
        this.limit = limit;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public SignatureSubpacket readPacket() throws IOException {
        int l = this.read();
        int bodyLen = 0;
        if (l < 0) {
            return null;
        }
        boolean isLongLength = false;
        if (l < 192) {
            bodyLen = l;
        } else if (l <= 223) {
            bodyLen = (l - 192 << 8) + this.in.read() + 192;
        } else if (l == 255) {
            isLongLength = true;
            bodyLen = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
        } else {
            throw new IOException("unexpected length header");
        }
        int tag = this.in.read();
        if (tag < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        if (bodyLen <= 0 || bodyLen > this.limit && bodyLen > 2048) {
            throw new EOFException("out of range data found in signature sub packet");
        }
        byte[] data = new byte[bodyLen - 1];
        int bytesRead = Streams.readFully((InputStream)this.in, (byte[])data);
        boolean isCritical = (tag & 0x80) != 0;
        int type = tag & 0x7F;
        if (bytesRead != data.length) {
            switch (type) {
                case 2: {
                    data = this.checkData(data, 4, bytesRead, "Signature Creation Time");
                    break;
                }
                case 16: {
                    data = this.checkData(data, 8, bytesRead, "Issuer");
                    break;
                }
                case 9: {
                    data = this.checkData(data, 4, bytesRead, "Signature Key Expiration Time");
                    break;
                }
                case 3: {
                    data = this.checkData(data, 4, bytesRead, "Signature Expiration Time");
                    break;
                }
                default: {
                    throw new EOFException("truncated subpacket data.");
                }
            }
        }
        switch (type) {
            case 2: {
                return new SignatureCreationTime(isCritical, isLongLength, data);
            }
            case 32: {
                return new EmbeddedSignature(isCritical, isLongLength, data);
            }
            case 9: {
                return new KeyExpirationTime(isCritical, isLongLength, data);
            }
            case 3: {
                return new SignatureExpirationTime(isCritical, isLongLength, data);
            }
            case 7: {
                return new Revocable(isCritical, isLongLength, data);
            }
            case 4: {
                return new Exportable(isCritical, isLongLength, data);
            }
            case 30: {
                return new Features(isCritical, isLongLength, data);
            }
            case 16: {
                return new IssuerKeyID(isCritical, isLongLength, data);
            }
            case 5: {
                return new TrustSignature(isCritical, isLongLength, data);
            }
            case 11: 
            case 21: 
            case 22: 
            case 39: {
                return new PreferredAlgorithms(type, isCritical, isLongLength, data);
            }
            case 27: {
                return new KeyFlags(isCritical, isLongLength, data);
            }
            case 26: {
                return new PolicyURI(isCritical, isLongLength, data);
            }
            case 25: {
                return new PrimaryUserID(isCritical, isLongLength, data);
            }
            case 28: {
                return new SignerUserID(isCritical, isLongLength, data);
            }
            case 20: {
                return new NotationData(isCritical, isLongLength, data);
            }
            case 6: {
                return new RegularExpression(isCritical, isLongLength, data);
            }
            case 29: {
                return new RevocationReason(isCritical, isLongLength, data);
            }
            case 12: {
                return new RevocationKey(isCritical, isLongLength, data);
            }
            case 31: {
                return new SignatureTarget(isCritical, isLongLength, data);
            }
            case 33: {
                return new IssuerFingerprint(isCritical, isLongLength, data);
            }
            case 35: {
                return new IntendedRecipientFingerprint(isCritical, isLongLength, data);
            }
        }
        return new SignatureSubpacket(type, isCritical, isLongLength, data);
    }

    private byte[] checkData(byte[] data, int expected, int bytesRead, String name) throws EOFException {
        if (bytesRead != expected) {
            throw new EOFException("truncated " + name + " subpacket data.");
        }
        return Arrays.copyOfRange((byte[])data, (int)0, (int)expected);
    }
}

