/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class PublicKeyEncSessionPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int version;
    private long keyID;
    private int algorithm;
    private byte[][] data;

    PublicKeyEncSessionPacket(BCPGInputStream in) throws IOException {
        this.version = in.read();
        if (this.version != 3) {
            throw new UnsupportedPacketVersionException("Unsupported PGP public key encrypted session key packet version encountered: " + this.version);
        }
        this.keyID |= (long)in.read() << 56;
        this.keyID |= (long)in.read() << 48;
        this.keyID |= (long)in.read() << 40;
        this.keyID |= (long)in.read() << 32;
        this.keyID |= (long)in.read() << 24;
        this.keyID |= (long)in.read() << 16;
        this.keyID |= (long)in.read() << 8;
        this.keyID |= (long)in.read();
        this.algorithm = in.read();
        switch (this.algorithm) {
            case 1: 
            case 2: {
                this.data = new byte[1][];
                this.data[0] = new MPInteger(in).getEncoded();
                break;
            }
            case 16: 
            case 20: {
                this.data = new byte[2][];
                this.data[0] = new MPInteger(in).getEncoded();
                this.data[1] = new MPInteger(in).getEncoded();
                break;
            }
            case 18: {
                this.data = new byte[1][];
                this.data[0] = Streams.readAll((InputStream)in);
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered");
            }
        }
    }

    public PublicKeyEncSessionPacket(long keyID, int algorithm, byte[][] data) {
        this.version = 3;
        this.keyID = keyID;
        this.algorithm = algorithm;
        this.data = new byte[data.length][];
        for (int i = 0; i != data.length; ++i) {
            this.data[i] = Arrays.clone((byte[])data[i]);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[][] getEncSessionKey() {
        return this.data;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        pOut.write((byte)(this.keyID >> 56));
        pOut.write((byte)(this.keyID >> 48));
        pOut.write((byte)(this.keyID >> 40));
        pOut.write((byte)(this.keyID >> 32));
        pOut.write((byte)(this.keyID >> 24));
        pOut.write((byte)(this.keyID >> 16));
        pOut.write((byte)(this.keyID >> 8));
        pOut.write((byte)this.keyID);
        pOut.write(this.algorithm);
        for (int i = 0; i != this.data.length; ++i) {
            pOut.write(this.data[i]);
        }
        pOut.close();
        out.writePacket(1, bOut.toByteArray());
    }
}

