/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADCipherUtil;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePBEDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.helper);
    private PGPDigestCalculatorProvider calculatorProvider;

    public JcePBEDataDecryptorFactoryBuilder() {
        this.calculatorProvider = null;
    }

    public JcePBEDataDecryptorFactoryBuilder(PGPDigestCalculatorProvider calculatorProvider) {
        this.calculatorProvider = calculatorProvider;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public PBEDataDecryptorFactory build(char[] passPhrase) {
        if (this.calculatorProvider == null) {
            try {
                this.calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder(this.helper).build();
            }
            catch (PGPException e) {
                throw new IllegalStateException("digest calculator provider cannot be built with current helper: " + e.getMessage());
            }
        }
        return new PBEDataDecryptorFactory(passPhrase, this.calculatorProvider){

            public byte[] recoverSessionData(int keyAlgorithm, byte[] key, byte[] secKeyData) throws PGPException {
                try {
                    if (secKeyData != null && secKeyData.length > 0) {
                        String cipherName = PGPUtil.getSymmetricCipherName(keyAlgorithm);
                        Cipher keyCipher = JcePBEDataDecryptorFactoryBuilder.this.helper.createCipher(cipherName + "/CFB/NoPadding");
                        keyCipher.init(2, (Key)new SecretKeySpec(key, cipherName), new IvParameterSpec(new byte[keyCipher.getBlockSize()]));
                        return keyCipher.doFinal(secKeyData);
                    }
                    byte[] keyBytes = new byte[key.length + 1];
                    keyBytes[0] = (byte)keyAlgorithm;
                    System.arraycopy(key, 0, keyBytes, 1, key.length);
                    return keyBytes;
                }
                catch (Exception e) {
                    throw new PGPException("Exception recovering session info", e);
                }
            }

            public byte[] recoverAEADEncryptedSessionData(SymmetricKeyEncSessionPacket keyData, byte[] ikm) throws PGPException {
                byte[] sessionData;
                SecretKeySpec secretKey;
                if (keyData.getVersion() < 5) {
                    throw new PGPException("SKESK packet MUST be version 5 or later.");
                }
                byte[] hkdfInfo = keyData.getAAData();
                if (keyData.getVersion() == 5) {
                    secretKey = new SecretKeySpec(ikm, PGPUtil.getSymmetricCipherName(keyData.getEncAlgorithm()));
                } else if (keyData.getVersion() == 6) {
                    int kekLen = SymmetricKeyUtils.getKeyLengthInOctets(keyData.getEncAlgorithm());
                    byte[] kek = JceAEADUtil.generateHKDFBytes(ikm, null, hkdfInfo, kekLen);
                    secretKey = new SecretKeySpec(kek, PGPUtil.getSymmetricCipherName(keyData.getEncAlgorithm()));
                } else {
                    throw new UnsupportedPacketVersionException("Unsupported SKESK packet version encountered: " + keyData.getVersion());
                }
                Cipher aead = JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createAEADCipher(keyData.getEncAlgorithm(), keyData.getAeadAlgorithm());
                int aeadMacLen = 128;
                byte[] authTag = keyData.getAuthTag();
                byte[] aeadIv = keyData.getIv();
                byte[] encSessionKey = keyData.getSecKeyData();
                byte[] buf = new byte[encSessionKey.length + authTag.length];
                System.arraycopy(encSessionKey, 0, buf, 0, encSessionKey.length);
                System.arraycopy(authTag, 0, buf, encSessionKey.length, authTag.length);
                try {
                    JceAEADCipherUtil.setUpAeadCipher(aead, secretKey, 2, aeadIv, aeadMacLen, hkdfInfo);
                    sessionData = aead.doFinal(buf, 0, buf.length);
                }
                catch (GeneralSecurityException e) {
                    throw new PGPException("unable to open stream: " + e.getMessage());
                }
                return sessionData;
            }

            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.helper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }

            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aeadEncDataPacket, sessionKey);
            }

            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(seipd, sessionKey);
            }
        };
    }
}

