/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.bc;

import java.io.InputStream;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcAEADSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcCFBSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcSessionKeyDataDecryptorFactory;

public class BcOpenPGPImplementation
extends OpenPGPImplementation {
    public PGPObjectFactory pgpObjectFactory(InputStream packetInputStream) {
        return new BcPGPObjectFactory(packetInputStream).setThrowForUnknownCriticalPackets(true);
    }

    public PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider() {
        return new BcPGPContentVerifierBuilderProvider();
    }

    public PBESecretKeyDecryptorBuilderProvider pbeSecretKeyDecryptorBuilderProvider() {
        return new BcPBESecretKeyDecryptorBuilderProvider();
    }

    public PGPDataEncryptorBuilder pgpDataEncryptorBuilder(int symmetricKeyAlgorithm) {
        return new BcPGPDataEncryptorBuilder(symmetricKeyAlgorithm);
    }

    public PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator(PGPPublicKey encryptionSubkey) {
        return new BcPublicKeyKeyEncryptionMethodGenerator(encryptionSubkey);
    }

    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] messagePassphrase) {
        return new BcPBEKeyEncryptionMethodGenerator(messagePassphrase);
    }

    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] messagePassphrase, S2K.Argon2Params argon2Params) {
        return new BcPBEKeyEncryptionMethodGenerator(messagePassphrase, argon2Params);
    }

    public PGPContentSignerBuilder pgpContentSignerBuilder(int publicKeyAlgorithm, int hashAlgorithm) {
        return new BcPGPContentSignerBuilder(publicKeyAlgorithm, hashAlgorithm);
    }

    public PBEDataDecryptorFactory pbeDataDecryptorFactory(char[] messagePassphrase) throws PGPException {
        return new BcPBEDataDecryptorFactory(messagePassphrase, this.pgpDigestCalculatorProvider());
    }

    public SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory(PGPSessionKey sessionKey) {
        return new BcSessionKeyDataDecryptorFactory(sessionKey);
    }

    public PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory(PGPPrivateKey decryptionKey) {
        return new BcPublicKeyDataDecryptorFactory(decryptionKey);
    }

    public PGPDigestCalculatorProvider pgpDigestCalculatorProvider() throws PGPException {
        return new BcPGPDigestCalculatorProvider();
    }

    public PGPKeyPairGeneratorProvider pgpKeyPairGeneratorProvider() {
        return new BcPGPKeyPairGeneratorProvider();
    }

    public PGPContentSignerBuilderProvider pgpContentSignerBuilderProvider(int hashAlgorithmId) {
        return new BcPGPContentSignerBuilderProvider(hashAlgorithmId);
    }

    public KeyFingerPrintCalculator keyFingerPrintCalculator() {
        return new BcKeyFingerprintCalculator();
    }

    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean aead) {
        return this.pbeSecretKeyEncryptorFactory(aead, 7, 96);
    }

    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean aead, int symmetricKeyAlgorithm, int iterationCount) {
        if (aead) {
            return new BcAEADSecretKeyEncryptorFactory();
        }
        return new BcCFBSecretKeyEncryptorFactory(symmetricKeyAlgorithm, iterationCount);
    }
}

