/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;

public interface OpenPGPPolicy {
    public boolean isAcceptableSigningKey(PGPPublicKey var1);

    public boolean isAcceptableVerificationKey(PGPPublicKey var1);

    public boolean isAcceptableEncryptionKey(PGPPublicKey var1);

    public boolean isAcceptableDecryptionKey(PGPPublicKey var1);

    public boolean isAcceptablePublicKey(PGPPublicKey var1);

    public boolean isAcceptableSignature(PGPSignature var1);

    public boolean hasAcceptableSignatureHashAlgorithm(PGPSignature var1);

    public boolean hasAcceptableDocumentSignatureHashAlgorithm(PGPSignature var1);

    public boolean hasAcceptableRevocationSignatureHashAlgorithm(PGPSignature var1);

    public boolean hasAcceptableCertificationSignatureHashAlgorithm(PGPSignature var1);

    public boolean hasNoCriticalUnknownNotations(PGPSignature var1);

    public boolean hasNoCriticalUnknownSubpackets(PGPSignature var1);

    public boolean isKnownSignatureSubpacket(int var1);

    public boolean isAcceptableDocumentSignatureHashAlgorithm(int var1, Date var2);

    public boolean isAcceptableRevocationSignatureHashAlgorithm(int var1, Date var2);

    public boolean isAcceptableCertificationSignatureHashAlgorithm(int var1, Date var2);

    public int getDefaultCertificationSignatureHashAlgorithm();

    public int getDefaultDocumentSignatureHashAlgorithm();

    public boolean isAcceptableSymmetricKeyAlgorithm(int var1);

    public int getDefaultSymmetricKeyAlgorithm();

    public boolean isAcceptablePublicKeyStrength(int var1, int var2);

    public OpenPGPNotationRegistry getNotationRegistry();

    public static class OpenPGPNotationRegistry {
        private final Set<String> knownNotations = new HashSet<String>();

        public boolean isNotationKnown(String notationName) {
            return this.knownNotations.contains(notationName);
        }

        public void addKnownNotation(String notationName) {
            this.knownNotations.add(notationName);
        }
    }
}

