/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import org.bouncycastle.bcpg.Ed25519SecretBCPGKey;
import org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import org.bouncycastle.bcpg.Ed448SecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X25519SecretBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;
import org.bouncycastle.bcpg.X448SecretBCPGKey;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class JcaPGPKeyConverter
extends PGPKeyConverter {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private KeyFingerPrintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();

    public JcaPGPKeyConverter setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyConverter setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pub, PrivateKey privKey) throws PGPException {
        BCPGKey privPk = this.getPrivateBCPGKey(pub, privKey);
        return new PGPPrivateKey(pub.getKeyID(), pub.getPublicKeyPacket(), privPk);
    }

    public PGPPublicKey getPGPPublicKey(int algorithm, PGPAlgorithmParameters algorithmParameters, PublicKey pubKey, Date time) throws PGPException {
        BCPGKey bcpgKey = this.getPublicBCPGKey(algorithm, algorithmParameters, pubKey);
        return new PGPPublicKey(new PublicKeyPacket(algorithm, time, bcpgKey), this.fingerPrintCalculator);
    }

    public PGPPublicKey getPGPPublicKey(int algorithm, PublicKey pubKey, Date time) throws PGPException {
        return this.getPGPPublicKey(algorithm, null, pubKey, time);
    }

    public PrivateKey getPrivateKey(PGPPrivateKey privKey) throws PGPException {
        if (privKey instanceof JcaPGPPrivateKey) {
            return ((JcaPGPPrivateKey)privKey).getPrivateKey();
        }
        PublicKeyPacket pubPk = privKey.getPublicKeyPacket();
        final BCPGKey privPk = privKey.getPrivateKeyDataPacket();
        try {
            switch (pubPk.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dsaPub = (DSAPublicBCPGKey)pubPk.getKey();
                    DSASecretBCPGKey dsaPriv = (DSASecretBCPGKey)privPk;
                    DSAPrivateKeySpec dsaPrivSpec = new DSAPrivateKeySpec(dsaPriv.getX(), dsaPub.getP(), dsaPub.getQ(), dsaPub.getG());
                    return this.implGeneratePrivate("DSA", dsaPrivSpec);
                }
                case 18: {
                    ECDHPublicBCPGKey ecdhPub = (ECDHPublicBCPGKey)pubPk.getKey();
                    ECSecretBCPGKey ecdhK = (ECSecretBCPGKey)privPk;
                    if (CryptlibObjectIdentifiers.curvey25519.equals((ASN1Primitive)ecdhPub.getCurveOID())) {
                        return this.implGeneratePrivate("XDH", new Operation(){

                            public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                                return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, Arrays.reverseInPlace((byte[])BigIntegers.asUnsignedByteArray((BigInteger)((ECSecretBCPGKey)privPk).getX())));
                            }
                        });
                    }
                    return this.implGetPrivateKeyEC("ECDH", ecdhPub, ecdhK);
                }
                case 25: {
                    return this.implGeneratePrivate("XDH", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, 32, Arrays.reverseInPlace((byte[])privPk.getEncoded()));
                        }
                    });
                }
                case 26: {
                    return this.implGeneratePrivate("XDH", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, 56, Arrays.reverseInPlace((byte[])privPk.getEncoded()));
                        }
                    });
                }
                case 19: {
                    return this.implGetPrivateKeyEC("ECDSA", (ECDSAPublicBCPGKey)pubPk.getKey(), (ECSecretBCPGKey)privPk);
                }
                case 22: {
                    return this.implGeneratePrivate("EdDSA", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, BigIntegers.asUnsignedByteArray((int)32, (BigInteger)((EdSecretBCPGKey)privPk).getX()));
                        }
                    });
                }
                case 27: {
                    return this.implGeneratePrivate("EdDSA", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, 32, privPk.getEncoded());
                        }
                    });
                }
                case 28: {
                    return this.implGeneratePrivate("EdDSA", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed448, 57, privPk.getEncoded());
                        }
                    });
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elPub = (ElGamalPublicBCPGKey)pubPk.getKey();
                    ElGamalSecretBCPGKey elPriv = (ElGamalSecretBCPGKey)privPk;
                    DHPrivateKeySpec elSpec = new DHPrivateKeySpec(elPriv.getX(), elPub.getP(), elPub.getG());
                    return this.implGeneratePrivate("ElGamal", elSpec);
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaPub = (RSAPublicBCPGKey)pubPk.getKey();
                    RSASecretBCPGKey rsaPriv = (RSASecretBCPGKey)privPk;
                    RSAPrivateCrtKeySpec rsaPrivSpec = new RSAPrivateCrtKeySpec(rsaPriv.getModulus(), rsaPub.getPublicExponent(), rsaPriv.getPrivateExponent(), rsaPriv.getPrimeP(), rsaPriv.getPrimeQ(), rsaPriv.getPrimeExponentP(), rsaPriv.getPrimeExponentQ(), rsaPriv.getCrtCoefficient());
                    return this.implGeneratePrivate("RSA", rsaPrivSpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + pubPk.getAlgorithm());
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    public PublicKey getPublicKey(PGPPublicKey publicKey) throws PGPException {
        PublicKeyPacket publicPk = publicKey.getPublicKeyPacket();
        try {
            switch (publicPk.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dsaK = (DSAPublicBCPGKey)publicPk.getKey();
                    DSAPublicKeySpec dsaSpec = new DSAPublicKeySpec(dsaK.getY(), dsaK.getP(), dsaK.getQ(), dsaK.getG());
                    return this.implGeneratePublic("DSA", dsaSpec);
                }
                case 18: {
                    ECDHPublicBCPGKey ecdhK = (ECDHPublicBCPGKey)publicPk.getKey();
                    if (ecdhK.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                        return this.get25519PublicKey(ecdhK.getEncodedPoint(), EdECObjectIdentifiers.id_X25519, "XDH", "Curve");
                    }
                    return this.implGetPublicKeyEC("ECDH", ecdhK);
                }
                case 25: {
                    return this.implGetPublicKeyX509(publicPk.getKey().getEncoded(), 0, EdECObjectIdentifiers.id_X25519, "XDH");
                }
                case 26: {
                    return this.implGetPublicKeyX509(publicPk.getKey().getEncoded(), 0, EdECObjectIdentifiers.id_X448, "XDH");
                }
                case 19: {
                    return this.implGetPublicKeyEC("ECDSA", (ECDSAPublicBCPGKey)publicPk.getKey());
                }
                case 22: {
                    return this.get25519PublicKey(((EdDSAPublicBCPGKey)publicPk.getKey()).getEncodedPoint(), EdECObjectIdentifiers.id_Ed25519, "EdDSA", "Ed");
                }
                case 27: {
                    BCPGKey key = publicPk.getKey();
                    if (key instanceof Ed25519PublicBCPGKey) {
                        return this.implGetPublicKeyX509(BigIntegers.asUnsignedByteArray((BigInteger)new BigInteger(1, publicPk.getKey().getEncoded())), 0, EdECObjectIdentifiers.id_Ed25519, "EdDSA");
                    }
                    return this.implGetPublicKeyX509(BigIntegers.asUnsignedByteArray((BigInteger)((EdDSAPublicBCPGKey)publicPk.getKey()).getEncodedPoint()), 0, EdECObjectIdentifiers.id_Ed25519, "EdDSA");
                }
                case 28: {
                    return this.implGetPublicKeyX509(BigIntegers.asUnsignedByteArray((BigInteger)new BigInteger(1, publicPk.getKey().getEncoded())), 0, EdECObjectIdentifiers.id_Ed448, "EdDSA");
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elK = (ElGamalPublicBCPGKey)publicPk.getKey();
                    DHPublicKeySpec elSpec = new DHPublicKeySpec(elK.getY(), elK.getP(), elK.getG());
                    return this.implGeneratePublic("ElGamal", elSpec);
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaK = (RSAPublicBCPGKey)publicPk.getKey();
                    RSAPublicKeySpec rsaSpec = new RSAPublicKeySpec(rsaK.getModulus(), rsaK.getPublicExponent());
                    return this.implGeneratePublic("RSA", rsaSpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicPk.getAlgorithm());
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception constructing public key", e);
        }
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier curveOid, X9ECParameters x9Params) throws InvalidParameterSpecException, NoSuchProviderException, NoSuchAlgorithmException {
        AlgorithmParameters params = this.helper.createAlgorithmParameters("EC");
        params.init(new ECGenParameterSpec(ECNamedCurveTable.getName((ASN1ObjectIdentifier)curveOid)));
        return params.getParameterSpec(ECParameterSpec.class);
    }

    private BCPGKey getPrivateBCPGKey(PrivateKey privKey, BCPGKeyOperation operation) throws PGPException {
        PrivateKeyInfo pInfo = PrivateKeyInfo.getInstance((Object)privKey.getEncoded());
        try {
            return operation.getBCPGKey(ASN1OctetString.getInstance((Object)pInfo.parsePrivateKey()).getOctets());
        }
        catch (IOException e) {
            throw new PGPException(e.getMessage(), e);
        }
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pub, PrivateKey privKey) throws PGPException {
        switch (pub.getAlgorithm()) {
            case 17: {
                DSAPrivateKey dsK = (DSAPrivateKey)privKey;
                return new DSASecretBCPGKey(dsK.getX());
            }
            case 18: {
                if (privKey instanceof ECPrivateKey) {
                    ECPrivateKey ecK = (ECPrivateKey)privKey;
                    return new ECSecretBCPGKey(ecK.getS());
                }
                return this.getPrivateBCPGKey(privKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] pInfoEncoded) {
                        return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverse((byte[])pInfoEncoded)));
                    }
                });
            }
            case 25: {
                return this.getPrivateBCPGKey(privKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] pInfoEncoded) {
                        return new X25519SecretBCPGKey(Arrays.reverse((byte[])pInfoEncoded));
                    }
                });
            }
            case 26: {
                return this.getPrivateBCPGKey(privKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] pInfoEncoded) {
                        return new X448SecretBCPGKey(Arrays.reverse((byte[])pInfoEncoded));
                    }
                });
            }
            case 19: {
                return new ECSecretBCPGKey(((ECPrivateKey)privKey).getS());
            }
            case 22: {
                return this.getPrivateBCPGKey(privKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] pInfoEncoded) {
                        return new EdSecretBCPGKey(new BigInteger(1, pInfoEncoded));
                    }
                });
            }
            case 27: {
                return this.getPrivateBCPGKey(privKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] pInfoEncoded) {
                        return new Ed25519SecretBCPGKey(pInfoEncoded);
                    }
                });
            }
            case 28: {
                return this.getPrivateBCPGKey(privKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] pInfoEncoded) {
                        return new Ed448SecretBCPGKey(pInfoEncoded);
                    }
                });
            }
            case 16: 
            case 20: {
                DHPrivateKey esK = (DHPrivateKey)privKey;
                return new ElGamalSecretBCPGKey(esK.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rsK = (RSAPrivateCrtKey)privKey;
                return new RSASecretBCPGKey(rsK.getPrivateExponent(), rsK.getPrimeP(), rsK.getPrimeQ());
            }
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(int algorithm, PGPAlgorithmParameters algorithmParameters, PublicKey pubKey) throws PGPException {
        if (pubKey instanceof RSAPublicKey) {
            RSAPublicKey rK = (RSAPublicKey)pubKey;
            return new RSAPublicBCPGKey(rK.getModulus(), rK.getPublicExponent());
        }
        if (pubKey instanceof DSAPublicKey) {
            DSAPublicKey dK = (DSAPublicKey)pubKey;
            DSAParams dP = dK.getParams();
            return new DSAPublicBCPGKey(dP.getP(), dP.getQ(), dP.getG(), dK.getY());
        }
        if (pubKey instanceof DHPublicKey) {
            DHPublicKey eK = (DHPublicKey)pubKey;
            DHParameterSpec eS = eK.getParams();
            return new ElGamalPublicBCPGKey(eS.getP(), eS.getG(), eK.getY());
        }
        if (pubKey instanceof ECPublicKey) {
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
            ASN1ObjectIdentifier curveOid = ASN1ObjectIdentifier.getInstance((Object)keyInfo.getAlgorithm().getParameters());
            X9ECParametersHolder params = ECNamedCurveTable.getByOIDLazy((ASN1ObjectIdentifier)curveOid);
            DEROctetString key = new DEROctetString(keyInfo.getPublicKeyData().getBytes());
            X9ECPoint derQ = new X9ECPoint(params.getCurve(), (ASN1OctetString)key);
            if (algorithm == 18) {
                PGPKdfParameters kdfParams = this.implGetKdfParameters(curveOid, algorithmParameters);
                return new ECDHPublicBCPGKey(curveOid, derQ.getPoint(), kdfParams.getHashAlgorithm(), kdfParams.getSymmetricWrapAlgorithm());
            }
            if (algorithm == 19) {
                return new ECDSAPublicBCPGKey(curveOid, derQ.getPoint());
            }
            throw new PGPException("unknown EC algorithm");
        }
        if (algorithm == 27) {
            return this.getPublicBCPGKey(pubKey, 32, new BCPGKeyOperation(){

                public BCPGKey getBCPGKey(byte[] key) {
                    return new Ed25519PublicBCPGKey(key);
                }
            });
        }
        if (pubKey.getAlgorithm().regionMatches(true, 0, "ED2", 0, 3)) {
            return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, this.getPointEncUncompressed(pubKey, 32)));
        }
        if (algorithm == 25) {
            return this.getPublicBCPGKey(pubKey, 32, new BCPGKeyOperation(){

                public BCPGKey getBCPGKey(byte[] key) {
                    return new X25519PublicBCPGKey(key);
                }
            });
        }
        if (pubKey.getAlgorithm().regionMatches(true, 0, "X2", 0, 2)) {
            PGPKdfParameters kdfParams = this.implGetKdfParameters(CryptlibObjectIdentifiers.curvey25519, algorithmParameters);
            return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, this.getPointEncUncompressed(pubKey, 32)), kdfParams.getHashAlgorithm(), kdfParams.getSymmetricWrapAlgorithm());
        }
        if (algorithm == 28) {
            return this.getPublicBCPGKey(pubKey, 57, new BCPGKeyOperation(){

                public BCPGKey getBCPGKey(byte[] key) {
                    return new Ed448PublicBCPGKey(key);
                }
            });
        }
        if (algorithm == 26) {
            return this.getPublicBCPGKey(pubKey, 56, new BCPGKeyOperation(){

                public BCPGKey getBCPGKey(byte[] key) {
                    return new X448PublicBCPGKey(key);
                }
            });
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(PublicKey pubKey, int keySize, BCPGKeyOperation operation) {
        SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
        byte[] pointEnc = new byte[keySize];
        System.arraycopy(pubInfo.getPublicKeyData().getBytes(), 0, pointEnc, 0, pointEnc.length);
        return operation.getBCPGKey(pointEnc);
    }

    private byte[] getPointEncUncompressed(PublicKey pubKey, int publicKeySize) {
        SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
        byte[] pointEnc = new byte[1 + publicKeySize];
        pointEnc[0] = 64;
        System.arraycopy(pubInfo.getPublicKeyData().getBytes(), 0, pointEnc, 1, pointEnc.length - 1);
        return pointEnc;
    }

    private PrivateKey implGeneratePrivate(String keyAlgorithm, Operation operation) throws GeneralSecurityException, PGPException, IOException {
        PKCS8EncodedKeySpec pkcs8Spec = new PKCS8EncodedKeySpec(operation.getPrivateKeyInfos().getEncoded());
        KeyFactory keyFactory = this.helper.createKeyFactory(keyAlgorithm);
        return keyFactory.generatePrivate(pkcs8Spec);
    }

    private PrivateKey implGeneratePrivate(String keyAlgorithm, KeySpec keySpec) throws GeneralSecurityException, PGPException {
        KeyFactory keyFactory = this.helper.createKeyFactory(keyAlgorithm);
        return keyFactory.generatePrivate(keySpec);
    }

    private PublicKey implGeneratePublic(String keyAlgorithm, KeySpec keySpec) throws GeneralSecurityException, PGPException {
        KeyFactory keyFactory = this.helper.createKeyFactory(keyAlgorithm);
        return keyFactory.generatePublic(keySpec);
    }

    private PublicKey implGetPublicKeyX509(byte[] pEnc, int pEncOff, ASN1ObjectIdentifier algorithm, String keyAlgorithm) throws IOException, PGPException, GeneralSecurityException {
        return this.implGeneratePublic(keyAlgorithm, new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(algorithm), Arrays.copyOfRange((byte[])pEnc, (int)pEncOff, (int)pEnc.length)).getEncoded()));
    }

    private PrivateKey implGetPrivateKeyEC(String keyAlgorithm, ECPublicBCPGKey ecPub, ECSecretBCPGKey ecPriv) throws GeneralSecurityException, PGPException {
        ASN1ObjectIdentifier curveOid = ecPub.getCurveOID();
        ECPrivateKeySpec ecPrivSpec = new ECPrivateKeySpec(ecPriv.getX(), this.getECParameterSpec(curveOid, JcaJcePGPUtil.getX9Parameters(curveOid)));
        return this.implGeneratePrivate(keyAlgorithm, ecPrivSpec);
    }

    private PublicKey implGetPublicKeyEC(String keyAlgorithm, ECPublicBCPGKey ecPub) throws GeneralSecurityException, IOException, PGPException {
        ASN1ObjectIdentifier curveOID = ecPub.getCurveOID();
        X9ECParameters x9Params = JcaJcePGPUtil.getX9Parameters(curveOID);
        org.bouncycastle.math.ec.ECPoint ecPubPoint = JcaJcePGPUtil.decodePoint(ecPub.getEncodedPoint(), x9Params.getCurve());
        ECPublicKeySpec ecPubSpec = new ECPublicKeySpec(new ECPoint(ecPubPoint.getAffineXCoord().toBigInteger(), ecPubPoint.getAffineYCoord().toBigInteger()), this.getECParameterSpec(curveOID, x9Params));
        return this.implGeneratePublic(keyAlgorithm, ecPubSpec);
    }

    private PublicKey get25519PublicKey(BigInteger x, ASN1ObjectIdentifier algorithm, String keyAlgorithm, String name) throws PGPException, GeneralSecurityException, IOException {
        byte[] pEnc = BigIntegers.asUnsignedByteArray((BigInteger)x);
        if (pEnc.length < 1 || 64 != pEnc[0]) {
            throw new IllegalArgumentException("Invalid " + name + "25519 public key");
        }
        return this.implGetPublicKeyX509(pEnc, 1, algorithm, keyAlgorithm);
    }

    @FunctionalInterface
    private static interface BCPGKeyOperation {
        public BCPGKey getBCPGKey(byte[] var1);
    }

    @FunctionalInterface
    private static interface Operation {
        public PrivateKeyInfo getPrivateKeyInfos() throws IOException;
    }
}

