/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.encoders.Hex;

class RFC6637KDFCalculator {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode((String)"416E6F6E796D6F75732053656E64657220202020");
    private final PGPDigestCalculator digCalc;
    private final int keyAlgorithm;

    public RFC6637KDFCalculator(PGPDigestCalculator digCalc, int keyAlgorithm) {
        this.digCalc = digCalc;
        this.keyAlgorithm = keyAlgorithm;
    }

    public byte[] createKey(ECPoint s, byte[] userKeyingMaterial) throws PGPException {
        return this.createKey(s.getAffineXCoord().getEncoded(), userKeyingMaterial);
    }

    public byte[] createKey(byte[] secret, byte[] userKeyingMaterial) throws PGPException {
        try {
            return RFC6637KDFCalculator.KDF(this.digCalc, secret, RFC6637KDFCalculator.getKeyLen(this.keyAlgorithm), userKeyingMaterial);
        }
        catch (IOException e) {
            throw new PGPException("Exception performing KDF: " + e.getMessage(), e);
        }
    }

    private static byte[] KDF(PGPDigestCalculator digCalc, byte[] ZB, int keyLen, byte[] param) throws IOException {
        OutputStream dOut = digCalc.getOutputStream();
        dOut.write(0);
        dOut.write(0);
        dOut.write(0);
        dOut.write(1);
        dOut.write(ZB);
        dOut.write(param);
        byte[] digest = digCalc.getDigest();
        byte[] key = new byte[keyLen];
        System.arraycopy(digest, 0, key, 0, key.length);
        return key;
    }

    private static int getKeyLen(int algID) throws PGPException {
        switch (algID) {
            case 7: {
                return 16;
            }
            case 8: {
                return 24;
            }
            case 9: {
                return 32;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + algID);
    }
}

