/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import org.bouncycastle.util.BigIntegers;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey key) {
        super(key);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pubKey, byte[] sessionInfo) throws PGPException {
        try {
            AsymmetricKeyParameter cryptoPublicKey = this.keyConverter.getPublicKey(pubKey);
            if (pubKey.getAlgorithm() == 18) {
                PublicKeyPacket pubKeyPacket = pubKey.getPublicKeyPacket();
                ECDHPublicBCPGKey ecPubKey = (ECDHPublicBCPGKey)pubKeyPacket.getKey();
                byte[] userKeyingMaterial = RFC6637Utils.createUserKeyingMaterial(pubKeyPacket, new BcKeyFingerprintCalculator());
                if (ecPubKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                    X25519KeyPairGenerator gen = new X25519KeyPairGenerator();
                    gen.init((KeyGenerationParameters)new X25519KeyGenerationParameters(this.random));
                    AsymmetricCipherKeyPair ephKp = gen.generateKeyPair();
                    X25519Agreement agreement = new X25519Agreement();
                    agreement.init((CipherParameters)ephKp.getPrivate());
                    byte[] secret = new byte[agreement.getAgreementSize()];
                    agreement.calculateAgreement((CipherParameters)cryptoPublicKey, secret, 0);
                    byte[] ephPubEncoding = new byte[33];
                    ephPubEncoding[0] = 64;
                    ((X25519PublicKeyParameters)ephKp.getPublic()).encode(ephPubEncoding, 1);
                    return this.encryptSessionInfo(ecPubKey, sessionInfo, secret, userKeyingMaterial, ephPubEncoding);
                }
                ECDomainParameters ecParams = ((ECPublicKeyParameters)cryptoPublicKey).getParameters();
                ECKeyPairGenerator gen = new ECKeyPairGenerator();
                gen.init((KeyGenerationParameters)new ECKeyGenerationParameters(ecParams, this.random));
                AsymmetricCipherKeyPair ephKp = gen.generateKeyPair();
                ECDHBasicAgreement agreement = new ECDHBasicAgreement();
                agreement.init((CipherParameters)ephKp.getPrivate());
                BigInteger S = agreement.calculateAgreement((CipherParameters)cryptoPublicKey);
                byte[] secret = BigIntegers.asUnsignedByteArray((int)agreement.getFieldSize(), (BigInteger)S);
                byte[] ephPubEncoding = ((ECPublicKeyParameters)ephKp.getPublic()).getQ().getEncoded(false);
                return this.encryptSessionInfo(ecPubKey, sessionInfo, secret, userKeyingMaterial, ephPubEncoding);
            }
            AsymmetricBlockCipher c = BcImplProvider.createPublicKeyCipher(pubKey.getAlgorithm());
            c.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)cryptoPublicKey, this.random));
            return c.processBlock(sessionInfo, 0, sessionInfo.length);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("exception encrypting session info: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new PGPException("exception encrypting session info: " + e.getMessage(), e);
        }
    }

    private byte[] encryptSessionInfo(ECDHPublicBCPGKey ecPubKey, byte[] sessionInfo, byte[] secret, byte[] userKeyingMaterial, byte[] ephPubEncoding) throws IOException, PGPException {
        RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(ecPubKey.getHashAlgorithm()), ecPubKey.getSymmetricKeyAlgorithm());
        KeyParameter key = new KeyParameter(rfc6637KDFCalculator.createKey(secret, userKeyingMaterial));
        byte[] paddedSessionData = PGPPad.padSessionData(sessionInfo, this.sessionKeyObfuscation);
        Wrapper c = BcImplProvider.createWrapper(ecPubKey.getSymmetricKeyAlgorithm());
        c.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)key, this.random));
        byte[] C = c.wrap(paddedSessionData, 0, paddedSessionData.length);
        byte[] VB = new MPInteger(new BigInteger(1, ephPubEncoding)).getEncoded();
        byte[] rv = new byte[VB.length + 1 + C.length];
        System.arraycopy(VB, 0, rv, 0, VB.length);
        rv[VB.length] = (byte)C.length;
        System.arraycopy(C, 0, rv, VB.length + 1, C.length);
        return rv;
    }
}

