/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.math.ec.ECPoint;

public class ECDHPublicBCPGKey
extends ECPublicBCPGKey {
    private byte reserved;
    private byte hashFunctionId;
    private byte symAlgorithmId;

    public ECDHPublicBCPGKey(BCPGInputStream in) throws IOException {
        super(in);
        int length = in.read();
        byte[] kdfParameters = new byte[length];
        if (kdfParameters.length != 3) {
            throw new IllegalStateException("kdf parameters size of 3 expected.");
        }
        in.readFully(kdfParameters);
        this.reserved = kdfParameters[0];
        this.hashFunctionId = kdfParameters[1];
        this.symAlgorithmId = kdfParameters[2];
        this.verifyHashAlgorithm();
        this.verifySymmetricKeyAlgorithm();
    }

    public ECDHPublicBCPGKey(ASN1ObjectIdentifier oid, ECPoint point, int hashAlgorithm, int symmetricKeyAlgorithm) {
        super(oid, point);
        this.reserved = 1;
        this.hashFunctionId = (byte)hashAlgorithm;
        this.symAlgorithmId = (byte)symmetricKeyAlgorithm;
        this.verifyHashAlgorithm();
        this.verifySymmetricKeyAlgorithm();
    }

    public ECDHPublicBCPGKey(ASN1ObjectIdentifier oid, BigInteger point, int hashAlgorithm, int symmetricKeyAlgorithm) {
        super(oid, point);
        this.reserved = 1;
        this.hashFunctionId = (byte)hashAlgorithm;
        this.symAlgorithmId = (byte)symmetricKeyAlgorithm;
        this.verifyHashAlgorithm();
        this.verifySymmetricKeyAlgorithm();
    }

    public byte getReserved() {
        return this.reserved;
    }

    public byte getHashAlgorithm() {
        return this.hashFunctionId;
    }

    public byte getSymmetricKeyAlgorithm() {
        return this.symAlgorithmId;
    }

    public void encode(BCPGOutputStream out) throws IOException {
        super.encode(out);
        out.write(3);
        out.write(this.reserved);
        out.write(this.hashFunctionId);
        out.write(this.symAlgorithmId);
    }

    private void verifyHashAlgorithm() {
        switch (this.hashFunctionId) {
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalStateException("Hash algorithm must be SHA-256 or stronger.");
            }
        }
    }

    private void verifySymmetricKeyAlgorithm() {
        switch (this.symAlgorithmId) {
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalStateException("Symmetric key algorithm must be AES-128 or stronger.");
            }
        }
    }
}

