/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.util.Iterable;

public class PGPSecretKeyRing
extends PGPKeyRing
implements Iterable {
    private static final Logger LOG = Logger.getLogger(PGPSecretKeyRing.class.getName());
    List keys;
    List extraPubKeys;

    private static List checkKeys(List keys) {
        ArrayList<PGPSecretKey> rv = new ArrayList<PGPSecretKey>(keys.size());
        for (int i = 0; i != keys.size(); ++i) {
            PGPSecretKey k = (PGPSecretKey)keys.get(i);
            if (i == 0) {
                if (!k.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (k.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            rv.add(k);
        }
        return rv;
    }

    public PGPSecretKeyRing(List secKeys) {
        this(PGPSecretKeyRing.checkKeys(secKeys), new ArrayList());
    }

    private PGPSecretKeyRing(List keys, List extraPubKeys) {
        this.keys = keys;
        this.extraPubKeys = extraPubKeys;
    }

    public PGPSecretKeyRing(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    public PGPSecretKeyRing(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this.keys = new ArrayList();
        this.extraPubKeys = new ArrayList();
        BCPGInputStream pIn = BCPGInputStream.wrap(in);
        int initialTag = pIn.skipMarkerAndPaddingPackets();
        if (initialTag != 5 && initialTag != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        SecretKeyPacket secret = (SecretKeyPacket)pIn.readPacket();
        while (pIn.nextPacketTag() == 61) {
            pIn.readPacket();
        }
        TrustPacket trust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPSecretKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        this.keys.add(new PGPSecretKey(secret, new PGPPublicKey(secret.getPublicKeyPacket(), trust, keySigs, ids, idTrusts, idSigs, fingerPrintCalculator)));
        while (pIn.nextPacketTag() == 7 || pIn.nextPacketTag() == 14) {
            try {
                List sigList;
                TrustPacket subTrust;
                ContainedPacket sub;
                if (pIn.nextPacketTag() == 7) {
                    sub = (SecretSubkeyPacket)pIn.readPacket();
                    while (pIn.nextPacketTag() == 61) {
                        pIn.readPacket();
                    }
                    subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
                    sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
                    this.keys.add(new PGPSecretKey((SecretKeyPacket)sub, new PGPPublicKey(((SecretKeyPacket)sub).getPublicKeyPacket(), subTrust, sigList, fingerPrintCalculator)));
                    continue;
                }
                sub = (PublicSubkeyPacket)pIn.readPacket();
                subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
                sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
                this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)sub, subTrust, sigList, fingerPrintCalculator));
            }
            catch (EOFException e) {
                throw e;
            }
            catch (ArmoredInputException e) {
                throw e;
            }
            catch (IOException e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown subkey: " + e.getMessage());
            }
        }
    }

    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    public PGPPublicKey getPublicKey(long keyID) {
        PGPSecretKey key = this.getSecretKey(keyID);
        if (key != null) {
            return key.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.extraPubKeys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(byte[] fingerprint) {
        PGPSecretKey key = this.getSecretKey(fingerprint);
        if (key != null) {
            return key.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.extraPubKeys.get(i);
            if (!k.hasFingerprint(fingerprint)) continue;
            return k;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(KeyIdentifier identifier) {
        Object k;
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            k = (PGPSecretKey)it.next();
            if (((PGPSecretKey)k).getPublicKey() == null || !identifier.matchesExplicit(((PGPSecretKey)k).getKeyIdentifier())) continue;
            return ((PGPSecretKey)k).getPublicKey();
        }
        it = this.extraPubKeys.iterator();
        while (it.hasNext()) {
            k = (PGPPublicKey)it.next();
            if (!identifier.matchesExplicit(((PGPPublicKey)k).getKeyIdentifier())) continue;
            return k;
        }
        return null;
    }

    public Iterator getPublicKeys(KeyIdentifier identifier) {
        Object k;
        ArrayList<Object> matches = new ArrayList<Object>();
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            k = (PGPSecretKey)it.next();
            if (((PGPSecretKey)k).getPublicKey() == null || !identifier.matchesExplicit(((PGPSecretKey)k).getKeyIdentifier())) continue;
            matches.add(((PGPSecretKey)k).getPublicKey());
        }
        it = this.extraPubKeys.iterator();
        while (it.hasNext()) {
            k = (PGPPublicKey)it.next();
            if (!identifier.matchesExplicit(((PGPPublicKey)k).getKeyIdentifier())) continue;
            matches.add(k);
        }
        return matches.iterator();
    }

    public PGPSecretKey getSecretKey(KeyIdentifier identifier) {
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            PGPSecretKey k = (PGPSecretKey)it.next();
            if (!identifier.matchesExplicit(k.getKeyIdentifier())) continue;
            return k;
        }
        return null;
    }

    public Iterator getSecretKeys(KeyIdentifier identifier) {
        ArrayList<PGPSecretKey> matches = new ArrayList<PGPSecretKey>();
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            PGPSecretKey k = (PGPSecretKey)it.next();
            if (!identifier.matchesExplicit(k.getKeyIdentifier())) continue;
            matches.add(k);
        }
        return matches.iterator();
    }

    public Iterator getKeysWithSignaturesBy(long keyID) {
        ArrayList<PGPPublicKey> keysWithSigs = new ArrayList<PGPPublicKey>();
        Iterator keyIt = this.getPublicKeys();
        while (keyIt.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)keyIt.next();
            Iterator sigIt = k.getSignaturesForKeyID(keyID);
            if (!sigIt.hasNext()) continue;
            keysWithSigs.add(k);
        }
        return keysWithSigs.iterator();
    }

    public Iterator getKeysWithSignaturesBy(KeyIdentifier identifier) {
        Iterator sigIt;
        Object k;
        ArrayList<Object> keysWithSigs = new ArrayList<Object>();
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            k = (PGPSecretKey)it.next();
            if (((PGPSecretKey)k).getPublicKey() == null || !(sigIt = ((PGPSecretKey)k).getPublicKey().getSignaturesForKey(identifier)).hasNext()) continue;
            keysWithSigs.add(((PGPSecretKey)k).getPublicKey());
        }
        it = this.extraPubKeys.iterator();
        while (it.hasNext()) {
            k = (PGPPublicKey)it.next();
            sigIt = ((PGPPublicKey)k).getSignaturesForKey(identifier);
            if (!sigIt.hasNext()) continue;
            keysWithSigs.add(k);
        }
        return keysWithSigs.iterator();
    }

    public Iterator getPublicKeys() {
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        Iterator it = this.getSecretKeys();
        while (it.hasNext()) {
            PGPPublicKey key = ((PGPSecretKey)it.next()).getPublicKey();
            pubKeys.add(key);
        }
        pubKeys.addAll(this.extraPubKeys);
        return Collections.unmodifiableList(pubKeys).iterator();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long keyID) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey k = (PGPSecretKey)this.keys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    public PGPSecretKey getSecretKey(byte[] fingerprint) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey k = (PGPSecretKey)this.keys.get(i);
            if (!k.getPublicKey().hasFingerprint(fingerprint)) continue;
            return k;
        }
        return null;
    }

    public Iterator getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    public int size() {
        return this.keys.size();
    }

    public PGPPublicKeyRing toCertificate() {
        ArrayList pubKeys = new ArrayList();
        Iterator it = this.getPublicKeys();
        while (it.hasNext()) {
            pubKeys.add(it.next());
        }
        return new PGPPublicKeyRing(pubKeys);
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat format) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream((OutputStream)bOut, format);
        this.encode(pOut);
        pOut.close();
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        Object k;
        int i;
        for (i = 0; i != this.keys.size(); ++i) {
            k = (PGPSecretKey)this.keys.get(i);
            ((PGPSecretKey)k).encode(outStream);
        }
        for (i = 0; i != this.extraPubKeys.size(); ++i) {
            k = (PGPPublicKey)this.extraPubKeys.get(i);
            ((PGPPublicKey)k).encode(outStream);
        }
    }

    public Iterator iterator() {
        return this.getSecretKeys();
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing secretRing, PGPPublicKeyRing publicRing) {
        ArrayList<PGPSecretKey> newList = new ArrayList<PGPSecretKey>(secretRing.keys.size());
        Iterator it = secretRing.keys.iterator();
        while (it.hasNext()) {
            PGPSecretKey sk = (PGPSecretKey)it.next();
            PGPPublicKey pk = publicRing.getPublicKey(sk.getKeyID());
            newList.add(PGPSecretKey.replacePublicKey(sk, pk));
        }
        return new PGPSecretKeyRing(newList);
    }

    public static PGPSecretKeyRing insertOrReplacePublicKey(PGPSecretKeyRing secretRing, PGPPublicKey publicKey) {
        PGPSecretKey secretKey = secretRing.getSecretKey(publicKey.getKeyID());
        if (secretKey != null) {
            ArrayList<PGPSecretKey> newList = new ArrayList<PGPSecretKey>(secretRing.keys.size());
            Iterator it = secretRing.getSecretKeys();
            while (it.hasNext()) {
                PGPSecretKey sk = (PGPSecretKey)it.next();
                if (sk.getKeyID() != publicKey.getKeyID()) continue;
                sk = PGPSecretKey.replacePublicKey(secretKey, publicKey);
                newList.add(sk);
            }
            return new PGPSecretKeyRing(newList);
        }
        ArrayList<PGPPublicKey> extras = new ArrayList<PGPPublicKey>(secretRing.extraPubKeys.size());
        boolean found = false;
        Iterator it = secretRing.getExtraPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey pk = (PGPPublicKey)it.next();
            if (pk.getKeyID() == publicKey.getKeyID()) {
                extras.add(publicKey);
                found = true;
                continue;
            }
            extras.add(pk);
        }
        if (!found) {
            extras.add(publicKey);
        }
        return new PGPSecretKeyRing(new ArrayList(secretRing.keys), extras);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing ring, PBESecretKeyDecryptor oldKeyDecryptor, PBESecretKeyEncryptor newKeyEncryptor) throws PGPException {
        ArrayList<PGPSecretKey> newKeys = new ArrayList<PGPSecretKey>(ring.keys.size());
        Iterator keys = ring.getSecretKeys();
        while (keys.hasNext()) {
            PGPSecretKey key = (PGPSecretKey)keys.next();
            if (key.isPrivateKeyEmpty()) {
                newKeys.add(key);
                continue;
            }
            newKeys.add(PGPSecretKey.copyWithNewPassword(key, oldKeyDecryptor, newKeyEncryptor));
        }
        return new PGPSecretKeyRing(newKeys, ring.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>(secRing.keys);
        boolean found = false;
        boolean masterFound = false;
        for (int i = 0; i != keys.size(); ++i) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() == secKey.getKeyID()) {
                found = true;
                keys.set(i, secKey);
            }
            if (!key.isMasterKey()) continue;
            masterFound = true;
        }
        if (!found) {
            if (secKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, secKey);
            } else {
                keys.add(secKey);
            }
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        int count = secRing.keys.size();
        long keyID = secKey.getKeyID();
        ArrayList<PGPSecretKey> result = new ArrayList<PGPSecretKey>(count);
        boolean found = false;
        for (int i = 0; i < count; ++i) {
            PGPSecretKey key = (PGPSecretKey)secRing.keys.get(i);
            if (key.getKeyID() == keyID) {
                found = true;
                continue;
            }
            result.add(key);
        }
        if (!found) {
            return null;
        }
        return new PGPSecretKeyRing(result, secRing.extraPubKeys);
    }
}

