/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class RevocationReason
extends SignatureSubpacket {
    public RevocationReason(boolean isCritical, boolean isLongLength, byte[] data) {
        super(29, isCritical, isLongLength, data);
    }

    public RevocationReason(boolean isCritical, byte reason, String description) {
        super(29, isCritical, false, RevocationReason.createData(reason, description));
    }

    private static byte[] createData(byte reason, String description) {
        return Arrays.prepend((byte[])Strings.toUTF8ByteArray((String)description), (byte)reason);
    }

    public byte getRevocationReason() {
        return this.data[0];
    }

    public String getRevocationDescription() {
        if (this.data.length == 1) {
            return "";
        }
        return Strings.fromUTF8ByteArray((byte[])this.data, (int)1, (int)(this.data.length - 1));
    }
}

