/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;

public class JcaPGPKeyPair
extends PGPKeyPair {
    private static PGPPublicKey getPublicKey(int algorithm, PublicKey pubKey, Date date) throws PGPException {
        return JcaPGPKeyPair.getPublicKey(4, algorithm, pubKey, date);
    }

    private static PGPPublicKey getPublicKey(int version, int algorithm, PublicKey pubKey, Date date) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPublicKey(version, algorithm, pubKey, date);
    }

    private static PGPPublicKey getPublicKey(int algorithm, PGPAlgorithmParameters algorithmParameters, PublicKey pubKey, Date date) throws PGPException {
        return JcaPGPKeyPair.getPublicKey(4, algorithm, algorithmParameters, pubKey, date);
    }

    private static PGPPublicKey getPublicKey(int version, int algorithm, PGPAlgorithmParameters algorithmParameters, PublicKey pubKey, Date date) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPublicKey(version, algorithm, algorithmParameters, pubKey, date);
    }

    private static PGPPrivateKey getPrivateKey(PGPPublicKey pub, PrivateKey privKey) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPrivateKey(pub, privKey);
    }

    public JcaPGPKeyPair(int algorithm, KeyPair keyPair, Date date) throws PGPException {
        this(4, algorithm, keyPair, date);
    }

    public JcaPGPKeyPair(int version, int algorithm, KeyPair keyPair, Date date) throws PGPException {
        this.pub = JcaPGPKeyPair.getPublicKey(version, algorithm, keyPair.getPublic(), date);
        this.priv = JcaPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }

    public JcaPGPKeyPair(int algorithm, PGPAlgorithmParameters parameters, KeyPair keyPair, Date date) throws PGPException {
        this(4, algorithm, parameters, keyPair, date);
    }

    public JcaPGPKeyPair(int version, int algorithm, PGPAlgorithmParameters parameters, KeyPair keyPair, Date date) throws PGPException {
        this.pub = JcaPGPKeyPair.getPublicKey(version, algorithm, parameters, keyPair.getPublic(), date);
        this.priv = JcaPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }
}

