/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.SignerOutputStream;

public class BcPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public PGPContentVerifierBuilder get(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        return new BcPGPContentVerifierBuilder(keyAlgorithm, hashAlgorithm);
    }

    private class BcPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public BcPGPContentVerifierBuilder(int keyAlgorithm, int hashAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            this.hashAlgorithm = hashAlgorithm;
        }

        public PGPContentVerifier build(PGPPublicKey publicKey) throws PGPException {
            AsymmetricKeyParameter pubParam = BcPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(publicKey);
            Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, (CipherParameters)pubParam);
            signer.init(false, (CipherParameters)pubParam);
            return new PGPContentVerifier(this, publicKey, signer){
                private final /* synthetic */ PGPPublicKey val$publicKey;
                private final /* synthetic */ Signer val$signer;
                private final /* synthetic */ BcPGPContentVerifierBuilder this$1;
                {
                    this.this$1 = this$1;
                    this.val$publicKey = val$publicKey;
                    this.val$signer = val$signer;
                }

                public int getHashAlgorithm() {
                    return BcPGPContentVerifierBuilder.access$100(this.this$1);
                }

                public int getKeyAlgorithm() {
                    return BcPGPContentVerifierBuilder.access$200(this.this$1);
                }

                public long getKeyID() {
                    return this.val$publicKey.getKeyID();
                }

                public boolean verify(byte[] expected) {
                    return this.val$signer.verifySignature(expected);
                }

                public OutputStream getOutputStream() {
                    return new SignerOutputStream(this.val$signer);
                }
            };
        }

        static /* synthetic */ int access$100(BcPGPContentVerifierBuilder x0) {
            return x0.hashAlgorithm;
        }

        static /* synthetic */ int access$200(BcPGPContentVerifierBuilder x0) {
            return x0.keyAlgorithm;
        }
    }
}

