/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class EllipticCurveKeyPairGenerator {
    private static final int SIG_HASH = 10;
    private static final int[] HASH_PREFERENCES = new int[]{10, 9, 8, 11};
    private static final int[] SYM_PREFERENCES = new int[]{9, 8, 7};
    private static final int[] COMP_PREFERENCES = new int[]{2, 3, 2, 0};

    private static void generateAndExportKeyRing(OutputStream secretOut, OutputStream publicOut, String identity, char[] passPhrase, boolean armor) throws IOException, NoSuchProviderException, PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (armor) {
            secretOut = new ArmoredOutputStream(secretOut);
        }
        PGPDigestCalculator sha1Calc = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        KeyPairGenerator eddsaGen = KeyPairGenerator.getInstance("EdDSA", "BC");
        KeyPairGenerator xdhGen = KeyPairGenerator.getInstance("XDH", "BC");
        JcaPGPContentSignerBuilder contentSignerBuilder = new JcaPGPContentSignerBuilder(22, 10);
        PBESecretKeyEncryptor secretKeyEncryptor = new JcePBESecretKeyEncryptorBuilder(9, sha1Calc).build(passPhrase);
        Date now = new Date();
        eddsaGen.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("ed25519"));
        KeyPair primaryKP = eddsaGen.generateKeyPair();
        JcaPGPKeyPair primaryKey = new JcaPGPKeyPair(22, primaryKP, now);
        PGPSignatureSubpacketGenerator primarySubpackets = new PGPSignatureSubpacketGenerator();
        primarySubpackets.setKeyFlags(true, 1);
        primarySubpackets.setPreferredHashAlgorithms(false, HASH_PREFERENCES);
        primarySubpackets.setPreferredSymmetricAlgorithms(false, SYM_PREFERENCES);
        primarySubpackets.setPreferredCompressionAlgorithms(false, COMP_PREFERENCES);
        primarySubpackets.setFeature(false, (byte)1);
        primarySubpackets.setIssuerFingerprint(false, primaryKey.getPublicKey());
        eddsaGen.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("ed25519"));
        KeyPair signingKP = eddsaGen.generateKeyPair();
        JcaPGPKeyPair signingKey = new JcaPGPKeyPair(22, signingKP, now);
        PGPSignatureSubpacketGenerator signingKeySubpacket = new PGPSignatureSubpacketGenerator();
        signingKeySubpacket.setKeyFlags(true, 2);
        signingKeySubpacket.setIssuerFingerprint(false, primaryKey.getPublicKey());
        xdhGen.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("X25519"));
        KeyPair encryptionKP = xdhGen.generateKeyPair();
        JcaPGPKeyPair encryptionKey = new JcaPGPKeyPair(18, encryptionKP, now);
        PGPSignatureSubpacketGenerator encryptionKeySubpackets = new PGPSignatureSubpacketGenerator();
        encryptionKeySubpackets.setKeyFlags(true, 12);
        encryptionKeySubpackets.setIssuerFingerprint(false, primaryKey.getPublicKey());
        PGPKeyRingGenerator gen = new PGPKeyRingGenerator(19, primaryKey, identity, sha1Calc, primarySubpackets.generate(), null, contentSignerBuilder, secretKeyEncryptor);
        gen.addSubKey(signingKey, signingKeySubpacket.generate(), null, contentSignerBuilder);
        gen.addSubKey(encryptionKey, encryptionKeySubpackets.generate(), null);
        PGPSecretKeyRing secretKeys = gen.generateSecretKeyRing();
        secretKeys.encode(secretOut);
        secretOut.close();
        if (armor) {
            publicOut = new ArmoredOutputStream(publicOut);
        }
        ArrayList publicKeyList = new ArrayList();
        Iterator it = secretKeys.getPublicKeys();
        while (it.hasNext()) {
            publicKeyList.add(it.next());
        }
        PGPPublicKeyRing publicKeys = new PGPPublicKeyRing(publicKeyList);
        publicKeys.encode(publicOut);
        publicOut.close();
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args.length < 2) {
            System.out.println("EllipticCurveKeyPairGenerator [-a] identity passPhrase");
            System.exit(0);
        }
        if (args[0].equals("-a")) {
            if (args.length < 3) {
                System.out.println("EllipticCurveKeyPairGenerator [-a] identity passPhrase");
                System.exit(0);
            }
            FileOutputStream out1 = new FileOutputStream("secret.asc");
            FileOutputStream out2 = new FileOutputStream("pub.asc");
            EllipticCurveKeyPairGenerator.generateAndExportKeyRing(out1, out2, args[1], args[2].toCharArray(), true);
        } else {
            FileOutputStream out1 = new FileOutputStream("secret.bpg");
            FileOutputStream out2 = new FileOutputStream("pub.bpg");
            EllipticCurveKeyPairGenerator.generateAndExportKeyRing(out1, out2, args[0], args[1].toCharArray(), false);
        }
    }
}

