/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.gpg.SExpression;
import org.bouncycastle.openpgp.ExtendedPGPSecretKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPExtendedKeyHeader;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;

public class OpenedPGPKeyData {
    private final List headerList;
    private final SExpression keyExpression;

    public OpenedPGPKeyData(List headerList, SExpression keyExpression) {
        this.headerList = Collections.unmodifiableList(headerList);
        this.keyExpression = keyExpression;
    }

    public List getHeaderList() {
        return this.headerList;
    }

    public SExpression getKeyExpression() {
        return this.keyExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyType() {
        return null;
    }

    public ExtendedPGPSecretKey getKeyData(PGPPublicKey publicKey, PGPDigestCalculatorProvider digestCalculatorProvider, PBEProtectionRemoverFactory keyProtectionRemoverFactory, KeyFingerPrintCalculator fingerPrintCalculator, int maxDepth) throws PGPException, IOException {
        int type = SExprParser.getProtectionType(this.keyExpression.getString(0));
        ArrayList<PGPExtendedKeyAttribute> attributeList = new ArrayList<PGPExtendedKeyAttribute>();
        if (type == 1 || type == 2 || type == 3) {
            SExpression expression = this.getKeyExpression().getExpression(1);
            String keyType = expression.getString(0);
            PublicKeyAlgorithmTags[] secretKey = SExprParser.getPGPSecretKey(keyProtectionRemoverFactory, fingerPrintCalculator, publicKey, maxDepth, type, expression, keyType, digestCalculatorProvider);
            if (keyType.equals("rsa")) {
                Iterator it = expression.filterOut(new String[]{"rsa", "e", "n", "d", "p", "q", "u", "protected"}).getValues().iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (o instanceof SExpression) {
                        attributeList.add(((SExpression)o).toAttribute());
                        continue;
                    }
                    attributeList.add(PGPExtendedKeyAttribute.builder().addAttribute(o).build());
                }
            }
            return new ExtendedPGPSecretKey(this.headerList, attributeList, (SecretKeyPacket)secretKey[0], (PGPPublicKey)secretKey[1]);
        }
        return null;
    }

    public static class Builder {
        private List headerList = new ArrayList();
        private SExpression keyExpression;

        public Builder setHeaderList(List headerList) {
            this.headerList = headerList;
            return this;
        }

        public Builder setKeyExpression(SExpression keyExpression) {
            this.keyExpression = keyExpression;
            return this;
        }

        public OpenedPGPKeyData build() {
            return new OpenedPGPKeyData(this.headerList, this.keyExpression);
        }

        public void add(PGPExtendedKeyHeader pgpExtendedKeyHeader) {
            this.headerList.add(pgpExtendedKeyHeader);
        }
    }
}

