/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.InputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSymmetricKeyEncryptedData;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public class PGPPBEEncryptedData
extends PGPSymmetricKeyEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
        PGPPBEEncryptedData.enforceConstraints(keyData, encData);
    }

    private static void enforceConstraints(SymmetricKeyEncSessionPacket keyData, InputStreamPacket encData) {
        SymmetricEncIntegrityPacket seipd;
        switch (keyData.getVersion()) {
            case 4: {
                if (encData instanceof SymmetricEncDataPacket) {
                    return;
                }
                if (encData instanceof SymmetricEncIntegrityPacket) {
                    SymmetricEncIntegrityPacket seipd2 = (SymmetricEncIntegrityPacket)encData;
                    if (seipd2.getVersion() == 1) {
                        return;
                    }
                    throw new IllegalArgumentException("Version 4 SKESK cannot precede SEIPD of version " + seipd2.getVersion());
                }
            }
            case 5: {
                break;
            }
            case 6: {
                if (!(encData instanceof SymmetricEncIntegrityPacket)) {
                    throw new IllegalArgumentException("Version 6 SKESK MUST be followed only by SEIPD version 2");
                }
                seipd = (SymmetricEncIntegrityPacket)encData;
                if (seipd.getVersion() == 2) break;
                throw new IllegalArgumentException("Version 6 SKESK MUST be followed only by SEIPD version 2");
            }
        }
        if (encData instanceof SymmetricEncDataPacket && keyData.getVersion() != 4) {
            throw new IllegalArgumentException("Version of SKESK packet preceding a SED packet can only be 4.");
        }
        if (encData instanceof SymmetricEncIntegrityPacket) {
            seipd = (SymmetricEncIntegrityPacket)encData;
            if (keyData.getVersion() == 4 && seipd.getVersion() != 1) {
                throw new IllegalArgumentException("Version 4 SKESK can only precede version 1 SEIPD.");
            }
            if (keyData.getVersion() == 6 && seipd.getVersion() == 1) {
                throw new IllegalArgumentException("Version 6 SKESK packet MUST NOT precede a V1 SEIPD packet.");
            }
        }
    }

    public int getVersion() {
        return this.keyData.getVersion();
    }

    public int getAlgorithm() {
        return this.keyData.getEncAlgorithm();
    }

    public int getSymmetricAlgorithm(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        if (this.keyData.getVersion() == 4) {
            byte[] key = dataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
            byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), key, this.keyData.getSecKeyData());
            return sessionData[0];
        }
        if (this.keyData.getVersion() == 5) {
            return this.keyData.getEncAlgorithm();
        }
        return ((SymmetricEncIntegrityPacket)this.encData).getCipherAlgorithm();
    }

    public PGPSessionKey getSessionKey(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] key = dataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        int version = this.getVersion();
        if (version == 4) {
            byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), key, this.keyData.getSecKeyData());
            int sessionKeyAlg = sessionData[0] & 0xFF;
            byte[] sessionKey = Arrays.copyOfRange((byte[])sessionData, (int)1, (int)sessionData.length);
            return new PGPSessionKey(sessionKeyAlg, sessionKey);
        }
        if (version == 5 || version == 6) {
            int sessionKeyAlg = this.getSymmetricAlgorithm(dataDecryptorFactory);
            byte[] sessionKey = dataDecryptorFactory.recoverAEADEncryptedSessionData(this.keyData, key);
            return new PGPSessionKey(sessionKeyAlg, sessionKey);
        }
        throw new UnsupportedPacketVersionException("Unsupported packet version: " + version);
    }

    public InputStream getDataStream(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey sessionKey = this.getSessionKey(dataDecryptorFactory);
            this.encStream = this.createDecryptionStream(dataDecryptorFactory, sessionKey);
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey sessionKey = dataDecryptorFactory.getSessionKey();
            this.encStream = this.createDecryptionStream(dataDecryptorFactory, sessionKey);
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }
}

