/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.TreeKEM.LeafIndex;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.SenderType;

public class Sender
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    SenderType senderType;
    LeafIndex sender;
    int sender_index;

    public SenderType getSenderType() {
        return this.senderType;
    }

    public LeafIndex getSender() {
        return this.sender;
    }

    public int getSenderIndex() {
        return this.sender_index;
    }

    public static Sender forNewMemberCommit() {
        return new Sender(SenderType.NEW_MEMBER_COMMIT, null, -1);
    }

    public static Sender forNewMemberProposal() {
        return new Sender(SenderType.NEW_MEMBER_PROPOSAL, null, -1);
    }

    public static Sender forMember(LeafIndex sender) {
        return new Sender(SenderType.MEMBER, sender, -1);
    }

    public static Sender forExternal(int senderIndex) {
        return new Sender(SenderType.EXTERNAL, null, senderIndex);
    }

    public Sender(SenderType senderType, LeafIndex sender, int sender_index) {
        this.senderType = senderType;
        this.sender = sender;
        this.sender_index = sender_index;
    }

    public Sender(MLSInputStream stream) throws IOException {
        this.senderType = SenderType.values()[(Byte)stream.read(Byte.TYPE)];
        switch (this.senderType) {
            case MEMBER: {
                this.sender = (LeafIndex)stream.read(LeafIndex.class);
                break;
            }
            case EXTERNAL: {
                this.sender_index = (Integer)stream.read(Integer.TYPE);
                break;
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.senderType);
        switch (this.senderType) {
            case MEMBER: {
                stream.write(this.sender);
                break;
            }
            case EXTERNAL: {
                stream.write(this.sender_index);
                break;
            }
        }
    }
}

