/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.Proposal;
import org.bouncycastle.mls.codec.ProposalOrRefType;

public class ProposalOrRef
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    ProposalOrRefType type;
    Proposal proposal;
    byte[] reference;

    public ProposalOrRefType getType() {
        return this.type;
    }

    public Proposal getProposal() {
        return this.proposal;
    }

    public byte[] getReference() {
        return this.reference;
    }

    public static ProposalOrRef forRef(byte[] ref) {
        return new ProposalOrRef(ProposalOrRefType.REFERENCE, null, ref);
    }

    public static ProposalOrRef forProposal(Proposal proposal) {
        return new ProposalOrRef(ProposalOrRefType.PROPOSAL, proposal, null);
    }

    public ProposalOrRef(ProposalOrRefType type, Proposal proposal, byte[] reference) {
        this.type = type;
        this.proposal = proposal;
        this.reference = reference;
    }

    ProposalOrRef(MLSInputStream stream) throws IOException {
        this.type = ProposalOrRefType.values()[(Byte)stream.read(Byte.TYPE)];
        switch (this.type) {
            case PROPOSAL: {
                this.proposal = (Proposal)stream.read(Proposal.class);
                break;
            }
            case REFERENCE: {
                this.reference = stream.readOpaque();
            }
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.type);
        switch (this.type) {
            case PROPOSAL: {
                stream.write(this.proposal);
                break;
            }
            case REFERENCE: {
                stream.writeOpaque(this.reference);
            }
        }
    }
}

