/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.mls.TreeKEM.LeafNode;
import org.bouncycastle.mls.TreeKEM.LeafNodeSource;
import org.bouncycastle.mls.codec.CredentialType;
import org.bouncycastle.mls.codec.Extension;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.ProtocolVersion;
import org.bouncycastle.mls.crypto.MlsCipherSuite;

public class KeyPackage
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    ProtocolVersion version;
    MlsCipherSuite suite;
    short cipher_suite;
    byte[] init_key;
    LeafNode leaf_node;
    List<Extension> extensions;
    byte[] signature;

    public LeafNode getLeafNode() {
        return this.leaf_node;
    }

    public byte[] getInitKey() {
        return this.init_key;
    }

    public MlsCipherSuite getSuite() {
        return this.suite;
    }

    public boolean verify() throws IOException {
        if (!this.leaf_node.verify(this.suite, this.leaf_node.toBeSigned(new byte[0], -1))) {
            return false;
        }
        if (this.leaf_node.getSource() != LeafNodeSource.KEY_PACKAGE) {
            return false;
        }
        if (this.leaf_node.getCredentialType() == CredentialType.x509) {
            // empty if block
        }
        return this.suite.verifyWithLabel(this.leaf_node.getSignatureKey(), "KeyPackageTBS", this.toBeSigned(), this.signature);
    }

    private byte[] toBeSigned() throws IOException {
        MLSOutputStream stream = new MLSOutputStream();
        stream.write(this.version);
        stream.write(this.cipher_suite);
        stream.writeOpaque(this.init_key);
        stream.write(this.leaf_node);
        stream.writeList(this.extensions);
        return stream.toByteArray();
    }

    public KeyPackage(MlsCipherSuite suite, byte[] init_key, LeafNode leaf_node, List<Extension> extensions, byte[] sigSk) throws IOException, CryptoException {
        this.version = ProtocolVersion.mls10;
        this.cipher_suite = suite.getSuiteID();
        this.suite = suite;
        this.init_key = (byte[])init_key.clone();
        this.leaf_node = leaf_node.copy(leaf_node.getEncryptionKey());
        this.extensions = new ArrayList<Extension>(extensions);
        this.signature = suite.signWithLabel(sigSk, "KeyPackageTBS", this.toBeSigned());
    }

    KeyPackage(MLSInputStream stream) throws Exception {
        this.version = ProtocolVersion.values()[(Short)stream.read(Short.TYPE)];
        this.cipher_suite = (Short)stream.read(Short.TYPE);
        this.suite = MlsCipherSuite.getSuite(this.cipher_suite);
        this.init_key = stream.readOpaque();
        this.leaf_node = (LeafNode)stream.read(LeafNode.class);
        this.extensions = new ArrayList<Extension>();
        stream.readList(this.extensions, Extension.class);
        this.signature = stream.readOpaque();
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.version);
        stream.write(this.cipher_suite);
        stream.writeOpaque(this.init_key);
        stream.write(this.leaf_node);
        stream.writeList(this.extensions);
        stream.writeOpaque(this.signature);
    }
}

