/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.ContentType;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;

class FramedContentAuthData
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    byte[] signature;
    byte[] confirmation_tag;
    ContentType contentType;

    public FramedContentAuthData(ContentType contentType, byte[] signature, byte[] confirmation_tag) {
        this.signature = signature;
        this.contentType = contentType;
        switch (contentType) {
            case RESERVED: 
            case APPLICATION: 
            case PROPOSAL: {
                break;
            }
            case COMMIT: {
                this.confirmation_tag = confirmation_tag;
            }
        }
    }

    public FramedContentAuthData(MLSInputStream stream, ContentType contentType) throws IOException {
        this.contentType = contentType;
        this.signature = stream.readOpaque();
        if (contentType == ContentType.COMMIT) {
            this.confirmation_tag = stream.readOpaque();
        }
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.writeOpaque(this.signature);
        if (this.contentType == ContentType.COMMIT) {
            stream.writeOpaque(this.confirmation_tag);
        }
    }
}

